/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.helper.Direction;

public class MethodHelper {
    private static final String SET = "set";
    private static final String GET = "get";
    private static final String IS = "is";

    private MethodHelper() {
    }

    public static String getPropertyName(Direction direction, String methodName) {
        if (direction.equals((Object)Direction.IN)) {
            return MethodHelper.toNameFromSetter(methodName);
        }
        if (direction.equals((Object)Direction.OUT)) {
            return MethodHelper.toNameFromGetter(methodName);
        }
        return methodName;
    }

    public static boolean isPropertyMethod(Direction direction, String methodName) {
        if (direction.equals((Object)Direction.IN)) {
            return MethodHelper.isSetter(methodName);
        }
        if (direction.equals((Object)Direction.OUT)) {
            return MethodHelper.isGetter(methodName);
        }
        return false;
    }

    private static String toNameFromSetter(String methodName) {
        if (methodName.startsWith(SET) && methodName.length() > 3 && MethodHelper.hasCapitalAt(methodName, 3)) {
            methodName = MethodHelper.removeAndLowerCase(methodName, 3);
        }
        return methodName;
    }

    private static String toNameFromGetter(String methodName) {
        if (methodName.startsWith(GET) && methodName.length() > 3 && MethodHelper.hasCapitalAt(methodName, 3)) {
            methodName = MethodHelper.removeAndLowerCase(methodName, 3);
        } else if (methodName.startsWith(IS) && methodName.length() > 2 && MethodHelper.hasCapitalAt(methodName, 2)) {
            methodName = MethodHelper.removeAndLowerCase(methodName, 2);
        }
        return methodName;
    }

    private static boolean isGetter(String methodName) {
        return methodName.length() > 3 && methodName.startsWith(GET) && MethodHelper.hasCapitalAt(methodName, 3) || methodName.length() > 2 && methodName.startsWith(IS) && MethodHelper.hasCapitalAt(methodName, 2);
    }

    private static boolean isSetter(String methodName) {
        return methodName.length() > 3 && methodName.startsWith(SET) && MethodHelper.hasCapitalAt(methodName, 3);
    }

    private static String removeAndLowerCase(String original, int pre) {
        original = original.substring(pre);
        return original.substring(0, 1).toLowerCase() + original.substring(1);
    }

    private static boolean hasCapitalAt(String name, int pos) {
        String letter = new String(new char[]{name.charAt(pos)});
        return !letter.equals(letter.toLowerCase());
    }
}

