/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.number;

import graphql.Scalars;
import io.smallrye.graphql.scalar.number.AbstractNumberScalar;
import io.smallrye.graphql.scalar.number.Converter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class IntegerScalar
extends AbstractNumberScalar {
    public IntegerScalar() {
        super(Scalars.GraphQLInt.getName(), new Converter(){

            @Override
            public Object fromBigDecimal(BigDecimal bigDecimal) {
                return bigDecimal.intValueExact();
            }

            @Override
            public Object fromBigInteger(BigInteger bigInteger) {
                return bigInteger.intValue();
            }

            @Override
            public boolean isInRange(BigInteger value) {
                return value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0 || value.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) > 0;
            }
        }, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE);
    }
}

