/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.json;

import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.InputType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class InputFieldsInfo {
    private static final Map<String, Map<String, Field>> inputFieldTransformationMap = new HashMap<String, Map<String, Field>>();
    private static final Map<String, Map<String, Field>> inputFieldMappingMap = new HashMap<String, Map<String, Field>>();

    private InputFieldsInfo() {
    }

    protected static void register(InputType inputType) {
        if (inputType.hasFields()) {
            HashMap<String, Field> fieldsThatNeedsTransformation = new HashMap<String, Field>();
            HashMap<String, Field> fieldsThatNeedsMapping = new HashMap<String, Field>();
            Collection<Field> fields = inputType.getFields().values();
            for (Field field : fields) {
                if (field.hasTransformInfo() && !field.getTransformInfo().isJsonB()) {
                    fieldsThatNeedsTransformation.put(field.getName(), field);
                }
                if (!field.hasMappingInfo() && !field.getReference().hasMappingInfo()) continue;
                fieldsThatNeedsMapping.putIfAbsent(field.getName(), field);
            }
            if (!fieldsThatNeedsTransformation.isEmpty()) {
                inputFieldTransformationMap.put(inputType.getClassName(), fieldsThatNeedsTransformation);
            }
            if (!fieldsThatNeedsMapping.isEmpty()) {
                inputFieldMappingMap.put(inputType.getClassName(), fieldsThatNeedsMapping);
            }
        }
    }

    public static boolean hasTransformationFields(String className) {
        return inputFieldTransformationMap.containsKey(className);
    }

    public static boolean hasMappingFields(String className) {
        return inputFieldMappingMap.containsKey(className);
    }

    public static Map<String, Field> getTransformationFields(String className) {
        if (inputFieldTransformationMap.containsKey(className)) {
            return inputFieldTransformationMap.get(className);
        }
        return null;
    }

    public static Map<String, Field> getMappingFields(String className) {
        if (inputFieldMappingMap.containsKey(className)) {
            return inputFieldMappingMap.get(className);
        }
        return null;
    }
}

