/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.monitor;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.MethodDescriptor;
import io.openliberty.grpc.client.monitor.GrpcMonitoringClientInterceptorService;
import io.openliberty.grpc.internal.monitor.GrpcClientStatsMonitor;
import io.openliberty.grpc.internal.monitor.GrpcMethod;
import io.openliberty.grpc.internal.monitor.GrpcMonitoringClientCall;
import java.time.Clock;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(service={GrpcMonitoringClientInterceptorService.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true)
public class GrpcMonitoringClientInterceptorServiceImpl
implements GrpcMonitoringClientInterceptorService {
    public ClientInterceptor createInterceptor() {
        return new GrpcMonitoringClientInterceptor();
    }

    private class GrpcMonitoringClientInterceptor
    implements ClientInterceptor {
        private final Clock clock = Clock.systemDefaultZone();

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel channel) {
            GrpcMethod grpcMethod = GrpcMethod.of(methodDescriptor);
            GrpcClientStatsMonitor metrics = new GrpcClientStatsMonitor(grpcMethod);
            return new GrpcMonitoringClientCall(channel.newCall(methodDescriptor, callOptions), metrics, grpcMethod, this.clock);
        }
    }
}

