/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.monitor;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.openliberty.grpc.internal.monitor.GrpcClientStatsMonitor;
import io.openliberty.grpc.internal.monitor.GrpcMethod;
import io.openliberty.grpc.internal.monitor.GrpcMonitoringClientCallListener;
import java.time.Clock;

public class GrpcMonitoringClientCall<ReqT, RespT>
extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
    private final GrpcClientStatsMonitor clientMetrics;
    private final GrpcMethod grpcMethod;
    private final Clock clock;

    protected GrpcMonitoringClientCall(ClientCall<ReqT, RespT> delegate, GrpcClientStatsMonitor clientMetrics, GrpcMethod grpcMethod, Clock clock) {
        super(delegate);
        this.clientMetrics = clientMetrics;
        this.grpcMethod = grpcMethod;
        this.clock = clock;
    }

    public void start(ClientCall.Listener<RespT> delegate, Metadata metadata) {
        this.clientMetrics.recordCallStarted();
        super.start(new GrpcMonitoringClientCallListener<RespT>(delegate, this.clientMetrics, this.grpcMethod, this.clock), metadata);
    }

    public void sendMessage(ReqT requestMessage) {
        if (this.grpcMethod.serverSendsOneMessage()) {
            this.clientMetrics.recordMsgSent();
        }
        super.sendMessage(requestMessage);
    }
}

