/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi.webapp;

import com.ibm.ws.container.service.app.deploy.InjectionClassListProvider;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppInjectionClassList;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.adaptable.module.adapters.ContainerAdapter;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.overlay.OverlayContainer;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.webcontainer.collaborator.WebAppInjectionClassListCollaborator;
import java.util.ArrayList;
import java.util.List;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={ContainerAdapter.class, InjectionClassListProvider.class}, immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "toType=com.ibm.ws.webcontainer.osgi.webapp.WebAppInjectionClassList"})
public class WebAppInjectionClassListAdapter
implements ContainerAdapter<WebAppInjectionClassList>,
InjectionClassListProvider {
    private final ConcurrentServiceReferenceSet<WebAppInjectionClassListCollaborator> webAppInjectionClassListCollaborators = new ConcurrentServiceReferenceSet("webAppInjectionClassListCollaborators");

    public WebAppInjectionClassList adapt(Container root, OverlayContainer rootOverlay, ArtifactContainer artifactContainer, Container containerToAdapt) throws UnableToAdaptException {
        final List<String> listOfClassNames = this.getInjectionClasses(containerToAdapt);
        return new WebAppInjectionClassList(){

            public List<String> getClassNames() {
                return listOfClassNames;
            }
        };
    }

    @Activate
    protected void activate(ComponentContext context) {
        this.webAppInjectionClassListCollaborators.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.webAppInjectionClassListCollaborators.deactivate(context);
    }

    @Reference(name="webAppInjectionClassListCollaborators", service=WebAppInjectionClassListCollaborator.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWebAppInjectionClassListCollaborators(ServiceReference<WebAppInjectionClassListCollaborator> ref) {
        this.webAppInjectionClassListCollaborators.addReference(ref);
    }

    protected void unsetWebAppInjectionClassListCollaborators(ServiceReference<WebAppInjectionClassListCollaborator> ref) {
        this.webAppInjectionClassListCollaborators.removeReference(ref);
    }

    public List<String> getInjectionClasses(Container moduleContainer) {
        ArrayList<String> listOfClassNames = new ArrayList<String>();
        for (WebAppInjectionClassListCollaborator collab : this.webAppInjectionClassListCollaborators.services()) {
            listOfClassNames.addAll(collab.getInjectionClasses(moduleContainer));
        }
        return listOfClassNames;
    }
}

