/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.persistence.internal.eclipselink.sql;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.persistence.internal.eclipselink.sql.delegate.DelegatingPreparedStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.RollbackException;

@Trivial
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class UnicodeFilteringPreparedStatement
extends DelegatingPreparedStatement {
    private static final TraceComponent tc = Tr.register(UnicodeFilteringPreparedStatement.class, (String)"persistenceService", (String)"com.ibm.wsspi.persistence.internal.PersistenceServiceMessages");
    static final long serialVersionUID = -7604242040594757563L;

    public UnicodeFilteringPreparedStatement(PreparedStatement ps) {
        super(ps);
    }

    @Override
    public void setString(int parameterIndex, @Sensitive String parameter) throws SQLException {
        if (!UnicodeFilteringPreparedStatement.isValidString(parameter)) {
            String errMsg = Tr.formatMessage((TraceComponent)tc, (String)"INVALID_CHAR_IN_PREPSTMT_CWWKD0203E", (Object[])new Object[0]);
            throw new RollbackException(errMsg);
        }
        super.setString(parameterIndex, parameter);
    }

    private static boolean isValidString(String unscanned) {
        if (unscanned == null || unscanned.isEmpty()) {
            return true;
        }
        for (char c : unscanned.toCharArray()) {
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }
}

