/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.osgi.locator;

import java.util.Objects;
import org.apache.yoko.osgi.locator.LocalFactory;

public final class ServiceProvider
implements Comparable<ServiceProvider> {
    public static final int DEFAULT_PRIORITY = 1;
    private final LocalFactory localFactory;
    private final String id;
    private final String className;
    private final int priority;

    public ServiceProvider(LocalFactory localFactory, String id, String className, int priority) {
        this.localFactory = localFactory;
        this.id = id;
        this.className = className;
        this.priority = priority;
    }

    public ServiceProvider(LocalFactory localFactory, String id, String className) {
        this(localFactory, id, className, 1);
    }

    public ServiceProvider(LocalFactory localFactory, String id, Class<?> implClass, int priority) {
        this(localFactory, id, implClass.getName(), priority);
    }

    public ServiceProvider(LocalFactory localFactory, String id, Class<?> implClass) {
        this(localFactory, id, implClass.getName());
    }

    public <T, U extends T> ServiceProvider(LocalFactory localFactory, Class<T> idClass, Class<U> implClass, int priority) {
        this(localFactory, idClass.getName(), implClass.getName(), priority);
    }

    public <T, U extends T> ServiceProvider(LocalFactory localFactory, Class<T> idClass, Class<U> implClass) {
        this(localFactory, idClass.getName(), implClass.getName());
    }

    public <T> ServiceProvider(LocalFactory localFactory, Class<T> svcClass, int priority) {
        this(localFactory, svcClass, svcClass, priority);
    }

    public <T> ServiceProvider(LocalFactory localFactory, Class<T> svcClass) {
        this(localFactory, svcClass, svcClass);
    }

    public final String getId() {
        return this.id;
    }

    public final String getClassName() {
        return this.className;
    }

    public final int getPriority() {
        return this.priority;
    }

    public final Class<?> getServiceClass() throws ClassNotFoundException {
        return this.localFactory.forName(this.className);
    }

    public final Object getServiceInstance() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.localFactory.newInstance(this.getServiceClass());
    }

    public final boolean equals(Object theOther) {
        if (this.getClass() != theOther.getClass()) {
            return false;
        }
        ServiceProvider that = (ServiceProvider)theOther;
        return Objects.equals(this.localFactory.getClass(), that.localFactory.getClass()) && Objects.equals(this.id, that.id) && Objects.equals(this.className, that.className) && Objects.equals(this.priority, that.priority);
    }

    public final int hashCode() {
        return Objects.hash(this.id, this.className, this.priority);
    }

    @Override
    public final int compareTo(ServiceProvider that) {
        return that.priority - this.priority;
    }

    public final String toString() {
        return String.format("Service id=%s class=%s priority=%d", this.id, this.className, this.priority);
    }
}

