/*
 * Decompiled with CFR 0.152.
 */
package javax.batch.runtime;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobOperator;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.util.tracker.ServiceTracker;

public class BatchRuntime {
    private static final String sourceClass = BatchRuntime.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static ServiceTracker<JobOperator, JobOperator> jobOperatorTracker = null;
    private static JobOperator jo;

    public static JobOperator getJobOperator() {
        jo = AccessController.doPrivileged(new PrivilegedAction<JobOperator>(){

            @Override
            public JobOperator run() {
                return (JobOperator)jobOperatorTracker.getService();
            }
        });
        if (jo == null) {
            String msg = BatchRuntime.getFormattedMessage("batch.container.unavailable", new Object[]{"<batchPersistence/>"}, "CWWKY0350E: The batch container is not activated. Ensure that batch persistence has been configured via configuration element <batchPersistence />");
            throw new BatchRuntimeException(msg);
        }
        return jo;
    }

    private static String getFormattedMessage(String msgKey, Object[] fillIns, String defaultMsg) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.jbatch.javax.batch.runtime.internal.BatchMessages");
        if (resourceBundle == null) {
            return defaultMsg;
        }
        String msg = resourceBundle.getString(msgKey);
        return msg != null ? MessageFormat.format(msg, fillIns) : defaultMsg;
    }

    static {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws InvalidSyntaxException {
                    jobOperatorTracker = new ServiceTracker(FrameworkUtil.getBundle(JobOperator.class).getBundleContext(), FrameworkUtil.createFilter((String)"(component.name=com.ibm.jbatch.container.api.impl.JobOperatorImplSuspendTran)"), null);
                    jobOperatorTracker.open();
                    return null;
                }
            });
        }
        catch (Throwable t) {
            throw new BatchRuntimeException("Failed to load ServiceTracker for JobOperator", t);
        }
    }
}

