/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.queue;

import com.ibm.ws.request.timing.queue.QueueableRequest;
import com.ibm.wsspi.requestContext.RequestContext;

public class HungRequest
extends QueueableRequest {
    private final long hungRequestThreshold;
    private final boolean includeContextInfo;
    private final boolean interruptRequest;
    private final boolean enableThreadDumps;

    public HungRequest(RequestContext requestContext, long delay, long hungRequestThreshold, boolean includeContextInfo, boolean interruptRequest, boolean enableThreadDumps) {
        super(requestContext, delay);
        this.hungRequestThreshold = hungRequestThreshold;
        this.includeContextInfo = includeContextInfo;
        this.interruptRequest = interruptRequest;
        this.enableThreadDumps = enableThreadDumps;
    }

    public long getHungRequestThreshold() {
        return this.hungRequestThreshold;
    }

    public boolean includeContextInfo() {
        return this.includeContextInfo;
    }

    @Override
    public boolean interruptRequest() {
        return this.interruptRequest;
    }

    @Override
    public boolean isThreadDumpsEnabled() {
        return this.enableThreadDumps;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        StringBuffer hungReq = new StringBuffer();
        hungReq.append(String.format("%n", new Object[0]));
        if (this.getInitialDelay() == this.hungRequestThreshold) {
            hungReq.append("-----------------------Hung Request Details-------------------------" + String.format("%n", new Object[0]));
        } else {
            hungReq.append("-------------------Probable Hung Request Details-------------------" + String.format("%n", new Object[0]));
        }
        hungReq.append("Request Id : " + this.getRequestContext().getRequestId().getId() + String.format("%n", new Object[0]));
        hungReq.append("Request type : " + this.getRequestContext().getRootEvent().getType() + String.format("%n", new Object[0]));
        hungReq.append("Request state : " + this.getRequestContext().getRequestState() + String.format("%n", new Object[0]));
        hungReq.append("Initial Delay (ms) : " + this.getInitialDelay() + String.format("%n", new Object[0]));
        hungReq.append("Hung request threshold mean (ms) : " + this.hungRequestThreshold + String.format("%n", new Object[0]));
        hungReq.append("Include Context Info : " + this.includeContextInfo + String.format("%n", new Object[0]));
        hungReq.append("-----------------------------------------------------------------------");
        return hungReq.toString();
    }
}

