/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.internal.config;

import com.ibm.ws.request.timing.config.Timing;
import com.ibm.ws.request.timing.internal.config.RequestTimingConfig;
import com.ibm.wsspi.requestContext.ContextInfoArray;
import com.ibm.wsspi.requestContext.Event;
import com.ibm.wsspi.requestContext.RequestContext;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class HungRequestTimingConfig
extends RequestTimingConfig {
    private final boolean keepStatistics;
    private final boolean interruptHungRequest;
    private final boolean enableThreadDumps;

    public HungRequestTimingConfig(int contextInfoRequirement, Map<String, List<Timing>> hungRequestTiming, boolean interruptHungRequest, boolean enableThreadDumps) {
        super(1, contextInfoRequirement, hungRequestTiming);
        boolean isInterruptHungRequest = interruptHungRequest;
        if (hungRequestTiming != null) {
            for (List<Timing> typeList : hungRequestTiming.values()) {
                if (typeList == null) continue;
                for (Timing t : typeList) {
                    if (!t.interruptHungRequest()) continue;
                    isInterruptHungRequest = true;
                }
            }
        }
        this.interruptHungRequest = isInterruptHungRequest;
        this.enableThreadDumps = enableThreadDumps;
        this.keepStatistics = this.countTimingConfigs() > 1;
    }

    public HungRequestTimingConfig() {
        this.keepStatistics = false;
        this.interruptHungRequest = false;
        this.enableThreadDumps = true;
    }

    public void incrementTimingConfigForRequest(RequestContext requestContext, ConcurrentHashMap<String, AtomicLong> requestCounts) {
        Event rootEvent = requestContext.getRootEvent();
        String requestType = rootEvent.getType();
        AtomicLong count = requestCounts.putIfAbsent(requestType, new AtomicLong());
        if (count == null) {
            count = requestCounts.get(requestType);
        }
        count.getAndIncrement();
        if (this.keepStatistics) {
            Object contextInfoObj = rootEvent.getContextInfo();
            ContextInfoArray cia = contextInfoObj != null && contextInfoObj instanceof ContextInfoArray ? (ContextInfoArray)contextInfoObj : null;
            Timing bestMatch = this.getTiming(requestType, cia != null ? cia.getContextInfoArray() : null);
            bestMatch.incrementCount(cia != null ? cia.toString() : null);
        }
    }

    public void writeIntrospectionData(PrintWriter pw) {
        if (this.keepStatistics) {
            Map<String, List<Timing>> timingConfig = this.getRequestTiming();
            if (timingConfig != null) {
                for (String type : timingConfig.keySet()) {
                    pw.println("Type " + type + ":");
                    List<Timing> typeConfig = timingConfig.get(type);
                    for (Timing t : typeConfig) {
                        t.writeIntrospectionData(pw);
                    }
                }
                pw.println("End of requestTiming-1.0 output");
            } else {
                pw.println("requestTiming-1.0 cannot print statistics because the timing config was null.");
            }
        } else {
            pw.println("requestTiming-1.0 is not keeping timing statistics since there are no <timing/> elements in the configuration");
        }
    }

    public boolean isRequestInterruptEnabled() {
        return this.interruptHungRequest;
    }

    public boolean isThreadDumpsEnabled() {
        return this.enableThreadDumps;
    }

    @Override
    public boolean getInterruptRequest(String type, String[] contextInfo) {
        return this.getTiming(type, contextInfo).interruptHungRequest();
    }

    @Override
    public boolean getEnableThreadDumps(String type, String[] contextInfo) {
        return this.getTiming(type, contextInfo).isThreadDumpsEnabled();
    }

    private int countTimingConfigs() {
        int configCount = 0;
        Map<String, List<Timing>> config = this.getRequestTiming();
        if (config != null) {
            for (List<Timing> typeConfig : config.values()) {
                configCount += typeConfig.size();
            }
        }
        return configCount;
    }

    public String toString() {
        StringBuffer hungReqTimingCfg = new StringBuffer();
        hungReqTimingCfg.append(String.format("%n", new Object[0]));
        hungReqTimingCfg.append("-------------------Hung Request Timing Settings-------------------" + String.format("%n", new Object[0]));
        hungReqTimingCfg.append("Sample rate: " + this.getSampleRate() + String.format("%n", new Object[0]));
        hungReqTimingCfg.append("Context info requirement: " + this.getContextInfoRequirement() + String.format("%n", new Object[0]));
        hungReqTimingCfg.append("-------------------Type Settings-------------------" + String.format("%n", new Object[0]));
        for (List<Timing> typeList : this.getRequestTiming().values()) {
            for (Timing t : typeList) {
                hungReqTimingCfg.append(t.getType() + ": " + t.getContextInfoString() + ": Request threshold (ms) - " + t.getRequestThreshold() + String.format("%n", new Object[0]));
            }
        }
        hungReqTimingCfg.append("-------------------------------------------------------------");
        return hungReqTimingCfg.toString();
    }
}

