/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel.compression;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.http.channel.compression.DecompressionHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class GzipInputHandler
implements DecompressionHandler {
    private static final TraceComponent tc = Tr.register(GzipInputHandler.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private PARSE_STATE state = PARSE_STATE.ID1;
    private byte gzipFlag = (byte)-1;
    private int parseInt = 0;
    private int parseFirstByte = 0;
    private int parseOffset = 0;
    private Inflater inflater = null;
    private final byte[] buf = new byte[16384];
    private CRC32 checksum = null;
    private boolean resetNeededToProceed = false;
    private long countRead = 0L;
    private long countWritten = 0L;

    public GzipInputHandler() {
        this.inflater = new Inflater(true);
        this.checksum = new CRC32();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created a gzip input handler; " + this), (Object[])new Object[0]);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private boolean isFExtraSet() {
        return (this.gzipFlag & 4) == 4;
    }

    private boolean isFNameSet() {
        return (this.gzipFlag & 8) == 8;
    }

    private boolean isFCommentSet() {
        return (this.gzipFlag & 0x10) == 16;
    }

    private boolean isFHCRCSet() {
        return (this.gzipFlag & 1) == 1;
    }

    private int skip(byte[] data, int pos, int count) {
        int remaining = data.length - pos;
        if (remaining >= count) {
            this.parseInt = 0;
            return pos + count;
        }
        this.parseInt = count - remaining;
        return data.length;
    }

    private int skipPast(byte[] data, int pos, byte target) {
        int index = pos;
        while (index < data.length) {
            if (target != data[index++]) continue;
            return index;
        }
        return index;
    }

    private int parseHeader(byte[] data) throws DataFormatException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing gzip header; state=" + (Object)((Object)this.state)), (Object[])new Object[0]);
        }
        int pos = 0;
        while (pos < data.length && PARSE_STATE.DONE != this.state) {
            byte b = data[pos++];
            if (PARSE_STATE.ID1 == this.state) {
                if (31 != b) {
                    throw new DataFormatException("Invalid gzip header, first byte=" + b);
                }
                this.state = PARSE_STATE.ID2;
                continue;
            }
            if (PARSE_STATE.ID2 == this.state) {
                if (-117 != b) {
                    throw new DataFormatException("Invalid gzip header, second byte=" + b);
                }
                this.state = PARSE_STATE.COMPRESSION;
                continue;
            }
            if (PARSE_STATE.COMPRESSION == this.state) {
                if (8 != b) {
                    throw new DataFormatException("Invalid gzip compression method=" + b);
                }
                this.state = PARSE_STATE.FLAG;
                continue;
            }
            if (PARSE_STATE.FLAG == this.state) {
                if (-1 == this.gzipFlag) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("gzip header flag=" + b), (Object[])new Object[0]);
                    }
                    this.gzipFlag = b;
                    pos = this.skip(data, pos, 6);
                } else {
                    pos = this.skip(data, pos, this.parseInt);
                }
                if (0 != this.parseInt) continue;
                this.state = this.isFExtraSet() ? PARSE_STATE.FEXTRA : (this.isFNameSet() ? PARSE_STATE.FNAME : (this.isFCommentSet() ? PARSE_STATE.FCOMMENT : (this.isFHCRCSet() ? PARSE_STATE.FHCRC : PARSE_STATE.DONE)));
                this.parseOffset = 0;
                continue;
            }
            if (PARSE_STATE.FEXTRA == this.state) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Parsing FEXTRA data, offset=" + this.parseOffset), (Object[])new Object[0]);
                }
                if (0 == this.parseOffset) {
                    this.parseInt = b;
                    ++this.parseOffset;
                    continue;
                }
                if (1 == this.parseOffset) {
                    this.parseInt = b << 8 | this.parseInt;
                    ++this.parseOffset;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("FEXTRA length is " + this.parseInt), (Object[])new Object[0]);
                }
                pos = this.skip(data, pos, this.parseInt);
                if (0 != this.parseInt) continue;
                this.state = this.isFNameSet() ? PARSE_STATE.FNAME : (this.isFCommentSet() ? PARSE_STATE.FCOMMENT : (this.isFHCRCSet() ? PARSE_STATE.FHCRC : PARSE_STATE.DONE));
                this.parseOffset = 0;
                continue;
            }
            if (PARSE_STATE.FNAME == this.state) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Parsing FNAME data", (Object[])new Object[0]);
                }
                if (0 != b) {
                    pos = this.skipPast(data, pos, (byte)0);
                }
                if (data.length == pos) {
                    return pos;
                }
                if (this.isFCommentSet()) {
                    this.state = PARSE_STATE.FCOMMENT;
                    continue;
                }
                if (this.isFHCRCSet()) {
                    this.state = PARSE_STATE.FHCRC;
                    continue;
                }
                this.state = PARSE_STATE.DONE;
                continue;
            }
            if (PARSE_STATE.FCOMMENT == this.state) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Parsing FCOMMENT data", (Object[])new Object[0]);
                }
                if (0 != b) {
                    pos = this.skipPast(data, pos, (byte)0);
                }
                if (data.length == pos) {
                    return pos;
                }
                if (this.isFHCRCSet()) {
                    this.state = PARSE_STATE.FHCRC;
                    continue;
                }
                this.state = PARSE_STATE.DONE;
                continue;
            }
            if (PARSE_STATE.FHCRC != this.state) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Parsing FHCRC data; offset=" + this.parseOffset), (Object[])new Object[0]);
            }
            ++this.parseOffset;
            if (2 > this.parseOffset) continue;
            this.state = PARSE_STATE.DONE;
        }
        if (PARSE_STATE.DONE == this.state) {
            this.parseOffset = 0;
            this.parseInt = 0;
        }
        return pos;
    }

    private int parseTrailer(byte[] input, int inOffset, List<WsByteBuffer> list) throws DataFormatException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Parsing trailer, offset=" + this.parseOffset + " val=" + this.parseInt), (Object[])new Object[0]);
        }
        int offset = inOffset;
        long val = 0L;
        while (8 > this.parseOffset && offset < input.length) {
            switch (this.parseOffset) {
                case 0: 
                case 2: 
                case 4: 
                case 6: {
                    this.parseFirstByte = input[offset] & 0xFF;
                    break;
                }
                case 1: 
                case 5: {
                    this.parseInt = (input[offset] & 0xFF) << 8 | this.parseFirstByte;
                    break;
                }
                case 3: {
                    val = (input[offset] & 0xFF) << 8 | this.parseFirstByte;
                    val = val << 16 | (long)this.parseInt;
                    if (this.checksum.getValue() == val) break;
                    String msg = "Checksum does not match; crc=" + this.checksum.getValue() + " trailer=" + val;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                    }
                    this.release(list);
                    throw new DataFormatException(msg);
                }
                case 7: {
                    val = (input[offset] & 0xFF) << 8 | this.parseFirstByte;
                    val = val << 16 | (long)this.parseInt;
                    if (this.inflater.getBytesWritten() != val) {
                        String msg = "BytesWritten does not match; inflater=" + this.inflater.getBytesWritten() + " trailer=" + val;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
                        }
                        this.release(list);
                        throw new DataFormatException(msg);
                    }
                    this.resetNeededToProceed = true;
                    break;
                }
            }
            ++offset;
            ++this.parseOffset;
        }
        return offset;
    }

    private void release(List<WsByteBuffer> list) {
        while (!list.isEmpty()) {
            list.remove(0).release();
        }
    }

    private void reset() {
        this.state = PARSE_STATE.ID1;
        this.gzipFlag = (byte)-1;
        this.parseInt = 0;
        this.parseFirstByte = 0;
        this.parseOffset = 0;
        this.checksum = new CRC32();
        this.countRead += this.inflater.getBytesRead();
        this.countWritten += this.inflater.getBytesWritten();
        this.inflater.reset();
        this.resetNeededToProceed = false;
    }

    @Override
    public List<WsByteBuffer> decompress(WsByteBuffer inputBuffer) throws DataFormatException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"decompress", (Object[])new Object[]{inputBuffer});
        }
        LinkedList<WsByteBuffer> list = new LinkedList<WsByteBuffer>();
        int dataSize = inputBuffer.remaining();
        byte[] input = new byte[dataSize];
        inputBuffer.get(input, 0, dataSize);
        int inOffset = 0;
        if (this.resetNeededToProceed) {
            this.reset();
        }
        if (PARSE_STATE.DONE != this.state && (inOffset = this.parseHeader(input)) >= input.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"decompress, ran out of data while parsing gzip header", (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"decompress");
            }
            return list;
        }
        if (!this.inflater.finished()) {
            this.inflater.setInput(input, inOffset, dataSize - inOffset);
        }
        long initialBytesRead = this.inflater.getBytesRead();
        int outOffset = 0;
        int len = -1;
        while (inOffset < input.length && !this.inflater.finished() && 0 != len) {
            try {
                len = this.inflater.inflate(this.buf, outOffset, this.buf.length - outOffset);
            }
            catch (DataFormatException dfe) {
                this.release(list);
                throw dfe;
            }
            long bytesRead = this.inflater.getBytesRead();
            inOffset = (int)((long)inOffset + (bytesRead - initialBytesRead));
            initialBytesRead = bytesRead;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Decompressed amount=" + len + " inOffset=" + inOffset + " read=" + this.inflater.getBytesRead() + " written=" + this.inflater.getBytesWritten() + " finished=" + this.inflater.finished()), (Object[])new Object[0]);
            }
            if ((outOffset += len) < this.buf.length) continue;
            WsByteBuffer buffer = HttpDispatcher.getBufferManager().allocate(this.buf.length);
            buffer.put(this.buf, 0, this.buf.length);
            this.checksum.update(this.buf, 0, this.buf.length);
            buffer.flip();
            list.add(buffer);
            outOffset = 0;
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("Storing decompressed buffer; " + buffer), (Object[])new Object[0]);
        }
        if (0 < outOffset) {
            WsByteBuffer buffer = HttpDispatcher.getBufferManager().allocate(outOffset);
            buffer.put(this.buf, 0, outOffset);
            this.checksum.update(this.buf, 0, outOffset);
            buffer.flip();
            list.add(buffer);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Stored final decompressed buffer; " + buffer), (Object[])new Object[0]);
            }
        }
        if (this.inflater.finished()) {
            inOffset = this.parseTrailer(input, inOffset, list);
        }
        if (inOffset < dataSize) {
            inputBuffer.position(inputBuffer.position() - (dataSize - inOffset));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("input buffer has unused data; " + inputBuffer), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"decompress", (Object)list.size());
        }
        return list;
    }

    @Override
    public void close() {
        this.inflater.end();
    }

    @Override
    public boolean isFinished() {
        return this.inflater.finished();
    }

    @Override
    public long getBytesRead() {
        return this.countRead + this.inflater.getBytesRead();
    }

    @Override
    public long getBytesWritten() {
        return this.countWritten + this.inflater.getBytesWritten();
    }

    private static enum PARSE_STATE {
        ID1,
        ID2,
        COMPRESSION,
        FLAG,
        FEXTRA,
        FNAME,
        FCOMMENT,
        FHCRC,
        DONE;

    }
}

