/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.dispatcher.internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.dispatcher.internal.TrustedHeaderOriginLists;
import com.ibm.ws.http.internal.EncodingUtilsImpl;
import com.ibm.ws.http.internal.HttpDateFormatImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ChannelFramework;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.http.EncodingUtils;
import com.ibm.wsspi.http.HttpDateFormat;
import com.ibm.wsspi.http.VirtualHostListener;
import com.ibm.wsspi.http.WorkClassifier;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import com.ibm.wsspi.http.ee7.HttpTransportBehavior;
import com.ibm.wsspi.kernel.service.utils.MetatypeUtils;
import com.ibm.wsspi.timer.ApproximateTime;
import com.ibm.wsspi.timer.QuickApproxTime;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.http.dispatcher"}, service={HttpDispatcher.class}, property={"service.vendor=IBM"})
public class HttpDispatcher {
    private static final TraceComponent tc = Tr.register(HttpDispatcher.class, (String[])new String[]{"HttpDispatcher", "HttpTransport"}, (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages", (String)"com.ibm.ws.http.dispatcher.internal.HttpDispatcher");
    private volatile EncodingUtils encodingSvc = null;
    private volatile EventEngine eventSvc = null;
    private volatile ExecutorService executorService = null;
    private volatile CHFWBundle chfw = null;
    public volatile WorkClassifier workClassifier = null;
    private volatile ServiceReference<HttpTransportBehavior> behaviorRef;
    private static volatile boolean useEE7Streams = false;
    private static volatile Boolean useIOExceptionBehavior = null;
    static final String CONFIG_ALIAS = "httpDispatcher";
    static final String PROP_VHOST_NOT_FOUND = "appOrContextRootMissingMessage";
    static final String PROP_ENABLE_WELCOME_PAGE = "enableWelcomePage";
    static final String PROP_PAD_VHOST_NOT_FOUND = "padAppOrContextRootMissingMessage";
    static final String PROP_TRUSTED_PRIVATE_HEADER_ORIGIN = "trustedHeaderOrigin";
    static final String PROP_WC_TRUSTED = "trusted";
    static final String PROP_TRUSTED_SENSITIVE_HEADER_ORIGIN = "trustedSensitiveHeaderOrigin";
    private static final AtomicReference<HttpDispatcher> instance = new AtomicReference();
    private volatile String appOrContextRootNotFound = null;
    private boolean padAppOrContextRootNotFoundMessage = true;
    private volatile boolean enableWelcomePage = true;
    private volatile String[] origHeaderOrigin = null;
    private volatile boolean wcTrusted = true;
    private volatile String[] origSensitiveHeaderOrigin = null;
    private volatile TrustedHeaderOriginLists trustedLists = null;
    private static final AtomicInteger updateCount = new AtomicInteger(0);
    static final long serialVersionUID = -3203249382632173595L;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
        instance.set(this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("HttpDispatcher activated, id=" + properties.get("component.id")), (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected void deactivate(Map<String, Object> properties, int reason) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((Object)this, (TraceComponent)tc, (String)("HttpDispatcher deactivated, id=" + properties.get("component.id") + ",reason=" + reason), (Object[])new Object[0]);
        }
        instance.compareAndSet(this, null);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        if (null == config || config.isEmpty()) {
            return;
        }
        this.setContextRootNotFoundMessage((String)config.get(PROP_VHOST_NOT_FOUND));
        this.enableWelcomePage(MetatypeUtils.parseBoolean((Object)CONFIG_ALIAS, (String)PROP_ENABLE_WELCOME_PAGE, (Object)config.get(PROP_ENABLE_WELCOME_PAGE), (boolean)true));
        this.setPadContextRootNotFoundMessage(MetatypeUtils.parseBoolean((Object)CONFIG_ALIAS, (String)PROP_PAD_VHOST_NOT_FOUND, (Object)config.get(PROP_PAD_VHOST_NOT_FOUND), (boolean)false));
        this.origHeaderOrigin = MetatypeUtils.parseStringArray((Object)CONFIG_ALIAS, (String)PROP_TRUSTED_PRIVATE_HEADER_ORIGIN, (Object)config.get(PROP_TRUSTED_PRIVATE_HEADER_ORIGIN), (String[])new String[]{"*"});
        this.origSensitiveHeaderOrigin = MetatypeUtils.parseStringArray((Object)CONFIG_ALIAS, (String)PROP_TRUSTED_SENSITIVE_HEADER_ORIGIN, (Object)config.get(PROP_TRUSTED_SENSITIVE_HEADER_ORIGIN), (String[])new String[]{"none"});
        this.parseTrustedPrivateHeaderOrigin(this.origHeaderOrigin, this.origSensitiveHeaderOrigin);
    }

    public static Boolean isWelcomePageEnabled() {
        HttpDispatcher f = instance.get();
        if (f != null) {
            return f.enableWelcomePage;
        }
        return false;
    }

    private void enableWelcomePage(boolean value) {
        this.enableWelcomePage = value;
    }

    public static String getContextRootNotFoundMessage() {
        HttpDispatcher f = instance.get();
        if (f != null) {
            return f.appOrContextRootNotFound;
        }
        return null;
    }

    private void setContextRootNotFoundMessage(String value) {
        this.appOrContextRootNotFound = value;
    }

    private void setPadContextRootNotFoundMessage(boolean value) {
        this.padAppOrContextRootNotFoundMessage = value;
    }

    public static boolean padContextRootNotFoundMessage() {
        HttpDispatcher f = instance.get();
        if (f != null) {
            return f.padAppOrContextRootNotFoundMessage;
        }
        return true;
    }

    private synchronized void parseTrustedPrivateHeaderOrigin(String[] trustedPrivateHeaderHosts, String[] trustedSensitiveHeaderHosts) {
        updateCount.incrementAndGet();
        if (!this.wcTrusted) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"webcontainer trusted=false; private headers are not trusted from any host", (Object[])new Object[0]);
            }
            return;
        }
        this.trustedLists = new TrustedHeaderOriginLists();
        this.trustedLists.parseTrustedPrivateHeaderOrigin(trustedPrivateHeaderHosts, trustedSensitiveHeaderHosts);
    }

    /*
     * WARNING - void declaration
     */
    private static InetAddress getInetAddressFromString(String address) {
        InetAddress remoteAddr;
        block3: {
            remoteAddr = null;
            if (address != null) {
                try {
                    remoteAddr = InetAddress.getByName(address);
                }
                catch (UnknownHostException unknownHostException) {
                    void e;
                    FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.http.dispatcher.internal.HttpDispatcher", (String)"305", null, (Object[])new Object[]{address});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("exception encountered creating InetAddress from string=" + address + ": " + e), (Object[])new Object[0]);
                }
            }
        }
        return remoteAddr;
    }

    public static boolean usePrivateHeaders(String hostAddr) {
        InetAddress remoteAddr = HttpDispatcher.getInetAddressFromString(hostAddr);
        return HttpDispatcher.usePrivateHeaders(remoteAddr, null);
    }

    public static boolean usePrivateHeaders(InetAddress addr) {
        return HttpDispatcher.usePrivateHeaders(addr, null);
    }

    public static boolean usePrivateHeaders(String hostAddr, String headerName) {
        InetAddress remoteAddr = HttpDispatcher.getInetAddressFromString(hostAddr);
        return HttpDispatcher.usePrivateHeaders(remoteAddr, headerName);
    }

    public static boolean usePrivateHeaders(InetAddress addr, String headerName) {
        HttpDispatcher f = instance.get();
        if (f != null) {
            return f.isTrusted(addr, headerName);
        }
        return headerName == null || !HttpHeaderKeys.isSensitivePrivateHeader(headerName);
    }

    public boolean isTrusted(String hostAddr, String headerName) {
        InetAddress remoteAddr = HttpDispatcher.getInetAddressFromString(hostAddr);
        return this.isTrusted(remoteAddr, headerName);
    }

    public boolean isTrustedForSensitiveHeaders(String hostAddr) {
        InetAddress remoteAddr = HttpDispatcher.getInetAddressFromString(hostAddr);
        return this.isTrustedForSensitiveHeaders(remoteAddr);
    }

    public boolean isTrusted(InetAddress addr, String headerName) {
        if (!this.wcTrusted) {
            return false;
        }
        return this.trustedLists.isTrusted(addr, HttpHeaderKeys.isSensitivePrivateHeader(headerName));
    }

    public boolean isTrustedForSensitiveHeaders(InetAddress addr) {
        if (!this.wcTrusted) {
            return false;
        }
        return this.trustedLists.isTrusted(addr, true);
    }

    public static HttpDateFormat getDateFormatter() {
        return HttpDateFormatImpl.getInstance();
    }

    @Reference(name="encodingUtils")
    protected void setEncodingUtils(EncodingUtils service) {
        this.encodingSvc = service;
    }

    protected void unsetEncodingUtils(EncodingUtils service) {
        if (this.encodingSvc == service) {
            this.encodingSvc = null;
        }
    }

    public static EncodingUtils getEncodingUtils() {
        HttpDispatcher f = instance.get();
        EncodingUtils svc = null;
        if (f != null) {
            svc = f.encodingSvc;
        }
        if (svc == null) {
            svc = new EncodingUtilsImpl();
        }
        return svc;
    }

    @Reference(name="eventService")
    protected void setEventService(EventEngine service) {
        this.eventSvc = service;
    }

    protected void unsetEventService(EventEngine service) {
        if (this.eventSvc == service) {
            this.eventSvc = null;
        }
    }

    public static EventEngine getEventService() {
        HttpDispatcher f = instance.get();
        if (f != null) {
            return f.eventSvc;
        }
        return null;
    }

    @Reference(name="executorService")
    protected void setExecutorService(ExecutorService service) {
        this.executorService = service;
    }

    protected void unsetExecutorService(ExecutorService service) {
        if (this.executorService == service) {
            this.executorService = null;
        }
    }

    public static ExecutorService getExecutorService() {
        HttpDispatcher f = instance.get();
        if (f == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"HttpDispatcher instance not found", (Object[])new Object[0]);
            }
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("HttpDispatcher instance: " + f.toString()), (Object[])new Object[0]);
        }
        return f.executorService;
    }

    public static long getApproxTime() {
        return QuickApproxTime.getApproxTime();
    }

    @Reference(name="approxTime", policy=ReferencePolicy.DYNAMIC)
    protected void setApproxTime(ApproximateTime ref) {
    }

    protected void unsetApproxTime(ApproximateTime ref) {
    }

    @Reference(name="chfwBundle")
    protected void setChfwBundle(CHFWBundle bundle) {
        this.chfw = bundle;
    }

    protected void unsetChfwBundle(CHFWBundle bundle) {
        if (bundle == this.chfw) {
            this.chfw = null;
        }
    }

    public static CHFWBundle getCHFWBundle() {
        HttpDispatcher f = instance.get();
        if (f != null) {
            return f.chfw;
        }
        return null;
    }

    public static WsByteBufferPoolManager getBufferManager() {
        CHFWBundle chfw = HttpDispatcher.getCHFWBundle();
        if (null == chfw) {
            return ChannelFrameworkFactory.getBufferManager();
        }
        return chfw.getBufferManager();
    }

    public static ChannelFramework getFramework() {
        CHFWBundle chfw = HttpDispatcher.getCHFWBundle();
        if (null == chfw) {
            return ChannelFrameworkFactory.getChannelFramework();
        }
        return chfw.getFramework();
    }

    @Trivial
    @Reference(policy=ReferencePolicy.DYNAMIC, service=VirtualHostListener.class, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, target="(service.pid=com.ibm.ws.webcontainer)")
    protected void setWebContainer(ServiceReference<VirtualHostListener> ref) {
        this.updatedWebContainer(ref);
    }

    protected void updatedWebContainer(ServiceReference<VirtualHostListener> ref) {
        boolean newTrusted = MetatypeUtils.parseBoolean((Object)"webContainer", (String)PROP_WC_TRUSTED, (Object)ref.getProperty(PROP_WC_TRUSTED), (boolean)true);
        if (newTrusted != this.wcTrusted) {
            this.wcTrusted = newTrusted;
            this.parseTrustedPrivateHeaderOrigin(this.origHeaderOrigin, this.origSensitiveHeaderOrigin);
            updateCount.getAndIncrement();
        }
    }

    protected void unsetWebContainer(ServiceReference<VirtualHostListener> ref) {
    }

    @Reference(name="workClassifier", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    protected void setWorkClassifier(WorkClassifier service) {
        this.workClassifier = service;
    }

    protected void unsetWorkClassifier(WorkClassifier service) {
        if (this.workClassifier == service) {
            this.workClassifier = null;
        }
    }

    public static WorkClassifier getWorkClassifier() {
        HttpDispatcher f = instance.get();
        if (f != null) {
            return f.workClassifier;
        }
        return null;
    }

    public static int getConfigUpdate() {
        return updateCount.get();
    }

    @Reference(service=HttpTransportBehavior.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void setBehavior(ServiceReference<HttpTransportBehavior> reference) {
        this.behaviorRef = reference;
        useEE7Streams = (Boolean)reference.getProperty("useEE7Streams");
        useIOExceptionBehavior = (Boolean)reference.getProperty("useIOEBehavior");
    }

    protected synchronized void unsetBehavior(ServiceReference<HttpTransportBehavior> reference) {
        if (reference == this.behaviorRef) {
            this.behaviorRef = null;
            useEE7Streams = false;
            useIOExceptionBehavior = null;
        }
    }

    public static boolean useEE7Streams() {
        return useEE7Streams;
    }

    public static Boolean useIOEForInboundConnectionsBehavior() {
        return useIOExceptionBehavior;
    }
}

