/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.filter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.internal.filter.FilterCellSlowStr;
import com.ibm.ws.http.channel.internal.filter.FilterListStr;
import java.util.ArrayList;

public class FilterListSlowStr
implements FilterListStr {
    private static final TraceComponent tc = Tr.register(FilterListSlowStr.class);
    static final String wildCard = "*";
    private FilterCellSlowStr firstCell = new FilterCellSlowStr();
    private boolean active = false;

    @Override
    public void setActive(boolean value) {
        this.active = value;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public boolean buildData(String[] data) {
        int length = data.length;
        for (int i = 0; i < length; ++i) {
            this.addAddressToList(data[i]);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("host added to list of trusted hosts: " + data[i]), (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public boolean findInList(String address) {
        return this.findInList(this.convertToArray(address));
    }

    private String[] convertToArray(String newAddress) {
        int start = 0;
        ArrayList<String> addressWords = new ArrayList<String>();
        String addr = newAddress;
        while (true) {
            if ((start = addr.lastIndexOf(46)) == -1) break;
            String sub = addr.substring(start + 1);
            addressWords.add(sub);
            addr = addr.substring(0, start);
        }
        addressWords.add(addr);
        String[] sa = new String[addressWords.size()];
        sa = addressWords.toArray(sa);
        return sa;
    }

    private void addAddressToList(String newAddress) {
        this.putInList(this.convertToArray(newAddress));
    }

    private void putInList(String[] address) {
        FilterCellSlowStr currentCell = this.firstCell;
        FilterCellSlowStr nextCell = null;
        for (int i = 0; i < address.length; ++i) {
            if (address[i].equals(wildCard)) {
                currentCell.addNewCell(wildCard);
                return;
            }
            nextCell = currentCell.findNextCell(address[i]);
            if (nextCell == null) {
                for (int j = i; j < address.length; ++j) {
                    currentCell = currentCell.addNewCell(address[j]);
                    if (!address[j].equals(wildCard)) continue;
                    return;
                }
                return;
            }
            currentCell = nextCell;
        }
    }

    private boolean findInList(String[] address) {
        return this.findInList(address, 0, this.firstCell, address.length - 1);
    }

    private boolean findInList(String[] address, int index, FilterCellSlowStr cell, int endIndex) {
        if (cell.getWildcardCell() != null) {
            return true;
        }
        FilterCellSlowStr nextCell = cell.findNextCell(address[index]);
        if (nextCell != null) {
            if (index == endIndex) {
                return true;
            }
            return this.findInList(address, index + 1, nextCell, endIndex);
        }
        return false;
    }
}

