/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.sso;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.token.ltpa.LTPAConfiguration;
import com.ibm.ws.webcontainer.security.util.SSOAuthFilter;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={SSOAuthFilter.class}, name="com.ibm.ws.webcontainer.security.util.SSOAuthFilter", configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class SSOAuthFilterImpl
implements SSOAuthFilter {
    public static final TraceComponent tc = Tr.register(SSOAuthFilterImpl.class, (String)"SSO", null);
    public static final String KEY_SERVICE_PID = "service.pid";
    static final String LTPA_CONFIGURATION = "ltpaConfiguration";
    public static final String KEY_FILTER = "authenticationFilter";
    protected final AtomicServiceReference<LTPAConfiguration> ltpaConfigurationRef = new AtomicServiceReference("ltpaConfiguration");
    protected final ConcurrentServiceReferenceMap<String, AuthenticationFilter> authFilterServiceRef = new ConcurrentServiceReferenceMap("authenticationFilter");
    private LTPAConfiguration ltpaConfig;
    private static boolean issuedBetaMessage = false;
    static final long serialVersionUID = 7402351165056694343L;

    private static void betaFenceCheck() throws UnsupportedOperationException {
        if (!ProductInfo.getBetaEdition()) {
            throw new UnsupportedOperationException("This method is beta and is not available.");
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)"BETA: A beta method has been invoked for the class WSSecurityPropagationHelper for the first time.", (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
    }

    @Reference(name="ltpaConfiguration", service=LTPAConfiguration.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLTPAConfiguration(ServiceReference<LTPAConfiguration> ref) {
        this.ltpaConfigurationRef.setReference(ref);
    }

    protected void unsetLTPAConfiguration(ServiceReference<LTPAConfiguration> ref) {
        this.ltpaConfigurationRef.unsetReference(ref);
    }

    @Reference(name="authenticationFilter", service=AuthenticationFilter.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        String pid = (String)ref.getProperty(KEY_SERVICE_PID);
        this.authFilterServiceRef.putReference((Object)pid, ref);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAuthFilter service pid: " + this.getAuthFilterService(pid)), (Object[])new Object[0]);
        }
    }

    protected void updatedAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updatedAuthenticationFilter service.pid:" + ref.getProperty(KEY_SERVICE_PID)), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.putReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
    }

    protected void unsetAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetAuthenticationFilter service.pid:" + ref.getProperty(KEY_SERVICE_PID)), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.removeReference((Object)((String)ref.getProperty(KEY_SERVICE_PID)), ref);
    }

    private AuthenticationFilter getAuthFilterService(String pid) {
        return (AuthenticationFilter)this.authFilterServiceRef.getService((Object)pid);
    }

    public boolean processRequest(HttpServletRequest req) {
        AuthenticationFilter authFilter = this.getAuthFilter();
        if (authFilter != null) {
            SSOAuthFilterImpl.betaFenceCheck();
            if (!authFilter.isAccepted(req)) {
                return false;
            }
        }
        return true;
    }

    public boolean processRequest(HttpServletRequest req, String pid) {
        AuthenticationFilter authFilter = this.getAuthFilterService(pid);
        if (authFilter != null) {
            SSOAuthFilterImpl.betaFenceCheck();
            if (!authFilter.isAccepted(req)) {
                return false;
            }
        }
        return true;
    }

    private AuthenticationFilter getAuthFilter() {
        AuthenticationFilter authFilter = null;
        if (this.ltpaConfigurationRef != null) {
            this.ltpaConfig = (LTPAConfiguration)this.ltpaConfigurationRef.getService();
            String pid = this.ltpaConfig.getAuthFilterRef();
            if (pid != null && pid.length() > 0) {
                authFilter = this.getAuthFilterService(pid);
            }
        }
        return authFilter;
    }

    @Activate
    protected synchronized void activate(ComponentContext cc, Map<String, Object> props) {
        this.ltpaConfigurationRef.activate(cc);
        this.authFilterServiceRef.activate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" SSOAuthFilter is actived:" + props), (Object[])new Object[0]);
        }
    }

    @Modified
    protected synchronized void modified(Map<String, Object> props) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(" SSOAuthFilter is modified:" + props), (Object[])new Object[0]);
        }
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext cc) {
        this.ltpaConfigurationRef.deactivate(cc);
        this.authFilterServiceRef.deactivate(cc);
    }
}

