/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jboss.weld.bean.StringBeanIdentifier;
import org.jboss.weld.context.beanstore.NamingScheme;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.Function;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.Iterables;

public abstract class AbstractNamingScheme
implements NamingScheme {
    private final String delimiter;
    private final DeprefixerFunction deprefixerFunction;
    private final PrefixerFunction prefixerFunction;

    public AbstractNamingScheme(String delimiter) {
        this.delimiter = delimiter;
        this.deprefixerFunction = new DeprefixerFunction();
        this.prefixerFunction = new PrefixerFunction();
    }

    @Override
    public boolean accept(String id) {
        String prefix = this.getPrefix();
        return id.startsWith(prefix) && id.startsWith(this.delimiter, prefix.length());
    }

    @Override
    public BeanIdentifier deprefix(String id) {
        return new StringBeanIdentifier(id.substring(this.getPrefix().length() + this.delimiter.length()));
    }

    @Override
    public String prefix(BeanIdentifier id) {
        return this.getPrefix() + this.delimiter + id.asString();
    }

    @Override
    public Collection<String> filterIds(Iterator<String> iterator) {
        if (!iterator.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> filtered = new ArrayList<String>();
        while (iterator.hasNext()) {
            String id = iterator.next();
            if (!this.accept(id)) continue;
            filtered.add(id);
        }
        return filtered;
    }

    @Override
    public Collection<BeanIdentifier> deprefix(Collection<String> ids) {
        return new ArrayList<BeanIdentifier>(ImmutableList.copyOf((Iterable)Iterables.transform(ids, (Function)this.deprefixerFunction)));
    }

    @Override
    public Collection<String> prefix(Collection<BeanIdentifier> ids) {
        return new ArrayList<String>(ImmutableList.copyOf((Iterable)Iterables.transform(ids, (Function)this.prefixerFunction)));
    }

    protected abstract String getPrefix();

    protected String getDelimiter() {
        return this.delimiter;
    }

    class PrefixerFunction
    implements Function<BeanIdentifier, String> {
        PrefixerFunction() {
        }

        public String apply(BeanIdentifier from) {
            return AbstractNamingScheme.this.prefix(from);
        }
    }

    class DeprefixerFunction
    implements Function<String, BeanIdentifier> {
        DeprefixerFunction() {
        }

        public BeanIdentifier apply(String from) {
            return AbstractNamingScheme.this.deprefix(from);
        }
    }
}

