/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context.beanstore;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.context.beanstore.BeanStore;
import org.jboss.weld.serialization.spi.BeanIdentifier;
import org.jboss.weld.util.reflection.Reflections;

public abstract class AbstractMapBackedBeanStore
implements BeanStore {
    protected abstract Map<BeanIdentifier, Object> delegate();

    @Override
    public <T> ContextualInstance<T> get(BeanIdentifier id) {
        return (ContextualInstance)Reflections.cast((Object)this.delegate().get(id));
    }

    @Override
    public void clear() {
        this.delegate().clear();
    }

    @Override
    public boolean contains(BeanIdentifier id) {
        return this.delegate().containsKey(id);
    }

    @Override
    public <T> ContextualInstance<T> remove(BeanIdentifier id) {
        return (ContextualInstance)Reflections.cast((Object)this.delegate().remove(id));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractMapBackedBeanStore) {
            AbstractMapBackedBeanStore that = (AbstractMapBackedBeanStore)obj;
            return this.delegate().equals(that.delegate());
        }
        return false;
    }

    public int hashCode() {
        return this.delegate().hashCode();
    }

    public Set<BeanIdentifier> getContextualIds() {
        return this.delegate().keySet();
    }

    @Override
    public <T> void put(BeanIdentifier id, ContextualInstance<T> beanInstance) {
        this.delegate().put(id, beanInstance);
    }

    public String toString() {
        return "holding " + this.delegate().size() + " instances";
    }

    @Override
    public Iterator<BeanIdentifier> iterator() {
        return this.delegate().keySet().iterator();
    }
}

