/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi31;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.openapi.AnnotationScanner;
import com.ibm.ws.microprofile.openapi.ConfigProcessor;
import com.ibm.ws.microprofile.openapi.OpenAPIFilter;
import com.ibm.ws.microprofile.openapi.Reader;
import com.ibm.ws.microprofile.openapi.StaticFileProcessor;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerImpl;
import com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIParser;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.SwaggerParseResult;
import com.ibm.ws.openapi31.OpenAPIUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.openapi31.OASProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.OASModelReader;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIWebProvider
implements OASProvider {
    private static final TraceComponent tc = Tr.register(OpenAPIWebProvider.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
    private static final String PUBLIC = "mp.openapi.extensions.liberty.public";
    private static final boolean PUBLIC_DEFAULT_VALUE = true;
    private String contextRoot;
    private final ComponentContext ccontext;
    private final Container container;
    private final ClassLoader classloader;
    private final OpenAPI document = null;
    private final boolean isPublic;
    private ServiceRegistration<OASProvider> serviceRegistration;
    private List<String> nonDefaultHosts;
    private static final Dictionary<String, String> PROPS = new Hashtable<String, String>();
    static final long serialVersionUID = -3802710676478136517L;

    public OpenAPIWebProvider(ComponentContext ccontext, Container container, ClassLoader classloader) {
        this.ccontext = ccontext;
        this.container = container;
        this.classloader = classloader;
        Config config = ConfigProvider.getConfig((ClassLoader)this.classloader);
        this.isPublic = OpenAPIUtils.getOptionalValue(config, PUBLIC, Boolean.class, true);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.registerOSGiService();
        } else {
            this.unregisterOSGiService();
        }
    }

    public void setModuleURL(String contextRoot) {
        this.contextRoot = contextRoot;
    }

    public void setNonDefaultHosts(List<String> nonDefaultHosts) {
        this.nonDefaultHosts = nonDefaultHosts;
    }

    /*
     * WARNING - void declaration
     */
    public OpenAPI getOpenAPIModel() {
        OpenAPI document;
        block36: {
            ConfigProcessor configProcessor;
            block35: {
                OASModelReader modelReader;
                if (this.document != null) {
                    return this.document;
                }
                document = null;
                configProcessor = new ConfigProcessor(this.classloader);
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Retrieved configuration values : " + configProcessor), (Object[])new Object[0]);
                }
                if ((modelReader = com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils.getOASModelReader((ClassLoader)this.classloader, (String)configProcessor.getModelReaderClassName())) != null) {
                    try {
                        OpenAPI model = modelReader.buildModel();
                        if (model != null) {
                            document = model;
                            if (OpenAPIUtils.isEventEnabled(tc)) {
                                Tr.event((TraceComponent)tc, (String)"Content from model reader: ", (Object[])new Object[]{OpenAPIUtils.getSerializedJsonDocument(document)});
                            }
                        }
                    }
                    catch (Throwable model) {
                        void e;
                        FFDCFilter.processException((Throwable)model, (String)"com.ibm.ws.openapi31.OpenAPIWebProvider", (String)"131", (Object)this, (Object[])new Object[0]);
                        if (!OpenAPIUtils.isEventEnabled(tc)) break block35;
                        Tr.event((TraceComponent)tc, (String)("Failed to construct model from the application: " + e.getMessage()), (Object[])new Object[0]);
                    }
                }
            }
            String openAPIStaticFile = StaticFileProcessor.getOpenAPIFile((Container)this.container);
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"Content from static file: ", (Object[])new Object[]{openAPIStaticFile});
            }
            if (openAPIStaticFile != null) {
                SwaggerParseResult result = new OpenAPIParser().readContents(openAPIStaticFile, document, null, null);
                if (result != null && result.getOpenAPI() != null) {
                    document = result.getOpenAPI();
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)"Document after merging contents from model reader and static file: ", (Object[])new Object[]{OpenAPIUtils.getSerializedJsonDocument(document)});
                    }
                } else {
                    Tr.error((TraceComponent)tc, (String)"OPENAPI_FILE_PARSE_ERROR", (Object[])new Object[]{this.contextRoot});
                }
            }
            if (!configProcessor.isScanDisabled()) {
                Object foundClasses;
                AnnotationScanner scanner = com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils.creatAnnotationScanner((ClassLoader)this.classloader, (Container)this.container);
                HashSet<String> classNamesToScan = new HashSet<String>();
                if (configProcessor.getClassesToScan() != null) {
                    classNamesToScan.addAll(configProcessor.getClassesToScan());
                }
                if (configProcessor.getPackagesToScan() != null) {
                    foundClasses = scanner.getAnnotatedClassesNames();
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)"Found annotated classes (packages to scan): ", (Object[])new Object[]{foundClasses});
                    }
                    for (String packageName : configProcessor.getPackagesToScan()) {
                        Iterator iterator = foundClasses.iterator();
                        while (iterator.hasNext()) {
                            String className = (String)iterator.next();
                            if (!className.startsWith(packageName)) continue;
                            classNamesToScan.add(className);
                        }
                    }
                }
                if (classNamesToScan.size() == 0 && scanner.anyAnnotatedClasses()) {
                    foundClasses = scanner.getAnnotatedClassesNames();
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)"Found annotated classes (any annotated classes): ", (Object[])new Object[]{foundClasses});
                    }
                    classNamesToScan.addAll((Collection<String>)foundClasses);
                }
                if (configProcessor.getClassesToExclude() != null) {
                    classNamesToScan.removeAll(configProcessor.getClassesToExclude());
                }
                if (configProcessor.getPackagesToExclude() != null) {
                    for (Object packageToExclude : configProcessor.getPackagesToExclude()) {
                        Iterator iterator = classNamesToScan.iterator();
                        while (iterator.hasNext()) {
                            if (!((String)iterator.next()).startsWith((String)packageToExclude)) continue;
                            iterator.remove();
                        }
                    }
                }
                if (classNamesToScan.size() > 0) {
                    HashSet classes = new HashSet();
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)"Final list of class names to scan: ", (Object[])new Object[]{classNamesToScan});
                    }
                    for (String clazz : classNamesToScan) {
                        try {
                            classes.add(this.classloader.loadClass(clazz));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            void e;
                            FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ws.openapi31.OpenAPIWebProvider", (String)"208", (Object)this, (Object[])new Object[0]);
                            if (!OpenAPIUtils.isEventEnabled(tc)) continue;
                            Tr.event((TraceComponent)tc, (String)("Failed to load class: " + e.getMessage()), (Object[])new Object[0]);
                        }
                    }
                    Reader reader = new Reader(document);
                    reader.setApplicationPath(scanner.getURLMapping(classNamesToScan));
                    document = reader.read(classes);
                }
            }
            if (document == null) {
                return document;
            }
            OASFilter oasFilter = com.ibm.ws.microprofile.openapi.utils.OpenAPIUtils.getOASFilter((ClassLoader)this.classloader, (String)configProcessor.getOpenAPIFilterClassName());
            if (oasFilter != null) {
                OpenAPIFilter filter = new OpenAPIFilter(oasFilter);
                try {
                    filter.filter(document);
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)"Document after filtering: ", (Object[])new Object[]{OpenAPIUtils.getSerializedJsonDocument(document)});
                    }
                }
                catch (Throwable classes) {
                    void e;
                    FFDCFilter.processException((Throwable)classes, (String)"com.ibm.ws.openapi31.OpenAPIWebProvider", (String)"232", (Object)this, (Object[])new Object[0]);
                    if (!OpenAPIUtils.isEventEnabled(tc)) break block36;
                    Tr.event((TraceComponent)tc, (String)("Failed to call OASFilter: " + e.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Finished generating document for " + this), (Object[])new Object[0]);
        }
        this.processOpenAPI(document);
        return document;
    }

    public String getOpenAPIDocument() {
        return null;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void registerOSGiService() {
        this.unregisterOSGiService();
        this.serviceRegistration = this.ccontext.getBundleContext().registerService(OASProvider.class, (Object)this, PROPS);
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Register Service Registration Obj: " + this.serviceRegistration), (Object[])new Object[0]);
        }
    }

    public void unregisterOSGiService() {
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Unregister Service Registration Obj: " + this.serviceRegistration), (Object[])new Object[0]);
        }
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
        }
        this.serviceRegistration = null;
    }

    private void processOpenAPI(OpenAPI openapi) {
        String contextRoot = this.getContextRoot();
        if (openapi == null || contextRoot == null || contextRoot.equals("/")) {
            return;
        }
        if (OpenAPIUtils.isContextRootNeeded(openapi, contextRoot)) {
            openapi.addServer(new ServerImpl().url(contextRoot));
        }
        if (this.nonDefaultHosts != null && !this.nonDefaultHosts.isEmpty()) {
            List servers = openapi.getServers();
            if (!OpenAPIUtils.isGlobalServerSpecified(openapi)) {
                for (String host : this.nonDefaultHosts) {
                    openapi.addServer(new ServerImpl().url(host));
                }
            } else {
                ArrayList<Server> newServers = new ArrayList<Server>();
                for (Server server : servers) {
                    String url = server.getUrl();
                    if (url == null || !url.startsWith("/")) continue;
                    for (int i = 0; i < this.nonDefaultHosts.size(); ++i) {
                        if (i == 0) {
                            server.setUrl(this.nonDefaultHosts.get(i) + url);
                            continue;
                        }
                        Server newServer = OpenAPIUtils.copyServer(server);
                        newServer.setUrl(this.nonDefaultHosts.get(i) + url);
                        newServers.add(newServer);
                    }
                }
                servers.addAll(newServers);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OpenAPIWebProvider={");
        sb.append("contextRoot=");
        sb.append(this.getContextRoot());
        sb.append("}");
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        PROPS.put("service.vendor", "IBM");
    }
}

