/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi31;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.microprofile.openapi.impl.core.util.Json;
import com.ibm.ws.microprofile.openapi.impl.model.OpenAPIImpl;
import com.ibm.ws.microprofile.openapi.impl.model.info.InfoImpl;
import com.ibm.ws.microprofile.openapi.impl.model.servers.ServerImpl;
import com.ibm.ws.microprofile.openapi.impl.parser.OpenAPIParser;
import com.ibm.ws.microprofile.openapi.impl.parser.core.models.SwaggerParseResult;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Paths;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.servers.Server;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIUtils {
    private static final String OA_INFO_TITLE = "Liberty REST APIs";
    private static final String OA_INFO_DESCRIPTION = "Discover REST APIs available within Liberty";
    private static final String OA_INFO_VERSION = "1.0.0";
    private static final TraceComponent tc = Tr.register(OpenAPIUtils.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
    static final long serialVersionUID = 1982875034209022665L;

    public static boolean isDebugEnabled(TraceComponent tc) {
        return TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
    }

    public static boolean isEventEnabled(TraceComponent tc) {
        return TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled();
    }

    public static boolean isDumpEnabled(TraceComponent tc) {
        return TraceComponent.isAnyTracingEnabled() && tc.isDumpEnabled();
    }

    public static String getOsgiServiceErrorMessage(Class<?> aClass, String serviceName) {
        return TraceNLS.getFormattedMessage(aClass, (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{serviceName}, (String)"CWWKO1600E: The {0} OSGi service is not available.");
    }

    public static String normalizeContextRoot(String contextRoot) {
        if (contextRoot != null && !contextRoot.trim().isEmpty()) {
            if ("/*".equals(contextRoot)) {
                contextRoot = "/";
            } else if (contextRoot.endsWith("/*")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - 2);
            } else if (contextRoot.endsWith("/")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - 1);
            }
        }
        return contextRoot;
    }

    @Trivial
    @FFDCIgnore(value={JsonProcessingException.class})
    public static String getSerializedJsonDocument(OpenAPI openapi) {
        String oasResult;
        block2: {
            oasResult = null;
            try {
                oasResult = Json.mapper().writeValueAsString((Object)openapi);
            }
            catch (JsonProcessingException e) {
                if (!OpenAPIUtils.isEventEnabled(tc)) break block2;
                Tr.event((TraceComponent)tc, (String)("Failed to serialize OpenAPI docuemnt: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return oasResult;
    }

    public static boolean isContextRootNeeded(OpenAPI openapi, String contextRoot) {
        if (OpenAPIUtils.isGlobalServerSpecified(openapi)) {
            return false;
        }
        Paths paths = openapi.getPaths();
        if (paths != null && !paths.isEmpty()) {
            String path = (String)paths.keySet().iterator().next();
            List pathServers = ((PathItem)paths.get((Object)path)).getServers();
            if (!path.startsWith(contextRoot) && (pathServers == null || pathServers.isEmpty())) {
                return true;
            }
        }
        return false;
    }

    public static boolean isGlobalServerSpecified(OpenAPI openapi) {
        return openapi.getServers() != null && !openapi.getServers().isEmpty();
    }

    public static Server copyServer(Server server) {
        ServerImpl s = new ServerImpl();
        s.setDescription(server.getDescription());
        s.setExtensions(server.getExtensions());
        s.setVariables(server.getVariables());
        s.setUrl(server.getUrl());
        return s;
    }

    public static String stringify(List<?> list) {
        return list == null ? "null" : list.stream().map(i -> i == null ? "null" : i.toString()).collect(Collectors.joining(", ", "[", "]"));
    }

    public static OpenAPI createDefaultOpenAPI() {
        return new OpenAPIImpl().info(new InfoImpl().title(OA_INFO_TITLE).description(OA_INFO_DESCRIPTION).version(OA_INFO_VERSION)).servers(Collections.emptyList());
    }

    public static Info ensureValidInfo(Info info) {
        if (info == null) {
            info = new InfoImpl();
        }
        if (info.getTitle() == null || info.getTitle().isEmpty()) {
            info.setTitle(OA_INFO_TITLE);
        }
        if (info.getVersion() == null || info.getVersion().isEmpty()) {
            info.setVersion(OA_INFO_VERSION);
        }
        return info;
    }

    public static <T> T getOptionalValue(Config config, String propertyName, Class<T> propertyType, T defaultValue) {
        return OpenAPIUtils.getOptionalValue(config, propertyName, propertyType, defaultValue, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T getOptionalValue(Config config, String propertyName, Class<T> propertyType, T defaultValue, Predicate<? super T> filter) {
        try {
            Optional<Object> optional = config.getOptionalValue(propertyName, propertyType);
            if (filter != null) {
                optional = optional.filter(filter);
            }
            return optional.orElse(defaultValue);
        }
        catch (IllegalArgumentException optional) {
            FFDCFilter.processException((Throwable)optional, (String)"com.ibm.ws.openapi31.OpenAPIUtils", (String)"176", null, (Object[])new Object[]{config, propertyName, propertyType, defaultValue, filter});
            if (OpenAPIUtils.isEventEnabled(tc)) {
                void e;
                Tr.event((TraceComponent)tc, (String)("Failed to read config: " + e.getMessage()), (Object[])new Object[0]);
            }
            return defaultValue;
        }
    }

    public static Set<String> getConfigPropAsSet(Config config, String propertyName) {
        String[] configValues = OpenAPIUtils.getOptionalValue(config, propertyName, String[].class, null);
        if (configValues == null || configValues.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> configPropSet = new HashSet<String>();
        for (String s : configValues) {
            if (s == null || !StringUtils.isNotBlank((CharSequence)s)) continue;
            configPropSet.add(s);
        }
        if (configPropSet.isEmpty()) {
            return Collections.emptySet();
        }
        return configPropSet;
    }

    @FFDCIgnore(value={IOException.class})
    public static String getAPIDocFromFile(File file) {
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException ioe) {
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Exception when reading: " + ioe.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static OpenAPI parseOpenAPI(String openapi) {
        block4: {
            if (openapi == null) {
                return null;
            }
            try {
                SwaggerParseResult parseResult = new OpenAPIParser().readContents(openapi, null, null, null);
                if (parseResult != null) {
                    return parseResult.getOpenAPI();
                }
            }
            catch (Exception parseResult) {
                void se;
                FFDCFilter.processException((Throwable)parseResult, (String)"com.ibm.ws.openapi31.OpenAPIUtils", (String)"224", null, (Object[])new Object[]{openapi});
                if (!OpenAPIUtils.isEventEnabled(tc)) break block4;
                Tr.event((TraceComponent)tc, (String)("Exception occurred while trying to read document : \n exception=" + se), (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static void copyOpenAPIObjectExtensions(OpenAPI copyFrom, OpenAPI copyTo) {
        if (copyFrom == null || copyTo == null) {
            return;
        }
        Map extensionsToCopy = copyFrom.getExtensions();
        if (extensionsToCopy != null) {
            for (String key : extensionsToCopy.keySet()) {
                copyTo.addExtension(key, extensionsToCopy.get(key));
            }
        }
    }
}

