/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.metadata.impl;

import org.joda.time.ReadableInstant;
import org.opensaml.Configuration;
import org.opensaml.common.impl.AbstractSAMLObjectMarshaller;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class EntitiesDescriptorMarshaller
extends AbstractSAMLObjectMarshaller {
    private final Logger log = LoggerFactory.getLogger(EntitiesDescriptorMarshaller.class);

    @Override
    protected void marshallAttributes(XMLObject samlElement, Element domElement) {
        EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)((Object)samlElement);
        if (entitiesDescriptor.getID() != null) {
            this.log.debug("Writing ID attribute to EntitiesDescriptor DOM element.");
            domElement.setAttributeNS(null, "ID", entitiesDescriptor.getID());
            domElement.setIdAttributeNS(null, "ID", true);
        }
        if (entitiesDescriptor.getValidUntil() != null) {
            this.log.debug("Writting validUntil attribute to EntitiesDescriptor DOM element");
            String validUntilStr = Configuration.getSAMLDateFormatter().print((ReadableInstant)entitiesDescriptor.getValidUntil());
            domElement.setAttributeNS(null, "validUntil", validUntilStr);
        }
        if (entitiesDescriptor.getCacheDuration() != null) {
            this.log.debug("Writting cacheDuration attribute to EntitiesDescriptor DOM element");
            String cacheDuration = XMLHelper.longToDuration((long)entitiesDescriptor.getCacheDuration());
            domElement.setAttributeNS(null, "cacheDuration", cacheDuration);
        }
        if (entitiesDescriptor.getName() != null) {
            this.log.debug("Writting Name attribute to EntitiesDescriptor DOM element");
            domElement.setAttributeNS(null, "Name", entitiesDescriptor.getName());
        }
    }
}

