/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.core.impl;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.impl.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml1.core.ResponseAbstractType;
import org.opensaml.saml1.core.impl.ResponseUnmarshaller;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class ResponseAbstractTypeUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    private final Logger log = LoggerFactory.getLogger(ResponseUnmarshaller.class);

    public XMLObject unmarshall(Element domElement) throws UnmarshallingException {
        ResponseAbstractType response = (ResponseAbstractType)((Object)super.unmarshall(domElement));
        if (response.getMinorVersion() != 0 && !DatatypeHelper.isEmpty((String)response.getID())) {
            domElement.setIdAttributeNS(null, "ResponseID", true);
        }
        return response;
    }

    @Override
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        ResponseAbstractType response = (ResponseAbstractType)((Object)parentSAMLObject);
        if (childSAMLObject instanceof Signature) {
            response.setSignature((Signature)childSAMLObject);
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    @Override
    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        ResponseAbstractType response = (ResponseAbstractType)((Object)samlObject);
        if (attribute.getLocalName().equals("ResponseID")) {
            response.setID(attribute.getValue());
        } else if (attribute.getLocalName().equals("InResponseTo")) {
            response.setInResponseTo(attribute.getValue());
        } else if (attribute.getLocalName().equals("IssueInstant") && !DatatypeHelper.isEmpty((String)attribute.getValue())) {
            response.setIssueInstant(new DateTime((Object)attribute.getValue(), (Chronology)ISOChronology.getInstanceUTC()));
        } else if (attribute.getLocalName().equals("MinorVersion")) {
            int minor;
            try {
                minor = Integer.parseInt(attribute.getValue());
            }
            catch (NumberFormatException n) {
                this.log.error("Parsing minor version ", (Throwable)n);
                throw new UnmarshallingException((Exception)n);
            }
            if (minor == 0) {
                response.setVersion(SAMLVersion.VERSION_10);
            } else if (minor == 1) {
                response.setVersion(SAMLVersion.VERSION_11);
            }
        } else if (attribute.getLocalName().equals("Recipient")) {
            response.setRecipient(attribute.getValue());
        } else {
            super.processAttribute(samlObject, attribute);
        }
    }
}

