/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.felix.gogo.shell.Builtin;
import org.apache.felix.gogo.shell.Converters;
import org.apache.felix.gogo.shell.Posix;
import org.apache.felix.gogo.shell.Procedural;
import org.apache.felix.gogo.shell.Shell;
import org.apache.felix.gogo.shell.Telnet;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private BundleContext context;
    private ServiceTracker commandProcessorTracker;
    private Set<ServiceRegistration> regs = new HashSet<ServiceRegistration>();
    private ExecutorService executor;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.commandProcessorTracker = this.createCommandProcessorTracker();
        this.commandProcessorTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        Iterator<ServiceRegistration> iterator = this.regs.iterator();
        while (iterator.hasNext()) {
            ServiceRegistration reg = iterator.next();
            reg.unregister();
            iterator.remove();
        }
        this.stopShell();
        this.commandProcessorTracker.close();
    }

    private ServiceTracker createCommandProcessorTracker() {
        return new ServiceTracker(this.context, CommandProcessor.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                CommandProcessor processor = (CommandProcessor)super.addingService(reference);
                Activator.this.startShell(this.context, processor);
                return processor;
            }

            public void removedService(ServiceReference reference, Object service) {
                Activator.this.stopShell();
                super.removedService(reference, service);
            }
        };
    }

    private void startShell(BundleContext context, CommandProcessor processor) {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "gogo");
        this.regs.add(context.registerService(Converter.class.getName(), (Object)new Converters(context.getBundle(0L).getBundleContext()), null));
        ((Dictionary)dict).put("osgi.command.function", Builtin.functions);
        this.regs.add(context.registerService(Builtin.class.getName(), (Object)new Builtin(), dict));
        ((Dictionary)dict).put("osgi.command.function", Procedural.functions);
        this.regs.add(context.registerService(Procedural.class.getName(), (Object)new Procedural(), dict));
        ((Dictionary)dict).put("osgi.command.function", Posix.functions);
        this.regs.add(context.registerService(Posix.class.getName(), (Object)new Posix(), dict));
        ((Dictionary)dict).put("osgi.command.function", Telnet.functions);
        this.regs.add(context.registerService(Telnet.class.getName(), (Object)new Telnet(processor), dict));
        Shell shell = new Shell(context, processor);
        ((Dictionary)dict).put("osgi.command.function", Shell.functions);
        this.regs.add(context.registerService(Shell.class.getName(), (Object)shell, dict));
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                return new Thread(runnable, "Gogo shell");
            }
        });
        this.executor.submit(new StartShellJob(context, processor));
    }

    private void stopShell() {
        if (this.executor != null && !this.executor.isShutdown() && !this.executor.isTerminated()) {
            this.executor.shutdownNow();
            try {
                if (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    System.err.println("!!! FAILED TO STOP EXECUTOR !!!");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.executor = null;
        }
    }

    private static class StartShellJob
    implements Runnable {
        private final BundleContext context;
        private final CommandProcessor processor;

        public StartShellJob(BundleContext context, CommandProcessor processor) {
            this.context = context;
            this.processor = processor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CommandSession session = this.processor.createSession(System.in, System.out, System.err);
            try {
                for (int i = 0; i < 100 && session.get("gogo:gosh") == null; ++i) {
                    TimeUnit.MILLISECONDS.sleep(10L);
                }
                String args = this.context.getProperty("gosh.args");
                args = args == null ? "" : args;
                session.execute((CharSequence)("gosh --login " + args));
            }
            catch (Exception e) {
                Object loc = session.get(".location");
                if (null == loc || !loc.toString().contains(":")) {
                    loc = "gogo";
                }
                System.err.println(loc + ": " + e.getClass().getSimpleName() + ": " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                session.close();
            }
        }
    }
}

