/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oauth20.internal.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import io.openliberty.security.oauth20.internal.config.SpecificOAuthEndpointSettings;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.cm.Configuration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuthEndpointSettings {
    private static final TraceComponent tc = Tr.register(OAuthEndpointSettings.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    public static final String KEY_NAME = "name";
    public static final String KEY_SUPPORTED_HTTP_METHODS = "supportedHttpMethods";
    private final Map<OAuth20Request.EndpointType, SpecificOAuthEndpointSettings> allOAuthEndpointSettings = new HashMap<OAuth20Request.EndpointType, SpecificOAuthEndpointSettings>();
    static final long serialVersionUID = -5004626552053870439L;

    public Map<OAuth20Request.EndpointType, SpecificOAuthEndpointSettings> getAllOAuthEndpointSettings() {
        return this.allOAuthEndpointSettings;
    }

    public SpecificOAuthEndpointSettings getSpecificOAuthEndpointSettings(OAuth20Request.EndpointType endpointType) {
        return this.allOAuthEndpointSettings.get((Object)endpointType);
    }

    @FFDCIgnore(value={RuntimeException.class})
    public void addOAuthEndpointSettings(Configuration endpointSettingsConfig) {
        SpecificOAuthEndpointSettings endpointSettings;
        block5: {
            if (endpointSettingsConfig == null) {
                return;
            }
            Dictionary configProps = endpointSettingsConfig.getProperties();
            if (configProps == null) {
                return;
            }
            endpointSettings = null;
            try {
                OAuth20Request.EndpointType endpoint = this.getEndpointTypeFromConfigName((String)configProps.get(KEY_NAME));
                if (endpoint == null) {
                    return;
                }
                endpointSettings = new SpecificOAuthEndpointSettings(endpoint);
                endpointSettings.setSupportedHttpMethods((String[])configProps.get(KEY_SUPPORTED_HTTP_METHODS));
            }
            catch (RuntimeException e) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Caught an exception reading endpoint settings from the config: {0}. Config properties were {1}", (Object[])new Object[]{e, configProps});
            }
        }
        this.updateAllEndpointSettings(endpointSettings);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    OAuth20Request.EndpointType getEndpointTypeFromConfigName(String endpointName) {
        OAuth20Request.EndpointType endpointType = null;
        try {
            endpointType = OAuth20Request.EndpointType.valueOf(endpointName);
        }
        catch (IllegalArgumentException e) {
            endpointType = this.getNonStandardEndpointTypeFromConfigName(endpointName);
        }
        if (endpointType == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Failed to find matching endpoint type for intput [" + endpointName + "]"), (Object[])new Object[0]);
        }
        return endpointType;
    }

    OAuth20Request.EndpointType getNonStandardEndpointTypeFromConfigName(String endpointName) {
        if ("coverageMap".equals(endpointName)) {
            return OAuth20Request.EndpointType.coverage_map;
        }
        if ("appPasswords".equals(endpointName)) {
            return OAuth20Request.EndpointType.app_password;
        }
        if ("appTokens".equals(endpointName)) {
            return OAuth20Request.EndpointType.app_token;
        }
        return null;
    }

    void updateAllEndpointSettings(SpecificOAuthEndpointSettings newEndpointSettings) {
        if (newEndpointSettings == null) {
            return;
        }
        OAuth20Request.EndpointType newEndpointType = newEndpointSettings.getEndpointType();
        if (this.allOAuthEndpointSettings.containsKey((Object)newEndpointType)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Endpoint settings already recorded for endpoint type {0}. Recorded settings are {1}. The following settings will be ignored: {2}", (Object[])new Object[]{newEndpointType, this.allOAuthEndpointSettings.get((Object)newEndpointType), newEndpointSettings});
            }
        } else {
            this.allOAuthEndpointSettings.put(newEndpointType, newEndpointSettings);
        }
    }
}

