/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.webcontainer.security.CookieHelper;
import com.ibm.ws.webcontainer.security.ReferrerURLCookieHandler;
import com.ibm.ws.webcontainer.security.WebAppSecurityCollaboratorImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuthClientTracker {
    public static final String TRACK_OAUTH_CLIENT_COOKIE_NAME = "WasOAuthTrackClients";
    public static final String POST_LOGOUT_QUERY_PARAMETER_NAME = "clients_interacted_with";
    private final String clientIdDelimiter = ",";
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final OAuth20Provider provider;
    static final long serialVersionUID = -6067776399465575560L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public OAuthClientTracker(HttpServletRequest request, HttpServletResponse response, OAuth20Provider provider) {
        this.request = request;
        this.response = response;
        this.provider = provider;
    }

    public Cookie trackOAuthClient(String clientId) {
        ReferrerURLCookieHandler handler = this.getReferrerURLCookieHandler();
        Cookie trackingCookie = CookieHelper.getCookie((Cookie[])this.request.getCookies(), (String)this.getCookieName());
        trackingCookie = trackingCookie == null ? this.createNewClientTrackingCookie(handler, clientId) : this.updateExistingTrackingCookie(trackingCookie, clientId, handler);
        this.response.addCookie(trackingCookie);
        return trackingCookie;
    }

    public String updateLogoutUrlAndDeleteCookie(String logoutUrl) {
        if (logoutUrl == null || logoutUrl.isEmpty()) {
            return logoutUrl;
        }
        Cookie trackingCookie = CookieHelper.getCookie((Cookie[])this.request.getCookies(), (String)this.getCookieName());
        if (trackingCookie == null) {
            return logoutUrl;
        }
        String updatedUrl = this.getUpdatedLogoutUrl(logoutUrl, trackingCookie);
        this.invalidateCookie();
        return updatedUrl;
    }

    ReferrerURLCookieHandler getReferrerURLCookieHandler() {
        return WebAppSecurityCollaboratorImpl.getGlobalWebAppSecurityConfig().createReferrerURLCookieHandler();
    }

    Cookie createNewClientTrackingCookie(ReferrerURLCookieHandler handler, String clientId) {
        return this.createCookie(handler, this.encodeValue(this.encodeValue(clientId)));
    }

    Cookie createCookie(ReferrerURLCookieHandler handler, String cookieValue) {
        Cookie cookie = handler.createCookie(this.getCookieName(), cookieValue, this.request);
        this.setAdditionalCookieProperties(cookie);
        return cookie;
    }

    Cookie updateExistingTrackingCookie(Cookie trackingCookie, String clientId, ReferrerURLCookieHandler handler) {
        String existingCookieValue = trackingCookie.getValue();
        trackingCookie = existingCookieValue == null || existingCookieValue.isEmpty() ? this.createNewClientTrackingCookie(handler, clientId) : this.updateExistingCookieValue(existingCookieValue, clientId, handler);
        return trackingCookie;
    }

    Cookie updateExistingCookieValue(String existingCookieValue, String clientId, ReferrerURLCookieHandler handler) {
        List<String> clientIdList = this.getExistingTrackedClientIds(existingCookieValue);
        if (!clientIdList.contains(clientId)) {
            clientIdList.add(clientId);
        }
        String updatedCookieValue = this.createCookieValue(clientIdList);
        return this.createCookie(handler, updatedCookieValue);
    }

    List<String> getExistingTrackedClientIds(String rawExistingCookieValue) {
        String[] cookieEntries;
        ArrayList<String> clientIdList = new ArrayList<String>();
        String decodedCookieValue = this.decodeValue(rawExistingCookieValue);
        if (decodedCookieValue == null) {
            return clientIdList;
        }
        for (String clientIdEntry : cookieEntries = decodedCookieValue.split(",")) {
            String decodedClientIdEntry = this.decodeValue(clientIdEntry);
            if (decodedClientIdEntry == null || clientIdList.contains(decodedClientIdEntry)) continue;
            clientIdList.add(decodedClientIdEntry);
        }
        return clientIdList;
    }

    String createCookieValue(List<String> clientIdSet) {
        String updatedCookieValue = "";
        for (String clientIdEntry : clientIdSet) {
            String encodedClientIdEntry = this.encodeValue(clientIdEntry);
            updatedCookieValue = updatedCookieValue + encodedClientIdEntry + ",";
        }
        if (updatedCookieValue.endsWith(",")) {
            updatedCookieValue = updatedCookieValue.substring(0, updatedCookieValue.length() - ",".length());
        }
        return this.encodeValue(updatedCookieValue);
    }

    void setAdditionalCookieProperties(Cookie trackingCookie) {
        trackingCookie.setPath(this.getCookiePath());
        trackingCookie.setSecure(true);
    }

    String getCookiePath() {
        String requestUri = this.request.getRequestURI();
        int firstSlashIndex = requestUri.indexOf("/", 1);
        if (firstSlashIndex < 0) {
            return requestUri;
        }
        return requestUri.substring(0, firstSlashIndex);
    }

    String getUpdatedLogoutUrl(String logoutUrl, Cookie trackingCookie) {
        String existingCookieValue = trackingCookie.getValue();
        if (existingCookieValue == null || existingCookieValue.isEmpty()) {
            return logoutUrl;
        }
        List<String> clientIdList = this.getExistingTrackedClientIds(existingCookieValue);
        return this.addTrackedClientIdsToUrl(logoutUrl, clientIdList);
    }

    String addTrackedClientIdsToUrl(String url, List<String> clientIdList) {
        if (clientIdList == null || clientIdList.isEmpty()) {
            return url;
        }
        String newUrl = url.contains("?") ? url + "&" : url + "?";
        newUrl = newUrl + "clients_interacted_with=";
        for (String clientId : clientIdList) {
            try {
                newUrl = newUrl + URLEncoder.encode(this.encodeValue(clientId), "UTF-8") + ",";
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.oauth20.web.OAuthClientTracker", (String)"165", (Object)this, (Object[])new Object[]{url, clientIdList});
            }
        }
        if (newUrl.endsWith(",")) {
            newUrl = newUrl.substring(0, newUrl.length() - 1);
        }
        return newUrl;
    }

    void invalidateCookie() {
        ReferrerURLCookieHandler handler = this.getReferrerURLCookieHandler();
        Cookie cookie = this.createCookie(handler, "");
        cookie.setMaxAge(0);
        this.response.addCookie(cookie);
    }

    String encodeValue(String input) {
        return Base64Coder.base64Encode((String)input);
    }

    String decodeValue(String input) {
        return Base64Coder.base64Decode((String)input);
    }

    private String getCookieName() {
        return "WasOAuthTrackClients_" + this.provider.getID().hashCode();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.web.OAuthClientTracker", OAuthClientTracker.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    }
}

