/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.web.OAuth20Request;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuth20RequestFilter
implements Filter {
    private static TraceComponent tc = Tr.register(OAuth20RequestFilter.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static final String REGEX_COMPONENT_ID = "/([\\w-]+)/";
    public static final String REGEX_REGISTRATION = "registration(/[ -~]*)?";
    public static final String PATH_PTM = "personalTokenManagement";
    public static final String PATH_UTM = "usersTokenManagement";
    public static final String PATH_CLIENTMGT = "clientManagement";
    private static final String apwuri = "app-passwords";
    private static final String apwuri2 = "app-passwords/.*";
    private static final String atokuri = "app-tokens";
    private static final String atokuri2 = "app-tokens/.*";
    private static final String apwtok = "app-passwords|app-passwords/.*|app-tokens|app-tokens/.*";
    private static final Pattern PATH_RE = Pattern.compile("^/([\\w-]+)/(authorize|token|introspect|revoke|.well-known/openid-configuration|userinfo|logout|registration(/[ -~]*)?|check_session_iframe|end_session|coverage_map|proxy|jwk|app-passwords|app-passwords/.*|app-tokens|app-tokens/.*|personalTokenManagement|usersTokenManagement|clientManagement|clientMetatype)$");
    public static final String PATH_DISCOVERY = ".well-known/openid-configuration";
    public static final String PATH_REGISTRATION = "registration";
    public static final String SLASH_PATH_REGISTRATION = "/registration";
    public static final String PATH_REGISTRATION_SLASH = "registration/";
    static final long serialVersionUID = -3494730887299388187L;

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (response.isCommitted()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"doFilter response.isCommitted() do nothing...", (Object[])new Object[0]);
            }
        } else {
            Matcher matcher = this.endpointRequest(request);
            if (matcher != null) {
                this.setEndpointRequest(request, response, chain, matcher);
            } else {
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"security.oauth20.filter.request.null", (Object[])new Object[]{request.getPathInfo()});
                }
                response.sendError(404);
            }
        }
    }

    public void setEndpointRequest(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Matcher matcher) throws IOException, ServletException {
        OAuth20Request oauth20Request = new OAuth20Request(this.getProviderNameFromUrl(matcher), this.getEndpointTypeFromUrl(matcher), request);
        request.setAttribute("OAuth20Request", (Object)oauth20Request);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected String getProviderNameFromUrl(Matcher m) {
        String componentId = m.group(1);
        return componentId;
    }

    protected OAuth20Request.EndpointType getEndpointTypeFromUrl(Matcher m) {
        OAuth20Request.EndpointType type = OAuth20RequestFilter.getType(m.group(2));
        return type;
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }

    private Matcher endpointRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        Matcher m = PATH_RE.matcher(path);
        if (m.matches()) {
            return m;
        }
        return null;
    }

    private static OAuth20Request.EndpointType getType(String pathType) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("path type is " + pathType), (Object[])new Object[0]);
        }
        if (pathType.equals(PATH_DISCOVERY)) {
            return OAuth20Request.EndpointType.discovery;
        }
        if (pathType.startsWith(apwuri)) {
            return OAuth20Request.EndpointType.app_password;
        }
        if (pathType.startsWith(atokuri)) {
            return OAuth20Request.EndpointType.app_token;
        }
        if (pathType.startsWith(PATH_REGISTRATION_SLASH)) {
            return OAuth20Request.EndpointType.registration;
        }
        return OAuth20Request.EndpointType.valueOf(pathType);
    }
}

