/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.lang.LocalesModifier;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LogoutPages {
    private static TraceComponent tc = Tr.register(LogoutPages.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static String logoutHtml = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\"><html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><title>#TITLE#</title></head><body>#BODY#</body></html>";
    static final long serialVersionUID = -1591840763855241519L;

    String getDefaultLogoutPage(Enumeration<Locale> locales) {
        String logoutTitle = Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale(locales), (String)"LOGOUT_PAGE_TITLE", (Object[])new Object[0]);
        String logoutMessage = Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale(locales), (String)"LOGOUT_PAGE_BODY", (Object[])new Object[0]);
        String logoutString = logoutHtml.replace("#TITLE#", logoutTitle).replace("#BODY#", logoutMessage);
        return logoutString;
    }

    String getDefaultLogoutErrorPage(Enumeration<Locale> locales) {
        String logoutTitle = Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale(locales), (String)"LOGOUT_ERROR_PAGE_TITLE", (Object[])new Object[0]);
        String logoutMessage = Tr.formatMessage((TraceComponent)tc, (Locale)LocalesModifier.getPrimaryLocale(locales), (String)"LOGOUT_ERROR_PAGE_BODY", (Object[])new Object[0]);
        String logoutString = logoutHtml.replace("#TITLE#", logoutTitle).replace("#BODY#", logoutMessage);
        return logoutString;
    }

    void sendDefaultLogoutPage(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.getOutputStream().print(this.getDefaultLogoutPage(req.getLocales()));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.web.LogoutPages", (String)"55", (Object)this, (Object[])new Object[]{req, resp});
        }
    }

    void sendDefaultErrorPage(HttpServletRequest req, HttpServletResponse resp) {
        try {
            resp.getOutputStream().print(this.getDefaultLogoutErrorPage(req.getLocales()));
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.oauth20.web.LogoutPages", (String)"64", (Object)this, (Object[])new Object[]{req, resp});
        }
    }
}

