/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.Serializable;
import java.util.Date;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConsentCacheKey
implements Serializable {
    private static final long serialVersionUID = 3321880892411013256L;
    private static final transient TraceComponent tc = Tr.register(ConsentCacheKey.class, null, null);
    private String clientId;
    private String redirectUri;
    private String scope;
    private String resourceId;
    private Date validSince;
    private int keyLifetimeSeconds;

    public ConsentCacheKey(String clientId, String redirectUri, String scope, String resourceId, int keyLifetimeSeconds) {
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.scope = scope;
        this.resourceId = resourceId;
        if (keyLifetimeSeconds < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Key lifetime cannot be negative. Key lifetime will be set to 0.", (Object[])new Object[0]);
            }
            this.keyLifetimeSeconds = 0;
        } else {
            this.keyLifetimeSeconds = keyLifetimeSeconds;
        }
        this.validSince = new Date();
    }

    public int getLifetime() {
        return this.keyLifetimeSeconds;
    }

    public boolean isValid() {
        long currentTime = new Date().getTime();
        long expiration = this.getExpiration();
        long timeleft = expiration - currentTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Time left for key: " + timeleft), (Object[])new Object[0]);
        }
        if (timeleft > 0L) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Key is valid.", (Object[])new Object[0]);
            }
            return true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Key is invalid.", (Object[])new Object[0]);
        }
        return false;
    }

    public long getExpiration() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key valid since: " + this.validSince.getTime()), (Object[])new Object[0]);
        }
        return this.validSince.getTime() + (long)this.keyLifetimeSeconds * 1000L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clientId == null ? 0 : this.clientId.hashCode());
        result = 31 * result + (this.redirectUri == null ? 0 : this.redirectUri.hashCode());
        result = 31 * result + (this.resourceId == null ? 0 : this.resourceId.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConsentCacheKey other = (ConsentCacheKey)obj;
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.redirectUri == null ? other.redirectUri != null : !this.redirectUri.equals(other.redirectUri)) {
            return false;
        }
        if (this.resourceId == null ? other.resourceId != null : !this.resourceId.equals(other.resourceId)) {
            return false;
        }
        return !(this.scope == null ? other.scope != null : !this.scope.equals(other.scope));
    }
}

