/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.token;

import com.google.gson.JsonArray;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentInternal;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import com.ibm.oauth.core.internal.oauth20.token.impl.OAuth20AuthorizationGrantCodeImpl;
import com.ibm.oauth.core.internal.oauth20.token.impl.OAuth20AuthorizationGrantRefreshImpl;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandlerFactory;
import com.ibm.ws.security.oauth20.ProvidersService;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.util.MessageDigestUtil;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OAuth20TokenFactory {
    static final String CLASS = OAuth20TokenFactory.class.getName();
    static Logger _log = Logger.getLogger(CLASS);
    OAuth20ComponentInternal _component;

    public OAuth20TokenFactory(OAuth20ComponentInternal component) {
        this._component = component;
    }

    public Map<String, String[]> buildTokenMap(String clientId, String username, String redirectUri, String stateId, String[] scope, OAuth20Token token, String grantType) {
        String methodName = "buildTokenMap";
        _log.entering(CLASS, methodName);
        boolean finestLoggable = _log.isLoggable(Level.FINEST);
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        if (clientId != null) {
            result.put("client_id", new String[]{clientId});
        }
        if (username != null) {
            result.put("username", new String[]{username});
        }
        if (redirectUri != null) {
            result.put("redirect_uri", new String[]{redirectUri});
        }
        if (stateId != null) {
            result.put("state_id", new String[]{stateId});
        }
        if (scope != null && scope.length > 0) {
            result.put("scope", scope);
        }
        if (grantType.equals("client_credentials")) {
            this.insertFunctionalIdAndGroup(result, clientId);
        }
        if (token != null) {
            OAuth20ConfigProvider config = this._component.get20Configuration();
            int maxGrantLifetime = config.getMaxAuthGrantLifetimeSeconds();
            int codeLifetime = config.getCodeLifetimeSeconds();
            int remainingLifetime = 0;
            if (token.getType().equals("authorization_grant")) {
                if (token.getSubType().equals("authorization_code")) {
                    int elapsedLifetime = codeLifetime - Integer.parseInt(OAuth20TokenHelper.expiresInSeconds(token));
                    if (finestLoggable) {
                        _log.logp(Level.FINEST, CLASS, methodName, "Elapsed time for " + token.getTokenString() + ": " + elapsedLifetime + " seconds");
                    }
                    remainingLifetime = maxGrantLifetime - elapsedLifetime;
                } else if (token.getSubType().equals("refresh_token")) {
                    remainingLifetime = Integer.parseInt(OAuth20TokenHelper.expiresInSeconds(token));
                }
                if (finestLoggable) {
                    _log.logp(Level.FINEST, CLASS, methodName, "Remaining seconds until max authorization grant lifetime: " + remainingLifetime + " seconds");
                }
                result.put("LIFETIME", new String[]{"" + remainingLifetime});
            }
            OAuth20TokenHelper.addExternalClaims(result, token);
        }
        if (grantType != null && !grantType.isEmpty()) {
            result.put("grant_type", new String[]{grantType});
        }
        _log.exiting(CLASS, methodName, result);
        return result;
    }

    void insertFunctionalIdAndGroup(Map<String, String[]> tokenMap, String clientId) {
        OidcBaseClient clientConfig = null;
        try {
            clientConfig = this._component.get20Configuration().getClientProvider().get(clientId);
        }
        catch (OidcServerException oidcServerException) {
            // empty catch block
        }
        if (clientConfig == null) {
            return;
        }
        if (!(clientConfig instanceof OidcBaseClient)) {
            return;
        }
        OidcBaseClient obc = clientConfig;
        String funcId = obc.getFunctionalUserId();
        String[] funcGroups = OidcOAuth20Util.getStringArray(obc.getFunctionalUserGroupIds());
        if (funcGroups.length > 0) {
            tokenMap.put("functional_user_groupIds", funcGroups);
        }
        if (funcId != null) {
            tokenMap.put("functional_user_id", new String[]{funcId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth20Token createAuthorizationCode(Map<String, String[]> tokenMap) {
        String methodName = "createAuthorizationCode";
        _log.entering(CLASS, methodName);
        OAuth20AuthorizationGrantCodeImpl token = null;
        try {
            OAuth20ConfigProvider config = this._component.get20Configuration();
            int lifetime = config.getCodeLifetimeSeconds();
            int length = config.getCodeLength();
            String clientId = OAuth20Util.getValueFromMap("client_id", tokenMap);
            String username = OAuth20Util.getValueFromMap("username", tokenMap);
            String redirectUri = OAuth20Util.getValueFromMap("redirect_uri", tokenMap);
            String[] scope = tokenMap.get("scope");
            String stateId = OAuth20Util.getValueFromMap("state_id", tokenMap);
            if (stateId == null) {
                stateId = OAuth20Util.generateUUID();
            }
            Map<String, String[]> externalClaims = OAuth20TokenHelper.getExternalClaims(tokenMap);
            String tokenString = OAuth20Util.getRandom(length);
            token = new OAuth20AuthorizationGrantCodeImpl(tokenString, this._component.getParentComponentInstance().getInstanceId(), clientId, username, redirectUri, stateId, scope, lifetime, externalClaims);
            if (token != null && token.isPersistent()) {
                this.persistToken(token);
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth20Token createAccessToken(Map<String, String[]> tokenMap) {
        String methodName = "createAccessToken";
        _log.entering(CLASS, methodName);
        OAuth20Token token = null;
        boolean finestLoggable = _log.isLoggable(Level.FINEST);
        try {
            boolean isJwt;
            int remainingLifetime;
            HashMap<String, String[]> accessTokenMap = new HashMap<String, String[]>();
            accessTokenMap.putAll(tokenMap);
            String componentId = this._component.getParentComponentInstance().getInstanceId();
            accessTokenMap.put("COMPONENTID", new String[]{componentId});
            OAuth20ConfigProvider config = this._component.get20Configuration();
            int lifetime = config.getTokenLifetimeSeconds();
            if (accessTokenMap.containsKey("LIFETIME") && (remainingLifetime = Integer.parseInt(OAuth20Util.getValueFromMap("LIFETIME", accessTokenMap))) < lifetime) {
                lifetime = remainingLifetime;
            }
            String lifeStr = Integer.toString(lifetime);
            if (finestLoggable) {
                _log.logp(Level.FINEST, CLASS, methodName, "Creating access token with remaining lifetime: " + lifeStr + " seconds");
            }
            accessTokenMap.put("LIFETIME", new String[]{lifeStr});
            int length = config.getAccessTokenLength();
            String lengthStr = Integer.toString(length);
            accessTokenMap.put("LENGTH", new String[]{lengthStr});
            OAuth20TokenTypeHandler handler = null;
            try {
                handler = OAuth20TokenTypeHandlerFactory.getHandler(this._component);
            }
            catch (OAuthConfigurationException e) {
                _log.throwing(CLASS, methodName, e);
            }
            token = handler.createToken(accessTokenMap);
            int i = 0;
            OAuth20Provider prov = ProvidersService.getOAuth20Provider(componentId);
            boolean bl = isJwt = prov != null && (prov.isJwtAccessToken() || prov.isMpJwt());
            while (!isJwt && token != null && token.isPersistent() && this.isDuplicateToken(token.getId())) {
                token = handler.createToken(accessTokenMap);
                if (++i <= 10) continue;
                _log.severe("Unexpected failure in OAuth20TokenFactory - unable to get unique token id");
                break;
            }
            if (token != null) {
                OAuth20Provider oauth20Provider = ProvidersService.getOAuth20Provider(componentId);
                if (oauth20Provider != null && oauth20Provider.cacheAccessToken()) {
                    this.persistToken(token);
                }
                if (oauth20Provider == null) {
                    this.persistToken(token);
                }
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth20Token createAccessTokenAsAppPasswordOrToken(Map<String, String[]> tokenMap) {
        String methodName = "createAccessToken";
        _log.entering(CLASS, methodName);
        OAuth20Token token = null;
        boolean finestLoggable = _log.isLoggable(Level.FINEST);
        try {
            HashMap<String, String[]> accessTokenMap = new HashMap<String, String[]>();
            accessTokenMap.putAll(tokenMap);
            String componentId = this._component.getParentComponentInstance().getInstanceId();
            accessTokenMap.put("COMPONENTID", new String[]{componentId});
            OAuth20ConfigProvider config = this._component.get20Configuration();
            int remainingLifetime = 0;
            if (accessTokenMap.containsKey("LIFETIME")) {
                remainingLifetime = Integer.parseInt(OAuth20Util.getValueFromMap("LIFETIME", accessTokenMap));
            }
            String lifeStr = Integer.toString(remainingLifetime);
            if (finestLoggable) {
                _log.logp(Level.FINEST, CLASS, methodName, "Creating access token with remaining lifetime: " + lifeStr + " seconds");
            }
            accessTokenMap.put("LIFETIME", new String[]{lifeStr});
            int length = config.getAccessTokenLength();
            String lengthStr = Integer.toString(length);
            accessTokenMap.put("LENGTH", new String[]{lengthStr});
            OAuth20TokenTypeHandler handler = null;
            try {
                handler = OAuth20TokenTypeHandlerFactory.getHandler(this._component);
            }
            catch (OAuthConfigurationException e) {
                _log.throwing(CLASS, methodName, e);
            }
            token = handler.createToken(accessTokenMap);
            if (token != null) {
                OAuth20Provider oauth20Provider = ProvidersService.getOAuth20Provider(componentId);
                if (oauth20Provider != null && oauth20Provider.cacheAccessToken()) {
                    this.persistToken(token);
                }
                if (oauth20Provider == null) {
                    this.persistToken(token);
                }
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuth20Token createRefreshToken(Map<String, String[]> tokenMap) {
        String methodName = "createRefreshToken";
        _log.entering(CLASS, methodName);
        OAuth20AuthorizationGrantRefreshImpl token = null;
        boolean finestLoggable = _log.isLoggable(Level.FINEST);
        try {
            OAuth20ConfigProvider config = this._component.get20Configuration();
            boolean issueRefreshToken = config.isIssueRefreshToken();
            String clientId = OAuth20Util.getValueFromMap("client_id", tokenMap);
            if (issueRefreshToken) {
                try {
                    JsonArray arrayJson = config.getClientProvider().get(clientId).getGrantTypes();
                    if (arrayJson.size() > 0) {
                        issueRefreshToken = false;
                    }
                    for (int i = 0; i < arrayJson.size(); ++i) {
                        if (!"refresh_token".equals(arrayJson.get(i).getAsString())) continue;
                        issueRefreshToken = true;
                    }
                }
                catch (Exception arrayJson) {
                    // empty catch block
                }
            }
            if (issueRefreshToken) {
                int remainingLifetime = tokenMap.containsKey("LIFETIME") ? Integer.parseInt(OAuth20Util.getValueFromMap("LIFETIME", tokenMap)) : config.getMaxAuthGrantLifetimeSeconds();
                if (finestLoggable) {
                    _log.logp(Level.FINEST, CLASS, methodName, "Creating refresh token with remaining lifetime is: " + remainingLifetime + " seconds");
                }
                int length = config.getRefreshTokenLength();
                String username = OAuth20Util.getValueFromMap("username", tokenMap);
                String redirectUri = OAuth20Util.getValueFromMap("redirect_uri", tokenMap);
                String[] scope = tokenMap.get("scope");
                String stateId = OAuth20Util.getValueFromMap("state_id", tokenMap);
                if (stateId == null) {
                    stateId = OAuth20Util.generateUUID();
                }
                Map<String, String[]> externalClaims = OAuth20TokenHelper.getExternalClaims(tokenMap);
                String tokenString = OAuth20Util.getRandom(length);
                int i = 0;
                while (this.isDuplicateToken(tokenString)) {
                    tokenString = OAuth20Util.getRandom(length);
                    if (++i <= 10) continue;
                    _log.severe("Unexpected failure - unable to get unique refresh token id");
                    break;
                }
                if ((token = new OAuth20AuthorizationGrantRefreshImpl(tokenString, this._component.getParentComponentInstance().getInstanceId(), clientId, username, redirectUri, stateId, scope, remainingLifetime, externalClaims)) != null && token.isPersistent()) {
                    this.persistToken(token);
                }
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return token;
    }

    boolean isDuplicateToken(String tokenString) {
        boolean result = false;
        if (this._component.getTokenCache() instanceof OAuth20EnhancedTokenCache) {
            OAuth20EnhancedTokenCache ecache = (OAuth20EnhancedTokenCache)this._component.getTokenCache();
            result = ecache.getByHash(MessageDigestUtil.getDigest(tokenString)) != null;
        }
        return result;
    }

    public void persistToken(OAuth20Token token) {
        if (token != null) {
            this._component.getTokenCache().add(token.getId(), token, token.getLifetimeSeconds());
        }
    }

    public OAuth20ComponentInternal getOAuth20ComponentInternal() {
        return this._component;
    }
}

