/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.granttype.impl;

import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandler;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class OAuth20GrantTypeHandlerClientCredentialsImpl
implements OAuth20GrantTypeHandler {
    static final String CLASS = OAuth20GrantTypeHandlerClientCredentialsImpl.class.getName();
    private static Logger _log = Logger.getLogger(CLASS);

    @Override
    public List<String> getKeysGrantType(AttributeList attributeList) throws OAuthException {
        String methodName = "getKeysGrantType";
        _log.entering(CLASS, methodName);
        List<String> tokenKeys = null;
        _log.exiting(CLASS, methodName);
        return tokenKeys;
    }

    @Override
    public void validateRequestGrantType(AttributeList attributeList, List<OAuth20Token> tokens) throws OAuthException {
        String methodName = "validateRequestGrantType";
        _log.entering(CLASS, methodName);
        _log.exiting(CLASS, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OAuth20Token> buildTokensGrantType(AttributeList attributeList, OAuth20TokenFactory tokenFactory, List<OAuth20Token> tokens) {
        String methodName = "buildTokensGrantType";
        _log.entering(CLASS, methodName);
        ArrayList<OAuth20Token> tokenList = null;
        try {
            String clientId = attributeList.getAttributeValueByName("client_id");
            String[] scope = attributeList.getAttributeValuesByNameAndType("scope", "urn:ibm:names:oauth:param:request");
            Map<String, String[]> tokenMap = tokenFactory.buildTokenMap(clientId, clientId, null, null, scope, null, "client_credentials");
            OAuth20Util.populateJwtAccessTokenData(attributeList, tokenMap);
            String proxy = attributeList.getAttributeValueByName("X-Forwarded-Host");
            tokenMap.put("X-Forwarded-Host", new String[]{proxy});
            OAuth20Token token = tokenFactory.createAccessToken(tokenMap);
            tokenList = new ArrayList<OAuth20Token>();
            tokenList.add(token);
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
        return tokenList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildResponseGrantType(AttributeList attributeList, List<OAuth20Token> tokens) {
        String methodName = "buildResponseGrantType";
        _log.entering(CLASS, methodName);
        try {
            OAuth20Token token;
            if (tokens.size() >= 1 && (token = tokens.get(0)) != null) {
                String accessToken = token.getTokenString();
                attributeList.setAttribute("access_token", "urn:ibm:names:oauth:response:attribute", new String[]{accessToken});
                String accessTokenId = token.getId();
                attributeList.setAttribute("access_token_id", "urn:ibm:names:oauth:response:metadata", new String[]{accessTokenId});
                String type = token.getSubType();
                attributeList.setAttribute("token_type", "urn:ibm:names:oauth:response:attribute", new String[]{type});
                String expires = OAuth20TokenHelper.expiresInSeconds(token);
                attributeList.setAttribute("expires_in", "urn:ibm:names:oauth:response:attribute", new String[]{expires});
                String stateId = token.getStateId();
                attributeList.setAttribute("state_id", "urn:ibm:names:oauth:state", new String[]{stateId});
                String[] scope = token.getScope();
                attributeList.setAttribute("scope", "urn:ibm:names:oauth:response:attribute", scope);
            }
        }
        finally {
            _log.exiting(CLASS, methodName);
        }
    }
}

