/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.api.error.oauth20;

import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20ExceptionUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.security.oauth20.web.WebUtils;
import java.text.MessageFormat;
import java.util.Locale;

public class OAuth20InvalidClientException
extends OAuth20Exception {
    private static final TraceComponent tc = Tr.register(OAuth20InvalidClientException.class, (String)"OAUTH20", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    private static final long serialVersionUID = 1L;
    private static final String END_USER_MSG_KEY = "security.oauth20.error.invalid.client.enduser";
    private String _clientId;

    public OAuth20InvalidClientException(String clientId, boolean isTokenRequest) {
        super(null, "The client could not be found: " + clientId, null);
        this.resolveErrorType(isTokenRequest);
        this._clientId = clientId;
    }

    public OAuth20InvalidClientException(String msgKey, String clientId, boolean isTokenRequest) {
        super(null, Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])new Object[]{clientId}), null);
        this.resolveErrorType(isTokenRequest);
        this._msgKey = msgKey;
        this._clientId = clientId;
    }

    @Override
    public String formatSelf(Locale locale, String encoding) {
        if (this.isMessageForEndUser()) {
            return this.getFormattedMsg(locale, END_USER_MSG_KEY, null);
        }
        if (this._msgKey != null) {
            return this.getFormattedMsg(locale, this._msgKey, new Object[]{WebUtils.encode(this._clientId, locale, encoding)});
        }
        return this.getMessage();
    }

    private boolean isMessageForEndUser() {
        return "unauthorized_client".equals(this._error);
    }

    private String getFormattedMsg(Locale locale, String key, Object[] arguments) {
        return MessageFormat.format(OAuth20ExceptionUtil.getResourceBundle(locale).getString(key), arguments);
    }

    public String getClientId() {
        return this._clientId;
    }

    private void resolveErrorType(boolean isTokenRequest) {
        this._error = isTokenRequest ? "invalid_client" : "unauthorized_client";
    }
}

