/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.featureUtility.cli;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.RepositoryConfigValidationResult;
import com.ibm.ws.install.featureUtility.props.FeatureUtilityProperties;
import com.ibm.ws.install.featureUtility.props.PropertiesUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.MavenRepository;
import com.ibm.ws.install.internal.cmdline.InstallExecutor;
import com.ibm.ws.kernel.boot.ReturnCode;
import com.ibm.ws.kernel.boot.cmdline.ActionHandler;
import com.ibm.ws.kernel.boot.cmdline.Arguments;
import com.ibm.ws.kernel.boot.cmdline.ExitCode;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ViewSettingsAction
implements ActionHandler {
    private Properties repoProperties;
    private File repoPropertiesFile;
    private List<String> orderList;
    private final Logger logger = Logger.getLogger("com.ibm.ws.install");
    private List<RepositoryConfigValidationResult> validationResults;
    private boolean isViewValidationMessages;

    ReturnCode initialize(Arguments args) {
        this.isViewValidationMessages = args.getOption("viewvalidationmessages") != null;
        return ReturnCode.OK;
    }

    public ExitCode handleTask(PrintStream stdout, PrintStream stderr, Arguments args) {
        block5: {
            ReturnCode rc = this.initialize(args);
            if (!rc.equals((Object)ReturnCode.OK)) {
                return rc;
            }
            if (FeatureUtilityProperties.didLoadProperties()) {
                try {
                    this.repoProperties = FeatureUtilityProperties.loadProperties();
                    this.showSettings();
                    if (this.validationResults.size() > 0) {
                        return ReturnCode.BAD_ARGUMENT;
                    }
                    break block5;
                }
                catch (InstallException e) {
                    this.logger.log(Level.SEVERE, e.getMessage());
                    return InstallExecutor.returnCode((int)e.getRc());
                }
            }
            this.showSettingsTemplate();
        }
        return ReturnCode.OK;
    }

    private void showHeader() throws InstallException {
        StringBuffer sb = new StringBuffer();
        String settingsPath = FeatureUtilityProperties.getRepoPropertiesFile().getPath();
        sb.append(InstallUtils.NEWLINE);
        sb.append(PropertiesUtils.getMessage("MSG_FEATUREUTILITY_SETTTINGS", new Object[0])).append(InstallUtils.NEWLINE);
        sb.append("----------------------------------------------------------------------").append(InstallUtils.NEWLINE);
        sb.append(PropertiesUtils.getMessage("FIELD_PROPS_FILE", settingsPath));
        sb.append(InstallUtils.NEWLINE);
        String defaultRepoUseage = FeatureUtilityProperties.isUsingDefaultRepo() ? PropertiesUtils.getMessage("MSG_TRUE", new Object[0]) : PropertiesUtils.getMessage("MSG_FALSE", new Object[0]);
        sb.append(PropertiesUtils.getMessage("MSG_DEFAULT_REPO_NAME_LABEL", new Object[0]) + " " + PropertiesUtils.getMessage("MSG_DEFAULT_REPO_NAME", new Object[0])).append(InstallUtils.NEWLINE);
        sb.append(PropertiesUtils.getMessage("MSG_DEFAULT_REPO_USEAGE_LABEL", new Object[0]) + " " + defaultRepoUseage).append(InstallUtils.NEWLINE);
        System.out.println(sb.toString());
    }

    private void showLocalRepository() {
        StringBuffer sb = new StringBuffer();
        String featureLocalRepo = FeatureUtilityProperties.getFeatureLocalRepo();
        if (featureLocalRepo == null) {
            featureLocalRepo = Paths.get(System.getProperty("user.home"), ".m2", "repository", "").toString();
        }
        sb.append(PropertiesUtils.getMessage("FIELD_LOCATION", new Object[0]) + " " + featureLocalRepo).append(InstallUtils.NEWLINE);
        sb.append(InstallUtils.NEWLINE);
        System.out.println(PropertiesUtils.getMessage("MSG_MAVEN_LOCAL_REPO", new Object[0]));
        System.out.println("----------------------------------------------------------------------");
        System.out.print(sb.toString());
    }

    private void showRepositories() throws InstallException {
        StringBuffer sb = new StringBuffer();
        for (MavenRepository repo : FeatureUtilityProperties.getMirrorRepositories()) {
            String r = repo.getName();
            String url = repo.getRepositoryUrl();
            String user = repo.getUserId();
            String pass = repo.getPassword();
            url = url == null || url.isEmpty() ? PropertiesUtils.getMessage("MSG_UNSPECIFIED", new Object[0]) : url;
            user = user == null || user.isEmpty() ? PropertiesUtils.getMessage("MSG_UNSPECIFIED", new Object[0]) : user;
            String warningDetail = null;
            if (pass == null || pass.isEmpty()) {
                pass = PropertiesUtils.getMessage("MSG_UNSPECIFIED", new Object[0]);
                continue;
            }
            try {
                PasswordUtil.decode((String)pass);
                pass = "********";
            }
            catch (InvalidPasswordDecodingException ipde) {
                warningDetail = PropertiesUtils.getMessage("MSG_PASSWORD_NOT_ENCODED_PROXY", new Object[0]);
                pass = "********";
            }
            catch (UnsupportedCryptoAlgorithmException ucae) {
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PWD_CRYPTO_UNSUPPORTED", new Object[0]), (Throwable)ucae, 33);
            }
            sb.append(PropertiesUtils.getMessage("FIELD_NAME", new Object[0]) + " " + r).append(InstallUtils.NEWLINE);
            sb.append(PropertiesUtils.getMessage("FIELD_LOCATION", new Object[0]) + " " + url).append(InstallUtils.NEWLINE);
            if (PropertiesUtils.isFileProtocol(url)) {
                sb.append(PropertiesUtils.getMessage("FIELD_USER", new Object[0]) + " " + PropertiesUtils.getMessage("MSG_INAPPLICABLE", new Object[0])).append(InstallUtils.NEWLINE);
                sb.append(PropertiesUtils.getMessage("FIELD_PASS", new Object[0]) + " " + PropertiesUtils.getMessage("MSG_INAPPLICABLE", new Object[0])).append(InstallUtils.NEWLINE);
            } else {
                sb.append(PropertiesUtils.getMessage("FIELD_USER", new Object[0]) + " " + user).append(InstallUtils.NEWLINE);
                sb.append(PropertiesUtils.getMessage("FIELD_PASS", new Object[0]) + " " + pass).append(InstallUtils.NEWLINE);
                if (warningDetail != null) {
                    sb.append(PropertiesUtils.getMessage("FIELD_REPO_WARNING", warningDetail)).append(InstallUtils.NEWLINE);
                }
            }
            sb.append(InstallUtils.NEWLINE);
        }
        System.out.println(PropertiesUtils.getMessage("MSG_CONFIG_REPO_LABEL", new Object[0]));
        System.out.println("----------------------------------------------------------------------");
        if (sb.length() > 0) {
            System.out.print(sb.toString());
        } else {
            System.out.println(PropertiesUtils.getMessage("MSG_NO_CONFIG_REPO", new Object[0]));
            System.out.println();
        }
    }

    private void showProxyInfo() throws InstallException {
        StringBuffer proxInfo = new StringBuffer();
        String pHost = null;
        if (FeatureUtilityProperties.didLoadProperties()) {
            String pPort;
            pHost = FeatureUtilityProperties.getProxyHost();
            if (pHost != null && !pHost.isEmpty()) {
                proxInfo.append(PropertiesUtils.getMessage("FIELD_PROXY_SERVER", new Object[0]) + " " + pHost).append(InstallUtils.NEWLINE);
            }
            pPort = (pPort = FeatureUtilityProperties.getProxyPort()) == null || pPort.isEmpty() ? PropertiesUtils.getMessage("MSG_UNSPECIFIED", new Object[0]) : pPort;
            proxInfo.append(PropertiesUtils.getMessage("FIELD_PORT", new Object[0]) + " " + pPort).append(InstallUtils.NEWLINE);
            String pUser = FeatureUtilityProperties.getProxyUser();
            pUser = pUser == null || pUser.isEmpty() ? PropertiesUtils.getMessage("MSG_UNSPECIFIED", new Object[0]) : pUser;
            proxInfo.append(PropertiesUtils.getMessage("FIELD_USER", new Object[0]) + " " + pUser).append(InstallUtils.NEWLINE);
            String pUserPwd = FeatureUtilityProperties.getProxyPassword();
            String warning = null;
            if (pUserPwd == null || pUserPwd.isEmpty()) {
                pUserPwd = PropertiesUtils.getMessage("MSG_UNSPECIFIED", new Object[0]);
            } else {
                pUserPwd = "********";
                try {
                    PasswordUtil.decode((String)pUserPwd);
                    proxInfo.append(PropertiesUtils.getMessage("FIELD_PASS", new Object[0]) + " " + pUserPwd).append(InstallUtils.NEWLINE);
                }
                catch (InvalidPasswordDecodingException ipde) {
                    String warningMessage = PropertiesUtils.getMessage("MSG_PASSWORD_NOT_ENCODED_PROXY", new Object[0]);
                    warning = PropertiesUtils.getMessage("FIELD_REPO_WARNING", warningMessage);
                }
                catch (UnsupportedCryptoAlgorithmException ucae) {
                    throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_TOOL_PROXY_PWD_CRYPTO_UNSUPPORTED", new Object[0]), (Throwable)ucae, 21);
                }
            }
            proxInfo.append(PropertiesUtils.getMessage("FIELD_PASS", new Object[0]) + " " + pUserPwd).append(InstallUtils.NEWLINE);
            if (warning != null) {
                proxInfo.append(warning).append(InstallUtils.NEWLINE);
            }
        }
        System.out.println(PropertiesUtils.getMessage("MSG_PROXY_LABEL", new Object[0]));
        System.out.println("----------------------------------------------------------------------");
        if (pHost != null) {
            System.out.print(proxInfo.toString());
            System.out.println();
        } else {
            System.out.print(PropertiesUtils.getMessage("MSG_NO_CONFIG_PROXY", new Object[0]));
            System.out.println();
        }
    }

    private void showSettingsTemplate() {
        StringBuffer sb = new StringBuffer();
        InstallUtils.wordWrap((StringBuffer)sb, (String)PropertiesUtils.getMessage("MSG_PROPERTIES_FILE_NOT_FOUND", new Object[0]), (String)"");
        sb.append(InstallUtils.NEWLINE);
        InstallUtils.wordWrap((StringBuffer)sb, (String)PropertiesUtils.getMessage("MSG_PROPERTIES_FILE_NOT_FOUND_EXPLANATION", FeatureUtilityProperties.getRepoPropertiesFileLocation()), (String)"");
        sb.append(InstallUtils.NEWLINE);
        InstallUtils.wordWrap((StringBuffer)sb, (String)PropertiesUtils.getMessage("MSG_PROPERTIES_FILE_NOT_FOUND_ACTION", new Object[0]), (String)"");
        System.out.print(sb.toString());
        System.out.println("----------------------------------------------------------------------");
        System.out.println(PropertiesUtils.getSampleConfig());
    }

    private void showValidationResults() throws InstallException {
        StringBuffer sb = new StringBuffer();
        sb.append(PropertiesUtils.getMessage("MSG_VALIDATION_MESSAGES", new Object[0])).append(InstallUtils.NEWLINE);
        sb.append("----------------------------------------------------------------------").append(InstallUtils.NEWLINE);
        this.validationResults = PropertiesUtils.validateRepositoryPropertiesFile(this.repoProperties);
        if (this.validationResults.size() == 0) {
            sb.append(PropertiesUtils.getMessage("FIELD_VALIDATION_RESULTS", PropertiesUtils.getMessage("MSG_VALIDATION_SUCCESSFUL", new Object[0]))).append(InstallUtils.NEWLINE);
        } else if (!this.isViewValidationMessages) {
            sb.append(PropertiesUtils.getMessage("FIELD_VALIDATION_RESULTS", PropertiesUtils.getMessage("MSG_VALIDATION_FAILED_NO_MESSAGES", new Object[0]))).append(InstallUtils.NEWLINE);
        } else {
            sb.append(PropertiesUtils.getMessage("MSG_VALIDATION_NUM_OF_ERRORS", this.validationResults.size())).append(InstallUtils.NEWLINE);
            sb.append(InstallUtils.NEWLINE);
            for (RepositoryConfigValidationResult vr : this.validationResults) {
                sb.append(PropertiesUtils.getMessage("FIELD_VALIDATION_LINE", vr.getLineNum())).append(InstallUtils.NEWLINE);
                sb.append(PropertiesUtils.getMessage("MSG_VALIDATION_MESSAGE_FORMAT", vr.getFailedReason(), vr.getValidationMessage())).append(InstallUtils.NEWLINE);
                sb.append(InstallUtils.NEWLINE);
            }
        }
        System.out.println(sb.toString());
    }

    private void showSettings() throws InstallException {
        this.showHeader();
        this.showValidationResults();
        this.showLocalRepository();
        this.showRepositories();
        this.showProxyInfo();
    }
}

