/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.security.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.ws.BatchGroupSecurityHelper;
import com.ibm.jbatch.container.ws.JoblogUtil;
import com.ibm.jbatch.container.ws.ROLES;
import com.ibm.jbatch.container.ws.WSBatchAuthService;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.authorization.AuthorizationService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.security.registry.RegistryHelper;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class WSBatchAuthServiceImpl
implements WSBatchAuthService {
    public static final String BATCH_AUTH_ID = "com.ibm.ws.batch";
    private static final Logger logger = Logger.getLogger(WSBatchAuthServiceImpl.class.getCanonicalName(), "com.ibm.ws.jbatch.security.resources.BatchSecurityMessages");
    private IPersistenceManagerService persistenceManagerService;
    private BatchSecurityHelper batchSecurityHelper;
    private BatchGroupSecurityHelper batchGroupSecurityHelper;
    private static final String SecurityServiceReferenceName = "securityService";
    protected final AtomicServiceReference<SecurityService> securityServiceRef;
    static final long serialVersionUID = 3917268709222838872L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public WSBatchAuthServiceImpl() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "<init>", new Object[0]);
        }
        this.batchSecurityHelper = null;
        this.batchGroupSecurityHelper = null;
        this.securityServiceRef = new AtomicServiceReference(SecurityServiceReferenceName);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(name="securityService", service=SecurityService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setSecurityService(ServiceReference<SecurityService> reference) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setSecurityService", new Object[]{reference});
        }
        this.securityServiceRef.setReference(reference);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setSecurityService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetSecurityService(ServiceReference<SecurityService> reference) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetSecurityService", new Object[]{reference});
        }
        this.securityServiceRef.unsetReference(reference);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetSecurityService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Activate
    protected void activate(ComponentContext cc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "activate", new Object[]{cc});
        }
        this.securityServiceRef.activate(cc);
        logger.log(Level.INFO, "BATCH_SECURITY_ENABLED");
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "activate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "deactivate", new Object[]{cc});
        }
        logger.log(Level.INFO, "BATCH_SECURITY_DISABLED");
        this.securityServiceRef.deactivate(cc);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "deactivate");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected AuthorizationService getAuthorizationService() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getAuthorizationService", new Object[0]);
        }
        SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
        AuthorizationService authorizationService = securityService != null ? securityService.getAuthorizationService() : null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            authorizationService = authorizationService;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getAuthorizationService", authorizationService);
        }
        return authorizationService;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    protected void setBatchGroupSecurityHelper(BatchGroupSecurityHelper batchGroupSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setBatchGroupSecurityHelper", new Object[]{batchGroupSecurityHelper});
        }
        this.batchGroupSecurityHelper = batchGroupSecurityHelper;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setBatchGroupSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference
    protected void setBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setBatchSecurityHelper", new Object[]{batchSecurityHelper});
        }
        this.batchSecurityHelper = batchSecurityHelper;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    protected void setIPersistenceManagerService(IPersistenceManagerService pms) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setIPersistenceManagerService", new Object[]{pms});
        }
        this.persistenceManagerService = pms;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "setIPersistenceManagerService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetBatchSecurityHelper(BatchSecurityHelper batchSecurityHelper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetBatchSecurityHelper", new Object[]{batchSecurityHelper});
        }
        if (this.batchSecurityHelper == batchSecurityHelper) {
            this.batchSecurityHelper = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected void unsetIPersistenceManagerService(IPersistenceManagerService pms) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetIPersistenceManagerService", new Object[]{pms});
        }
        if (this.persistenceManagerService == pms) {
            this.persistenceManagerService = null;
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "unsetIPersistenceManagerService");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedInstanceRead(long instanceId) throws JobSecurityException, NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedInstanceRead", new Object[]{instanceId});
        }
        String submitter = this.persistenceManagerService.getJobInstanceSubmitter(instanceId);
        Set listOfGroupsForJobID = null;
        Set<String> listOfGroupsForSubject = null;
        boolean checkGroupSecurity = false;
        if (!this.isAdmin(this.runAsSubject()) && !this.isMonitor(this.runAsSubject())) {
            if (this.isSubmitter(this.runAsSubject())) {
                boolean submitterRole = this.isSubmitter(this.runAsSubject());
                boolean isGroupAdmin = this.isGroupAdmin();
                boolean isGroupMonitor = this.isGroupMonitor();
                if (!this.batchSecurityHelper.getRunAsUser().equals(submitter)) {
                    if (!this.isGroupAdmin() && !this.isGroupMonitor()) throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_JOB_INSTANCE", new Object[]{this.getRunAsUser(), instanceId}, "CWWKY0302W: User {0} is not authorized to perform batch operations associated with job instance {1}."));
                    checkGroupSecurity = true;
                }
            } else {
                if (!this.isGroupAdmin() && !this.isGroupMonitor()) throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_NO_BATCH_ROLES", new Object[]{this.getRunAsUser()}, "CWWKY0303W: User {0} is not authorized to perform any batch operations."));
                checkGroupSecurity = true;
            }
        }
        if (checkGroupSecurity) {
            listOfGroupsForJobID = this.persistenceManagerService.getJobInstance(instanceId).getGroupNames();
            listOfGroupsForSubject = this.getSubjectGroups(this.runAsSubject());
            if (!this.subjectInGroups(listOfGroupsForSubject, listOfGroupsForJobID)) {
                String log_jobGroups = this.constructGroupListForAuthFailString(listOfGroupsForJobID);
                if (this.batchGroupSecurityHelper != null) {
                    logger.fine(log_jobGroups);
                    logger.warning(this.getFormattedMessage("USER_GROUP_UNAUTHORIZED_JOB_INSTANCE", new Object[]{instanceId, this.getRunAsUser(), this.constructGroupListForAuthFailString(listOfGroupsForJobID)}, "CWWKY0305W: Access to job instance {0} denied.  The job has an operation group name defined and the user {1} has batchGroupMonitor or batchGroupAdmin authority but is not a member of the any appropriate group {2}."));
                    throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_JOB_INSTANCE", new Object[]{this.getRunAsUser(), instanceId}, "CWWKY0302W: User {0} is not authorized to perform batch operations associated with job instance {1}."));
                }
            }
        }
        long l = instanceId;
        if (logger == null || !logger.isLoggable(Level.FINER)) return l;
        l = l;
        logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedInstanceRead", l);
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String constructGroupListForAuthFailString(Set<String> listOfGroups) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "constructGroupListForAuthFailString", new Object[]{listOfGroups});
        }
        Iterator<String> it = listOfGroups.iterator();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        while (it.hasNext()) {
            buf.append((Object)it.next());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append("]");
        String string = buf.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "constructGroupListForAuthFailString", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Set<String> getSubjectGroups(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getSubjectGroups", new Object[]{runAsSubject});
        }
        if (this.batchGroupSecurityHelper != null) {
            Set set = this.batchGroupSecurityHelper.getGroupsForSubject(runAsSubject);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                set = set;
                logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getSubjectGroups", set);
            }
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getSubjectGroups", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedExecutionRead(long executionId) throws JobSecurityException, NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedExecutionRead", new Object[]{executionId});
        }
        long instanceId = this.persistenceManagerService.getJobInstanceIdFromExecutionId(executionId);
        this.authorizedInstanceRead(instanceId);
        long l = executionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedExecutionRead", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getRunAsUser() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getRunAsUser", new Object[0]);
        }
        String string = this.batchSecurityHelper.getRunAsUser();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getRunAsUser", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void authorizedJobSubmission() throws JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobSubmission", new Object[0]);
        }
        if (!this.isAdmin(this.runAsSubject()) && !this.isSubmitter(this.runAsSubject())) {
            throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_TO_START_JOB", new Object[]{this.getRunAsUser()}, "CWWKY0304W: User {0} is not authorized to start batch jobs."));
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobSubmission");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobRestartByExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobRestartByExecution", new Object[]{executionId});
        }
        long l = this.authorizedJobStopRestartByExecution(executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobRestartByExecution", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobRestartByInstance(long instanceId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobRestartByInstance", new Object[]{instanceId});
        }
        long l = this.authorizedJobStopRestartByInstance(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobRestartByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobStopByExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopByExecution", new Object[]{executionId});
        }
        long l = this.authorizedJobStopRestartByExecution(executionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopByExecution", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobStopByInstance(long instanceId) throws JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopByInstance", new Object[]{instanceId});
        }
        long l = this.authorizedJobStopRestartByInstance(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long authorizedJobStopRestartByExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestartByExecution", new Object[]{executionId});
        }
        long instanceId = this.persistenceManagerService.getJobInstanceIdFromExecutionId(executionId);
        String submitter = this.persistenceManagerService.getJobInstanceSubmitter(instanceId);
        this.authorizedJobStopRestart(submitter, instanceId);
        long l = executionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestartByExecution", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long authorizedJobStopRestartByInstance(long instanceId) throws JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestartByInstance", new Object[]{instanceId});
        }
        String submitter = this.persistenceManagerService.getJobInstanceSubmitter(instanceId);
        this.authorizedJobStopRestart(submitter, instanceId);
        long l = instanceId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestartByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void authorizedWriteOperationAccessCheck(String submitter, long instanceId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedWriteOperationAccessCheck", new Object[]{submitter, instanceId});
        }
        Set listOfGroupsForJobID = null;
        Set<String> listOfGroupsForSubject = null;
        boolean checkGroupSecurity = false;
        if (this.isInAnyBatchRole()) {
            if (!this.isAdmin(this.runAsSubject())) {
                if (this.isSubmitter(this.runAsSubject())) {
                    boolean submitterRole = this.isSubmitter(this.runAsSubject());
                    boolean isGroupAdmin = this.isGroupAdmin();
                    boolean isGroupMonitor = this.isGroupMonitor();
                    if (!this.batchSecurityHelper.getRunAsUser().equals(submitter) && isGroupAdmin) {
                        checkGroupSecurity = true;
                    }
                } else if (this.isGroupAdmin()) {
                    checkGroupSecurity = true;
                } else if (this.isMonitor(this.runAsSubject()) || this.isGroupMonitor()) {
                    throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_JOB_INSTANCE", new Object[]{this.getRunAsUser(), instanceId}, "CWWKY0302W: User {0} is not authorized to perform batch operations associated with job instance {1}."));
                }
            }
        } else {
            throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_JOB_INSTANCE", new Object[]{this.getRunAsUser(), instanceId}, "CWWKY0302W: User {0} is not authorized to perform batch operations associated with job instance {1}."));
        }
        if (checkGroupSecurity) {
            listOfGroupsForJobID = this.persistenceManagerService.getJobInstance(instanceId).getGroupNames();
            listOfGroupsForSubject = this.getSubjectGroups(this.runAsSubject());
            if (!this.subjectInGroups(listOfGroupsForSubject, listOfGroupsForJobID)) {
                String log_jobGroups = this.constructGroupListForAuthFailString(listOfGroupsForJobID);
                if (this.batchGroupSecurityHelper != null) {
                    logger.fine(log_jobGroups);
                    logger.warning(this.getFormattedMessage("USER_GROUP_UNAUTHORIZED_JOB_INSTANCE", new Object[]{instanceId, this.getRunAsUser(), this.constructGroupListForAuthFailString(listOfGroupsForJobID)}, "CWWKY0305W: Access to job instance {0} denied.  The job has an operation group name defined and the user {1} has batchGroupMonitor or batchGroupAdmin authority but is not a member of the following configured groups: {2}."));
                    throw new JobSecurityException(this.getFormattedMessage("USER_UNAUTHORIZED_JOB_INSTANCE", new Object[]{this.getRunAsUser(), instanceId}, "CWWKY0302W: User {0} is not authorized to perform batch operations associated with job instance {1}."));
                }
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedWriteOperationAccessCheck");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void authorizedJobStopRestart(String submitter, long instanceId) throws NoSuchJobExecutionException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestart", new Object[]{submitter, instanceId});
        }
        this.authorizedWriteOperationAccessCheck(submitter, instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobStopRestart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobPurgeByInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobPurgeByInstance", new Object[]{instanceId});
        }
        long l = this.authorizedJobPurgeAbandonByInstance(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobPurgeByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedJobAbandonByInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobAbandonByInstance", new Object[]{instanceId});
        }
        long l = this.authorizedJobPurgeAbandonByInstance(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobAbandonByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private long authorizedJobPurgeAbandonByInstance(long instanceId) throws NoSuchJobInstanceException, JobSecurityException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobPurgeAbandonByInstance", new Object[]{instanceId});
        }
        String submitter = this.persistenceManagerService.getJobInstanceSubmitter(instanceId);
        this.authorizedWriteOperationAccessCheck(submitter, instanceId);
        long l = instanceId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedJobPurgeAbandonByInstance", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isGroupAdmin() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isGroupAdmin", new Object[0]);
        }
        boolean bl = this.isGroupAdmin(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isGroupAdmin", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAdmin() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAdmin", new Object[0]);
        }
        boolean bl = this.isAdmin(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAdmin", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isSubmitter() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isSubmitter", new Object[0]);
        }
        boolean bl = this.isSubmitter(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isSubmitter", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isMonitor() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isMonitor", new Object[0]);
        }
        boolean bl = this.isMonitor(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isMonitor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isGroupMonitor() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isGroupMonitor", new Object[0]);
        }
        boolean bl = this.isGroupMonitor(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isGroupMonitor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isInAnyBatchRole() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", new Object[0]);
        }
        boolean bl = this.isInAnyBatchRole(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={JobSecurityException.class})
    public boolean isAuthorizedInstanceRead(long instanceId) throws NoSuchJobInstanceException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedInstanceRead", new Object[]{instanceId});
        }
        try {
            this.authorizedInstanceRead(instanceId);
        }
        catch (JobSecurityException jse) {
            boolean bl = false;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedInstanceRead", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedInstanceRead", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean subjectInGroups(Set<String> listOfGroupsForSubject, Set<String> listOfGroupsForJobID) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "subjectInGroups", new Object[]{listOfGroupsForSubject, listOfGroupsForJobID});
        }
        Iterator<String> it = listOfGroupsForSubject.iterator();
        while (it.hasNext()) {
            if (!listOfGroupsForJobID.contains(it.next())) continue;
            boolean bl = true;
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "subjectInGroups", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "subjectInGroups", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean isAuthorizedExecutionRead(long executionId) throws NoSuchJobExecutionException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedExecutionRead", new Object[]{executionId});
        }
        long instanceId = this.persistenceManagerService.getJobInstanceIdFromExecutionId(executionId);
        boolean bl = this.isAuthorizedInstanceRead(instanceId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAuthorizedExecutionRead", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public long authorizedStepExecutionRead(long stepExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedStepExecutionRead", new Object[]{stepExecutionId});
        }
        long instanceId = this.persistenceManagerService.getStepExecutionTopLevel(stepExecutionId).getJobExecution().getJobInstance().getInstanceId();
        this.authorizedInstanceRead(instanceId);
        long l = stepExecutionId;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            l = l;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "authorizedStepExecutionRead", l);
        }
        return l;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Subject runAsSubject() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "runAsSubject", new Object[0]);
        }
        Subject subject = this.batchSecurityHelper.getRunAsSubject();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            subject = subject;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "runAsSubject", subject);
        }
        return subject;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isAdmin(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAdmin", new Object[]{runAsSubject});
        }
        boolean bl = this.isInBatchRole(runAsSubject, ROLES.batchAdmin);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isAdmin", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isGroupAdmin(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isGroupAdmin", new Object[]{runAsSubject});
        }
        boolean bl = this.isInBatchRole(runAsSubject, ROLES.batchGroupAdmin);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isGroupAdmin", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isSubmitter(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isSubmitter", new Object[]{runAsSubject});
        }
        boolean bl = this.isInBatchRole(runAsSubject, ROLES.batchSubmitter);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isSubmitter", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isMonitor(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isMonitor", new Object[]{runAsSubject});
        }
        boolean bl = this.isInBatchRole(runAsSubject, ROLES.batchMonitor);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isMonitor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isGroupMonitor(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isGroupMonitor", new Object[]{runAsSubject});
        }
        boolean bl = this.isInBatchRole(runAsSubject, ROLES.batchGroupMonitor);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isGroupMonitor", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isInBatchRole(Subject runAsSubject, ROLES batchRole) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInBatchRole", new Object[]{runAsSubject, batchRole});
        }
        AuthorizationService authzService = this.getAuthorizationService();
        if (authzService != null) {
            boolean bl = authzService.isAuthorized(BATCH_AUTH_ID, new HashSet<String>(Arrays.asList(batchRole.toString())), runAsSubject);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInBatchRole", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInBatchRole", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean isInAnyBatchRole(Subject runAsSubject) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", new Object[]{runAsSubject});
        }
        AuthorizationService authzService = this.getAuthorizationService();
        if (authzService != null) {
            boolean bl = authzService.isAuthorized(BATCH_AUTH_ID, new HashSet<String>(Arrays.asList(ROLES.batchAdmin.toString(), ROLES.batchSubmitter.toString(), ROLES.batchMonitor.toString(), ROLES.batchGroupAdmin.toString(), ROLES.batchGroupMonitor.toString())), runAsSubject);
            if (logger != null && logger.isLoggable(Level.FINER)) {
                bl = bl;
                logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "isInAnyBatchRole", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getFormattedMessage(String msgId, Object[] fillIns, String defaultMsg) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getFormattedMessage", new Object[]{msgId, fillIns, defaultMsg});
        }
        String string = TraceNLS.getFormattedMessage(WSBatchAuthServiceImpl.class, (String)logger.getResourceBundleName(), (String)msgId, (Object[])fillIns, (String)defaultMsg);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getFormattedMessage", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> getGroupsForSubject() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getGroupsForSubject", new Object[0]);
        }
        Set<String> set = this.getSubjectGroups(this.runAsSubject());
        if (logger != null && logger.isLoggable(Level.FINER)) {
            set = set;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "getGroupsForSubject", set);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public Set<String> normalizeGroupNames(Set<String> groupNames) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "normalizeGroupNames", new Object[]{groupNames});
        }
        Subject subject = this.batchSecurityHelper.getRunAsSubject();
        SubjectHelper sh = new SubjectHelper();
        WSCredential cred = sh.getWSCredential(subject);
        String realmName = null;
        Iterator<String> it = groupNames.iterator();
        HashSet<String> longGrpNames = new HashSet<String>();
        UserRegistry ur = null;
        try {
            realmName = sh.getRealm(subject);
            ur = RegistryHelper.getUserRegistry((String)realmName);
        }
        catch (WSSecurityException wSSecurityException) {
            void wsecEx;
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", (String)"598", (Object)this, (Object[])new Object[]{groupNames});
            throw new RuntimeException((Throwable)wsecEx);
        }
        catch (Exception wsecEx) {
            void e;
            FFDCFilter.processException((Throwable)wsecEx, (String)"com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", (String)"600", (Object)this, (Object[])new Object[]{groupNames});
            throw new RuntimeException((Throwable)e);
        }
        String longGroupName = null;
        while (it.hasNext()) {
            try {
                String currName = it.next();
                longGroupName = null;
                if (ur.isValidGroup(currName)) {
                    longGroupName = AccessIdUtil.createAccessId((String)"group", (String)realmName, (String)ur.getUniqueGroupId(currName));
                    longGrpNames.add(longGroupName);
                    continue;
                }
                JoblogUtil.logToJobLogAndTraceOnly((Level)Level.FINE, (String)"JOB_GROUP_NAME_NOT_VALID", (Object[])new Object[]{currName}, (Logger)logger);
            }
            catch (EntryNotFoundException currName) {
                void enfEx;
                FFDCFilter.processException((Throwable)currName, (String)"com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", (String)"619", (Object)this, (Object[])new Object[]{groupNames});
                throw new RuntimeException((Throwable)enfEx);
            }
            catch (CustomRegistryException enfEx) {
                void crEx;
                FFDCFilter.processException((Throwable)enfEx, (String)"com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", (String)"621", (Object)this, (Object[])new Object[]{groupNames});
                throw new RuntimeException((Throwable)crEx);
            }
            catch (RemoteException crEx) {
                void re;
                FFDCFilter.processException((Throwable)crEx, (String)"com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", (String)"623", (Object)this, (Object[])new Object[]{groupNames});
                throw new RuntimeException((Throwable)re);
            }
        }
        HashSet<String> hashSet = longGrpNames;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            logger.exiting("com.ibm.ws.jbatch.security.impl.WSBatchAuthServiceImpl", "normalizeGroupNames", hashSet);
        }
        return hashSet;
    }
}

