/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.JwtBuilder;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.utils.OAuthClientHttpUtil;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.ws.webcontainer.internalRuntimeExport.srt.IPrivateRequestAttributes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OAuthClientUtil {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(OAuthClientUtil.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    private final List<NameValuePair> commonHeaders = new ArrayList<NameValuePair>();
    private final List<NameValuePair> commonPostHeaders = new ArrayList<NameValuePair>();
    public static final String ERROR = "error";
    public static final String ERROR_DESCRIPTION = "error_description";
    OAuthClientHttpUtil httpUtil = null;

    public OAuthClientUtil() {
        this.commonHeaders.add((NameValuePair)new BasicNameValuePair("Accept", "application/json"));
        this.commonPostHeaders.add((NameValuePair)new BasicNameValuePair("Accept", "application/json"));
        this.commonPostHeaders.add((NameValuePair)new BasicNameValuePair("Content-Type", "application/x-www-form-urlencoded"));
        this.init(OAuthClientHttpUtil.getInstance());
    }

    void init(OAuthClientHttpUtil httpUtil) {
        this.httpUtil = httpUtil;
    }

    final List<NameValuePair> getCommonHeaders() {
        return this.commonHeaders;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getTokensFromAuthzCode(String tokenEndpoint, String clientId, @Sensitive String clientSecret, String redirectUri, String code, String grantType, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, String authMethod, String resources, boolean useJvmProps) throws SocialLoginException {
        Map tokens;
        Map<String, Object> postResponseMap;
        String tokenResponse;
        if (tokenEndpoint == null || tokenEndpoint.isEmpty()) {
            throw new SocialLoginException("TOKEN_ENDPOINT_NULL_OR_EMPTY", null, new Object[0]);
        }
        SocialUtil.validateEndpointWithQuery(tokenEndpoint);
        if (clientId == null || clientId.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"OUTGOING_REQUEST_MISSING_PARAMETER", (Object[])new Object[]{tokenEndpoint, "client_id"});
            clientId = "";
        }
        if (clientSecret == null || clientSecret.isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"OUTGOING_REQUEST_MISSING_PARAMETER", (Object[])new Object[]{tokenEndpoint, "client_secret"});
            clientSecret = "";
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (grantType != null) {
            params.add((NameValuePair)new BasicNameValuePair("grant_type", grantType));
        }
        if (resources != null) {
            params.add((NameValuePair)new BasicNameValuePair("resource", resources));
        }
        if (redirectUri != null) {
            params.add((NameValuePair)new BasicNameValuePair("redirect_uri", redirectUri));
        }
        if (code != null) {
            params.add((NameValuePair)new BasicNameValuePair("code", code));
        }
        if (authMethod != null && authMethod.equals("client_secret_post")) {
            params.add((NameValuePair)new BasicNameValuePair("client_id", clientId));
            params.add((NameValuePair)new BasicNameValuePair("client_secret", clientSecret));
        }
        if ((tokenResponse = this.httpUtil.extractTokensFromResponse(postResponseMap = this.httpUtil.postToEndpoint(tokenEndpoint, params, clientId, clientSecret, null, sslSocketFactory, this.commonPostHeaders, isHostnameVerification, authMethod, useJvmProps))) == null) {
            Tr.warning((TraceComponent)tc, (String)"POST_RESPONSE_NULL", (Object[])new Object[]{tokenEndpoint, postResponseMap});
            return new HashMap<String, Object>();
        }
        try {
            tokens = JsonUtil.parseJson((String)tokenResponse);
        }
        catch (JoseException joseException) {
            void e;
            Object[] objectArray = new Object[11];
            objectArray[0] = tokenEndpoint;
            objectArray[1] = clientId;
            objectArray[2] = "<sensitive java.lang.String>";
            objectArray[3] = redirectUri;
            objectArray[4] = code;
            objectArray[5] = grantType;
            objectArray[6] = sslSocketFactory;
            objectArray[7] = isHostnameVerification;
            objectArray[8] = authMethod;
            objectArray[9] = resources;
            objectArray[10] = useJvmProps;
            FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientUtil", (String)"148", (Object)this, (Object[])objectArray);
            Tr.warning((TraceComponent)tc, (String)"ENDPOINT_RESPONSE_NOT_JSON", (Object[])new Object[]{tokenEndpoint, e.getMessage(), tokenResponse});
            return new HashMap<String, Object>();
        }
        return tokens;
    }

    public Map<String, Object> checkToken(String tokenEndpoint, String clientId, @Sensitive String clientSecret, @Sensitive String accessToken, boolean isHostnameVerification, String authMethod, SSLSocketFactory sslSocketFactory, boolean useJvmProps) throws SocialLoginException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (accessToken != null) {
            params.add((NameValuePair)new BasicNameValuePair("token", accessToken));
        }
        if (authMethod != null && authMethod.equals("client_secret_post")) {
            params.add((NameValuePair)new BasicNameValuePair("client_id", clientId));
            params.add((NameValuePair)new BasicNameValuePair("client_secret", clientSecret));
        }
        Map<String, Object> postResponseMap = this.postToCheckTokenEndpoint(tokenEndpoint, params, clientId, clientSecret, isHostnameVerification, authMethod, sslSocketFactory, useJvmProps);
        return postResponseMap;
    }

    public Map<String, Object> getUserApi(String userApi, @Sensitive String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean needsSpecialHeader, boolean useJvmProps) throws Exception {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (accessToken != null && this.isAccessTokenQueryParameterAccepted(userApi)) {
            params.add((NameValuePair)new BasicNameValuePair("access_token", accessToken));
        }
        Map<String, Object> getResponseMap = this.getFromUserApiEndpoint(userApi, params, accessToken, sslSocketFactory, isHostnameVerification, needsSpecialHeader, useJvmProps);
        return getResponseMap;
    }

    public boolean isAccessTokenQueryParameterAccepted(String userApi) {
        if (userApi != null) {
            if (userApi.contains("https://api.linkedin.com")) {
                return false;
            }
            if (userApi.contains("https://api.github.com")) {
                return false;
            }
        }
        return true;
    }

    public String getUserApiResponse(String userApi, @Sensitive String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean needsSpecialHeader, boolean useJvmProps) throws Exception {
        Map<String, Object> getResponseMap = this.getUserApi(userApi, accessToken, sslSocketFactory, isHostnameVerification, needsSpecialHeader, useJvmProps);
        return this.getJsonStringResponse(getResponseMap, userApi);
    }

    public JwtToken getUserApiAsJwtToken(String userApi, @Sensitive String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, SocialLoginConfig clientConfig) throws Exception {
        Map<String, Object> getResponseMap = this.getUserApi(userApi, accessToken, sslSocketFactory, isHostnameVerification, clientConfig.getUserApiNeedsSpecialHeader(), clientConfig.getUseSystemPropertiesForHttpClientConnections());
        String jsonString = this.getJsonStringResponse(getResponseMap, userApi);
        if (jsonString != null) {
            return this.createJwtTokenFromJson(jsonString, clientConfig.getJwtRef());
        }
        throw new SocialLoginException("USERAPI_NULL_RESP_STR", null, new Object[]{userApi});
    }

    /*
     * WARNING - void declaration
     */
    protected String getJsonStringResponse(Map<String, Object> responseMap, String userApi) throws SocialLoginException {
        String jresponse = null;
        if (responseMap == null) {
            return null;
        }
        if (responseMap.containsKey("RESPONSEMAP_CODE")) {
            HttpResponse response = (HttpResponse)responseMap.get("RESPONSEMAP_CODE");
            if (this.isErrorResponse(response)) {
                this.handleError(response, userApi);
            } else {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    try {
                        jresponse = EntityUtils.toString((HttpEntity)entity);
                    }
                    catch (ParseException parseException) {
                        void e;
                        FFDCFilter.processException((Throwable)parseException, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientUtil", (String)"236", (Object)this, (Object[])new Object[]{responseMap, userApi});
                        throw new SocialLoginException("USERAPI_RESP_PROCESS_ERR", (Exception)e, new Object[]{userApi, e.getLocalizedMessage()});
                    }
                    catch (IOException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientUtil", (String)"238", (Object)this, (Object[])new Object[]{responseMap, userApi});
                        throw new SocialLoginException("USERAPI_RESP_PROCESS_ERR", e, new Object[]{userApi, e.getLocalizedMessage()});
                    }
                }
            }
        }
        return jresponse;
    }

    /*
     * WARNING - void declaration
     */
    void handleError(HttpResponse response, String userApi) throws SocialLoginException {
        int status_code;
        String jresponse = null;
        String err = null;
        String err_desc = null;
        if (response == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"HttpResponse is null so nothing to do", (Object[])new Object[0]);
            }
            return;
        }
        try {
            HttpEntity entity;
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                status_code = 403;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("StatusLine object not returned from response, so defaulting to status code of " + status_code), (Object[])new Object[0]);
                }
            } else {
                status_code = statusLine.getStatusCode();
            }
            if ((jresponse = EntityUtils.toString((HttpEntity)(entity = response.getEntity()))) == null || jresponse.isEmpty()) {
                err_desc = this.getErrorDescriptionFromAuthenticateHeader(response);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"error response from the user api ep: ", (Object[])new Object[]{jresponse});
                }
                Map errorjsonmap = JsonUtil.parseJson((String)jresponse);
                err = (String)errorjsonmap.get(ERROR);
                err_desc = (String)errorjsonmap.get(ERROR_DESCRIPTION);
                if (err == null && err_desc == null && jresponse != null) {
                    err = jresponse;
                }
            }
        }
        catch (Exception statusLine) {
            void e;
            FFDCFilter.processException((Throwable)statusLine, (String)"com.ibm.ws.security.social.internal.utils.OAuthClientUtil", (String)"289", (Object)this, (Object[])new Object[]{response, userApi});
            throw new SocialLoginException("USERAPI_ERROR_RESPONSE", (Exception)e, new Object[]{userApi, e.getLocalizedMessage()});
        }
        throw new SocialLoginException("USERAPI_RESP_INVALID_STATUS", null, new Object[]{userApi, status_code, err, err_desc});
    }

    String getErrorDescriptionFromAuthenticateHeader(HttpResponse response) {
        Header header = response.getFirstHeader("WWW-Authenticate");
        String jresponse = header == null ? null : header.getValue();
        return this.extractErrorDescription(jresponse);
    }

    protected String extractErrorDescription(String response) {
        if (response == null) {
            return null;
        }
        String regexHeader = "(?:.*[^a-zA-Z0-9])?error_description=(.*)";
        Pattern pattern = Pattern.compile(regexHeader);
        Matcher m = pattern.matcher(response);
        if (!m.matches()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response did not appear to contain an error description formatted as expected. Returning response as-is", (Object[])new Object[0]);
            }
            return response;
        }
        String description = null;
        if (m.groupCount() > 0 && (description = m.group(1)) != null && description.length() > 1 && description.charAt(0) == '\"' && description.charAt(description.length() - 1) == '\"') {
            description = description.substring(1, description.length() - 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted description: [" + description + "]"), (Object[])new Object[0]);
        }
        return description;
    }

    boolean isErrorResponse(HttpResponse response) {
        StatusLine status = response.getStatusLine();
        return status == null || status.getStatusCode() != 200;
    }

    public JwtToken getJwtTokenFromJson(String jsonString, SocialLoginConfig clientConfig) throws Exception {
        return this.createJwtTokenFromJson(jsonString, clientConfig.getJwtRef());
    }

    protected JwtToken createJwtTokenFromJson(String jsonString, String jwtRef) throws Exception {
        JwtBuilder jwtBuilder = JwtBuilder.create((String)jwtRef).claimFrom(jsonString);
        return jwtBuilder.buildJwt();
    }

    public JwtToken createJwtToken(String jsonString) throws Exception {
        JwtContext jwtCtx = this.parseJwtWithoutValidation(jsonString, 180L);
        Map claims = jwtCtx.getJwtClaims().getClaimsMap();
        JwtBuilder jwtBuilder = JwtBuilder.create().claim(claims);
        return jwtBuilder.buildJwt();
    }

    protected JwtContext parseJwtWithoutValidation(String jwtString, long clockSkewInMilliseconds) throws Exception {
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setSkipAllValidators();
        builder.setDisableRequireSignature();
        builder.setSkipSignatureVerification();
        builder.setAllowedClockSkewInSeconds((int)(clockSkewInMilliseconds / 1000L));
        JwtConsumer firstPassJwtConsumer = builder.build();
        JwtContext jwtContext = firstPassJwtConsumer.process(jwtString);
        return jwtContext;
    }

    Map<String, Object> postToTokenEndpoint(String tokenEnpoint, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws Exception {
        return this.httpUtil.postToEndpoint(tokenEnpoint, params, baUsername, baPassword, null, sslSocketFactory, this.commonHeaders, isHostnameVerification, authMethod, useJvmProps);
    }

    Map<String, Object> getToTokenEndpoint(String tokenEnpoint, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, String authMethod, boolean useJvmProps) throws Exception {
        return this.httpUtil.getToEndpoint(tokenEnpoint, params, baUsername, baPassword, null, sslSocketFactory, this.commonHeaders, isHostnameVerification, authMethod, useJvmProps);
    }

    Map<String, Object> postToCheckTokenEndpoint(String tokenEnpoint, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, boolean isHostnameVerification, String authMethod, SSLSocketFactory sslSocketFactory, boolean useJvmProps) throws SocialLoginException {
        return this.httpUtil.postToIntrospectEndpoint(tokenEnpoint, params, baUsername, baPassword, null, sslSocketFactory, this.commonHeaders, isHostnameVerification, authMethod, useJvmProps);
    }

    Map<String, Object> getFromUserApiEndpoint(String userApiEndpoint, @Sensitive List<NameValuePair> params, @Sensitive String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean needsSpecialHeader, boolean useJvmProps) throws ClientProtocolException, IOException, SocialLoginException {
        return this.getFromEndpoint(userApiEndpoint, params, null, null, accessToken, sslSocketFactory, isHostnameVerification, needsSpecialHeader, useJvmProps);
    }

    Map<String, Object> getFromEndpoint(String url, @Sensitive List<NameValuePair> params, String baUsername, @Sensitive String baPassword, @Sensitive String accessToken, SSLSocketFactory sslSocketFactory, boolean isHostnameVerification, boolean needsSpecialHeader, boolean useJvmProps) throws ClientProtocolException, IOException, SocialLoginException {
        SocialUtil.validateEndpointWithQuery(url);
        String query = null;
        if (params == null) {
            params = new ArrayList<NameValuePair>();
        }
        if ((query = URLEncodedUtils.format(params, (String)"UTF-8")) != null && !query.isEmpty()) {
            if (!url.endsWith("?")) {
                url = url.contains("?") ? url + "&" : url + "?";
            }
            url = url + query;
        }
        HttpGet request = new HttpGet(url);
        for (NameValuePair nameValuePair : this.commonHeaders) {
            request.addHeader(nameValuePair.getName(), nameValuePair.getValue());
        }
        if (needsSpecialHeader) {
            request.addHeader("x-li-format", "json");
            request.addHeader("Authorization", "Bearer " + accessToken);
        }
        HttpClient httpClient = baUsername != null ? this.httpUtil.createHTTPClient(sslSocketFactory, url, isHostnameVerification, baUsername, baPassword, useJvmProps) : this.httpUtil.createHTTPClient(sslSocketFactory, url, isHostnameVerification, useJvmProps);
        HttpResponse responseCode = httpClient.execute((HttpUriRequest)request);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("RESPONSEMAP_CODE", responseCode);
        result.put("RESPONSEMAP_METHOD", request);
        return result;
    }

    protected Integer getRedirectPortFromRequest(HttpServletRequest req) {
        HttpServletRequest sr = OAuthClientUtil.getWrappedServletRequestObject(req);
        if (sr instanceof IPrivateRequestAttributes) {
            return (Integer)((IPrivateRequestAttributes)sr).getPrivateAttribute("SecurityRedirectPort");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRedirectUrl called for non-IPrivateRequestAttributes object", (Object[])new Object[]{req});
        }
        return null;
    }

    private static HttpServletRequest getWrappedServletRequestObject(HttpServletRequest sr) {
        if (sr instanceof HttpServletRequestWrapper) {
            HttpServletRequestWrapper w = (HttpServletRequestWrapper)sr;
            sr = (HttpServletRequest)w.getRequest();
            while (sr instanceof HttpServletRequestWrapper) {
                sr = (HttpServletRequest)((HttpServletRequestWrapper)sr).getRequest();
            }
        }
        return sr;
    }
}

