/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.config.CommonConfigUtils;
import com.ibm.ws.security.social.SocialLoginWebappConfig;
import com.ibm.ws.security.social.error.SocialLoginException;
import com.ibm.ws.security.social.internal.Oauth2LoginConfigImpl;
import com.ibm.ws.security.social.internal.utils.SocialUtil;
import com.ibm.wsspi.wab.configure.WABConfiguration;
import java.util.Map;
import java.util.regex.Pattern;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPid={"com.ibm.ws.security.social.webapp"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={SocialLoginWebappConfig.class, WABConfiguration.class}, immediate=true, property={"service.vendor=IBM"})
public class SocialLoginWebappConfigImpl
implements SocialLoginWebappConfig {
    private static final TraceComponent tc = Tr.register(SocialLoginWebappConfigImpl.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    public static final String KEY_SOCIAL_MEDIA_SELECTION_PAGE_URL = "socialMediaSelectionPageUrl";
    protected String socialMediaSelectionPageUrl = null;
    public static final String KEY_ENABLE_LOCAL_AUTHENTICATION = "enableLocalAuthentication";
    protected boolean enableLocalAuthentication = false;
    private final CommonConfigUtils configUtils = new CommonConfigUtils();
    static final long serialVersionUID = 7809008795496933119L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        this.initProps(config);
    }

    @Modified
    protected void modified(Map<String, Object> config) {
        this.initProps(config);
    }

    @Deactivate
    protected void deactivate() {
    }

    public void initProps(Map<String, Object> props) {
        String contextPath = this.configUtils.getConfigAttribute(props, "contextPath");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Context Path=" + contextPath), (Object[])new Object[0]);
        }
        this.validateAndSetContextPath(contextPath);
        this.validateAndSetSelectionPageUrl(this.configUtils.getConfigAttribute(props, KEY_SOCIAL_MEDIA_SELECTION_PAGE_URL));
        this.enableLocalAuthentication = this.configUtils.getBooleanConfigAttribute(props, KEY_ENABLE_LOCAL_AUTHENTICATION, this.enableLocalAuthentication);
    }

    @Override
    public String getSocialMediaSelectionPageUrl() {
        return this.socialMediaSelectionPageUrl;
    }

    @Override
    public boolean isLocalAuthenticationEnabled() {
        return this.enableLocalAuthentication;
    }

    void validateAndSetContextPath(String contextPath) {
        if (this.isValidUriPath(contextPath)) {
            Oauth2LoginConfigImpl.setContextRoot(contextPath);
        } else {
            Tr.error((TraceComponent)tc, (String)"INVALID_CONTEXT_PATH_CHARS", (Object[])new Object[]{contextPath});
        }
    }

    void validateAndSetSelectionPageUrl(String selectionPageUrl) {
        if (this.isSelectionPageUrlNullOrEmpty(selectionPageUrl)) {
            this.socialMediaSelectionPageUrl = null;
        } else {
            this.validateAndSetNonEmptySelectionPageUrl(selectionPageUrl);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("socialMediaSelectionPageUrl=" + this.socialMediaSelectionPageUrl), (Object[])new Object[0]);
        }
    }

    boolean isSelectionPageUrlNullOrEmpty(String selectionPageUrl) {
        if (selectionPageUrl == null || selectionPageUrl.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"socialMediaSelectionPageUrl is null or empty", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    @FFDCIgnore(value={SocialLoginException.class})
    void validateAndSetNonEmptySelectionPageUrl(String selectionPageUrl) {
        if (!this.isHttpOrRelativeUrl(selectionPageUrl)) {
            Tr.error((TraceComponent)tc, (String)"SELECTION_PAGE_URL_NOT_HTTP", (Object[])new Object[]{selectionPageUrl});
            this.socialMediaSelectionPageUrl = null;
            return;
        }
        try {
            SocialUtil.validateEndpointFormat(selectionPageUrl, false);
            this.socialMediaSelectionPageUrl = selectionPageUrl;
        }
        catch (SocialLoginException e) {
            Tr.error((TraceComponent)tc, (String)"SELECTION_PAGE_URL_NOT_VALID", (Object[])new Object[]{selectionPageUrl, e.getMessage()});
            this.socialMediaSelectionPageUrl = null;
        }
    }

    boolean isHttpOrRelativeUrl(String selectionPageUrl) {
        if (selectionPageUrl == null) {
            return false;
        }
        String loweredUrl = selectionPageUrl.toLowerCase();
        if (loweredUrl.startsWith("http://") || loweredUrl.startsWith("https://")) {
            return true;
        }
        if (selectionPageUrl.contains("://")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Provided URL does not start with http or https, but appears to contain a protocol", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    boolean isValidUriPath(String input) {
        if (input == null) {
            return false;
        }
        return Pattern.matches("[a-zA-Z0-9._~%!$&'()*+,;=:@/-]*", input);
    }
}

