/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejbcontainer.jitdeploy;

import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.ejs.container.EJBMethodInfoImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.jitdeploy.ClassDefiner;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBHomeImpl;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBUtils;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBWrapper;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBWrapperProxy;
import com.ibm.ws.ejbcontainer.jitdeploy.EJBWrapperType;
import com.ibm.ws.ejbcontainer.jitdeploy.JIT_Tie;
import com.ibm.ws.ejbcontainer.jitdeploy.RMItoIDL;
import com.ibm.ws.ejbcontainer.jitdeploy.WSEJBProxy;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

public final class JITDeploy {
    private static final String CLASS_NAME = JITDeploy.class.getName();
    private static final TraceComponent tc = Tr.register(JITDeploy.class, (String)"JITDeploy", (String)"com.ibm.ejs.container.container");

    public static Class<?> getComponentInterface(Class<?> homeInterface, String beanName) throws EJBConfigurationException {
        return EJBHomeImpl.getComponentInterface(homeInterface, beanName);
    }

    public static void validateInterfaceBasics(Class<?> remoteHome, Class<?> remoteInterface, Class<?> localHome, Class<?> localInterface, Class<?> webServiceEndpointInterface, Class<?>[] remoteBusinessInterfaces, Class<?>[] localBusinessInterfaces, Class<?> ejbClass, String beanName, int beanType) throws EJBConfigurationException {
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("validateInterfaceBasics : " + beanName), (Object[])new Object[0]);
        }
        if (remoteHome != null) {
            EJBHomeImpl.validateInterfaceBasics(remoteHome, remoteInterface, EJBWrapperType.REMOTE_HOME, beanName, beanType);
        }
        if (remoteInterface != null) {
            EJBWrapper.validateInterfaceBasics(remoteInterface, EJBWrapperType.REMOTE, beanName);
            if (remoteHome == null) {
                Tr.error((TraceComponent)tc, (String)"JIT_MISSING_REMOTE_HOME_CNTR5001E", (Object[])new Object[]{beanName, remoteInterface.getName()});
                throw new EJBConfigurationException("An EJB remote component interface requires a remote-home interface : " + remoteInterface.getName() + " on EJB " + beanName);
            }
        }
        if (localHome != null) {
            EJBHomeImpl.validateInterfaceBasics(localHome, localInterface, EJBWrapperType.LOCAL_HOME, beanName, beanType);
        }
        if (localInterface != null && beanType != 7) {
            EJBWrapper.validateInterfaceBasics(localInterface, EJBWrapperType.LOCAL, beanName);
            if (localHome == null) {
                Tr.error((TraceComponent)tc, (String)"JIT_MISSING_LOCAL_HOME_CNTR5002E", (Object[])new Object[]{beanName, localInterface.getName()});
                throw new EJBConfigurationException("An EJB local component interface requires a local-home interface : " + localInterface.getName() + " on EJB " + beanName);
            }
        }
        if (webServiceEndpointInterface != null) {
            EJBWrapper.validateInterfaceBasics(webServiceEndpointInterface, EJBWrapperType.SERVICE_ENDPOINT, beanName);
        }
        if (remoteBusinessInterfaces != null) {
            for (Class<?> remote : remoteBusinessInterfaces) {
                EJBWrapper.validateInterfaceBasics(remote, EJBWrapperType.BUSINESS_REMOTE, beanName);
            }
        }
        if (localBusinessInterfaces != null) {
            EJBWrapperType wrapperType = null;
            for (Class<?> local : localBusinessInterfaces) {
                wrapperType = local == ejbClass ? EJBWrapperType.LOCAL_BEAN : EJBWrapperType.BUSINESS_LOCAL;
                EJBWrapper.validateInterfaceBasics(local, wrapperType, beanName);
            }
        }
        if (ejbClass != null) {
            EJBUtils.validateEjbClass(ejbClass, beanName, beanType);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("validateInterfaceBasics : " + beanName));
        }
    }

    public static Class<?> generateEJBWrapper(ClassLoader classLoader, String wrapperClassName, Class<?>[] wrapperInterfaces, EJBWrapperType wrapperType, Method[] allMethods, EJBMethodInfoImpl[] methodInfos, String ejbClassName, String beanName, ClassDefiner classDefiner) throws ClassNotFoundException, EJBConfigurationException {
        Class<?> rtnClass = null;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateEJBWrapper: " + wrapperClassName + " : " + beanName), (Object[])new Object[0]);
        }
        try {
            byte[] classbytes = EJBWrapper.generateClassBytes(wrapperClassName, wrapperInterfaces, wrapperType, allMethods, methodInfos, ejbClassName, beanName);
            rtnClass = classDefiner.findLoadedOrDefineClass(classLoader, wrapperClassName, classbytes);
        }
        catch (EJBConfigurationException ejbex) {
            FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generateEJBWrapper"), (String)"110");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generateEJBWrapper failed: " + ejbex.getMessage()));
            }
            throw ejbex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generateEJBWrapper"), (String)"119");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generateEJBWrapper failed: " + ex.getMessage()));
            }
            throw new ClassNotFoundException(wrapperClassName + " : " + ex.getMessage(), ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateEJBWrapper: " + rtnClass));
        }
        return rtnClass;
    }

    public static Class<?> generateEJBWrapperProxy(ClassLoader classLoader, String proxyClassName, Class<?>[] wrapperInterfaces, Method[] methods, ClassDefiner classDefiner) throws ClassNotFoundException {
        Class<?> rtnClass;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateEJBWrapperProxy: " + proxyClassName), (Object[])new Object[0]);
        }
        if ((rtnClass = classDefiner.findLoadedClass(classLoader, proxyClassName)) == null) {
            try {
                byte[] classbytes = EJBWrapperProxy.generateClassBytes(proxyClassName, wrapperInterfaces, methods);
                rtnClass = classDefiner.findLoadedOrDefineClass(classLoader, proxyClassName, classbytes);
            }
            catch (Throwable ex) {
                FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generateEJBWrapperProxy"), (String)"525");
                if (isTraceOn && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)("generateEJBWrapperProxy failed: " + ex.getMessage()));
                }
                throw new ClassNotFoundException(proxyClassName + " : " + ex.getMessage(), ex);
            }
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateEJBWrapperProxy: " + rtnClass));
        }
        return rtnClass;
    }

    public static Class<?> generate_Tie(ClassLoader classLoader, String remoteClassName, Class<?> remoteInterface, String beanName, ClassDefiner classDefiner, int rmicCompatible, boolean portableServer) throws ClassNotFoundException, EJBConfigurationException {
        Class<?> rtnClass = null;
        String tieClassName = JIT_Tie.getTieClassName(remoteClassName);
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generate_Tie: " + tieClassName + " : " + beanName), (Object[])new Object[0]);
        }
        ArrayList<Method> compatibilityMethods = new ArrayList<Method>();
        Method[] remoteMethods = remoteInterface.getMethods();
        String[] idlNames = RMItoIDL.getIdlMethodNames(remoteMethods, remoteInterface, compatibilityMethods);
        if (compatibilityMethods.size() > 0) {
            int length = remoteMethods.length;
            Method[] allMethods = new Method[idlNames.length];
            System.arraycopy(remoteMethods, 0, allMethods, 0, length);
            for (Method extraMethod : compatibilityMethods) {
                allMethods[length++] = extraMethod;
            }
            remoteMethods = allMethods;
        }
        try {
            byte[] classbytes = JIT_Tie.generateClassBytes(tieClassName, remoteClassName, remoteInterface, remoteMethods, idlNames, rmicCompatible, portableServer);
            rtnClass = classDefiner.findLoadedOrDefineClass(classLoader, tieClassName, classbytes);
        }
        catch (EJBConfigurationException ejbex) {
            FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generate_Tie"), (String)"110");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generate_Tie failed: " + ejbex.getMessage()));
            }
            throw ejbex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generate_Tie"), (String)"119");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generate_Tie failed: " + ex.getMessage()));
            }
            throw new ClassNotFoundException(tieClassName + " : " + ex.getMessage(), ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generate_Tie: " + rtnClass));
        }
        return rtnClass;
    }

    public static final Class<?> generateEJBHomeImplClass(ClassLoader classLoader, String homeClassName, Class<?> remoteInterface, Class<?> localInterface, Class<?> ejbClass, Class<?> pkeyClass, HashMap<String, String> initMethods, String beanName, int beanType, ClassDefiner classDefiner) throws ClassNotFoundException, EJBConfigurationException {
        Class<?> rtnClass = null;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateEJBHomeImplClass: " + homeClassName + " : " + beanName), (Object[])new Object[0]);
        }
        try {
            byte[] classbytes = EJBHomeImpl.generateClassBytes(homeClassName, remoteInterface, localInterface, ejbClass, pkeyClass, initMethods, beanName, beanType);
            rtnClass = classDefiner.findLoadedOrDefineClass(classLoader, homeClassName, classbytes);
        }
        catch (EJBConfigurationException ejbex) {
            FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generateEJBHomeImplClass"), (String)"476");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generateEJBHomeImplClass failed: " + ejbex.getMessage()));
            }
            throw ejbex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generateEJBHomeImplClass"), (String)"195");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generateEJBHomeImplClass failed: " + ex.getMessage()));
            }
            throw new ClassNotFoundException(homeClassName + " : " + ex.getMessage(), ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateEJBHomeImplClass: " + rtnClass));
        }
        return rtnClass;
    }

    public static Class<?> generateMDBProxy(ClassLoader classLoader, String proxyClassName, Class<?>[] proxyInterfaceAndClass, EJBWrapperType wrapperType, String ejbClassName, Method[] allMethods, EJBMethodInfoImpl[] methodInfos, String beanName, ClassDefiner classDefiner) throws ClassNotFoundException, EJBConfigurationException {
        Class<?> rtnClass = null;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateMDBProxy: " + proxyClassName), (Object[])new Object[0]);
        }
        try {
            byte[] classbytes = EJBWrapper.generateClassBytes(proxyClassName, proxyInterfaceAndClass, wrapperType, allMethods, methodInfos, ejbClassName, beanName);
            rtnClass = classDefiner.findLoadedOrDefineClass(classLoader, proxyClassName, classbytes);
        }
        catch (EJBConfigurationException ejbex) {
            FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generateMDBProxy"), (String)"505");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generateMDBProxy failed: " + ejbex.getMessage()));
            }
            throw ejbex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generateMDBProxy"), (String)"513");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generateMDBProxy failed: " + ex.getMessage()));
            }
            throw new ClassNotFoundException(proxyClassName + " : " + ex.getMessage(), ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateMDBProxy: " + rtnClass));
        }
        return rtnClass;
    }

    public static Class<?> generateWSEJBProxy(ClassLoader classLoader, String proxyClassName, Class<?> proxyInterface, Method[] proxyMethods, EJBMethodInfoImpl[] methodInfos, String ejbClassName, String beanName, ClassDefiner classDefiner) throws ClassNotFoundException, EJBConfigurationException {
        Class<?> rtnClass = null;
        boolean isTraceOn = TraceComponent.isAnyTracingEnabled();
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateWSEJBProxy: " + proxyClassName + " : " + beanName), (Object[])new Object[0]);
        }
        try {
            byte[] classbytes = WSEJBProxy.generateClassBytes(proxyClassName, proxyInterface, proxyMethods, methodInfos, ejbClassName, beanName);
            rtnClass = classDefiner.findLoadedOrDefineClass(classLoader, proxyClassName, classbytes);
        }
        catch (EJBConfigurationException ejbex) {
            FFDCFilter.processException((Throwable)ejbex, (String)(CLASS_NAME + ".generateWSEJBProxy"), (String)"536");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generateWSEJBProxy failed: " + ejbex.getMessage()));
            }
            throw ejbex;
        }
        catch (Throwable ex) {
            FFDCFilter.processException((Throwable)ex, (String)(CLASS_NAME + ".generateWSEJBProxy"), (String)"545");
            if (isTraceOn && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("generateWSEJBProxy failed: " + ex.getMessage()));
            }
            throw new ClassNotFoundException(proxyClassName + " : " + ex.getMessage(), ex);
        }
        if (isTraceOn && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateWSEJBProxy: " + rtnClass));
        }
        return rtnClass;
    }
}

