/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ejb.portable;

import com.ibm.ws.ejb.portable.Constants;
import com.ibm.ws.ejb.portable.HomeHandleImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import javax.rmi.PortableRemoteObject;

public class EJBMetaDataImpl
implements EJBMetaData,
Serializable {
    private static final long serialVersionUID = 4092588565014573628L;
    static final boolean DEBUG_ON = false;
    static final int EYECATCHER_LENGTH = 4;
    static final byte[] EYECATCHER = Constants.EJB_META_DATA_EYE_CATCHER;
    static final short PLATFORM = 1;
    static final short VERSION_ID = 1;
    public static final int STATEFUL_SESSION = 1;
    public static final int STATELESS_SESSION = 2;
    public static final int NON_SESSION_BEAN = 3;
    private transient EJBHome ivEjbHome;
    private transient HomeHandle ivHomeHandle;
    private transient Class<?> ivBeanClass;
    private transient String ivBeanClassName;
    private transient Class<?> ivHomeClass;
    private transient Class<?> ivRemoteClass;
    private transient boolean ivSession;
    private transient boolean ivStatelessSession;
    private transient Class<?> ivPKClass;

    public EJBMetaDataImpl(int beanType, EJBHome ejbHomeStub, Class<?> beanClass, Class<?> homeClass, Class<?> remoteClass, Class<?> primaryKeyClass) {
        this.ivEjbHome = ejbHomeStub;
        this.ivHomeHandle = new HomeHandleImpl(ejbHomeStub);
        this.ivBeanClass = beanClass;
        this.ivBeanClassName = this.ivBeanClass.getName();
        this.ivHomeClass = homeClass;
        this.ivRemoteClass = remoteClass;
        this.ivPKClass = null;
        if (beanType == 1) {
            this.ivSession = true;
            this.ivStatelessSession = false;
        } else if (beanType == 2) {
            this.ivSession = true;
            this.ivStatelessSession = true;
        } else {
            this.ivSession = false;
            this.ivStatelessSession = false;
            this.ivPKClass = primaryKeyClass;
        }
    }

    public EJBHome getEJBHome() {
        if (this.ivEjbHome == null && this.ivHomeHandle != null) {
            try {
                EJBHome ejbHomeStub = this.ivHomeHandle.getEJBHome();
                this.ivEjbHome = (EJBHome)PortableRemoteObject.narrow((Object)ejbHomeStub, this.ivHomeClass);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.ivEjbHome;
    }

    public Class<?> getHomeInterfaceClass() {
        return this.ivHomeClass;
    }

    public Class<?> getPrimaryKeyClass() {
        if (this.ivPKClass == null) {
            throw new EJBException("Session beans do not have a primary key class");
        }
        return this.ivPKClass;
    }

    public Class<?> getRemoteInterfaceClass() {
        return this.ivRemoteClass;
    }

    public String getBeanClassName() {
        return this.ivBeanClassName;
    }

    public boolean isSession() {
        return this.ivSession;
    }

    public boolean isStatelessSession() {
        return this.ivStatelessSession;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            in.defaultReadObject();
            byte[] ec = new byte[4];
            int bytesRead = 0;
            for (int offset = 0; offset < 4; offset += bytesRead) {
                bytesRead = in.read(ec, offset, 4 - offset);
                if (bytesRead != -1) continue;
                throw new IOException("end of input stream while reading eye catcher");
            }
            for (int i = 0; i < 4; ++i) {
                if (EYECATCHER[i] == ec[i]) continue;
                String eyeCatcherString = new String(ec);
                throw new IOException("Invalid eye catcher '" + eyeCatcherString + "' in EJBMetaData input stream");
            }
            in.readShort();
            in.readShort();
            this.ivSession = in.readBoolean();
            this.ivStatelessSession = in.readBoolean();
            ClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            this.ivBeanClassName = in.readUTF();
            this.ivHomeClass = loader.loadClass(in.readUTF());
            this.ivRemoteClass = loader.loadClass(in.readUTF());
            if (!this.ivSession) {
                this.ivPKClass = loader.loadClass(in.readUTF());
            }
            this.ivHomeHandle = (HomeHandle)in.readObject();
        }
        catch (IOException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.write(EYECATCHER);
        out.writeShort(1);
        out.writeShort(1);
        out.writeBoolean(this.ivSession);
        out.writeBoolean(this.ivStatelessSession);
        out.writeUTF(this.ivBeanClassName);
        out.writeUTF(this.ivHomeClass.getName());
        out.writeUTF(this.ivRemoteClass.getName());
        if (!this.ivSession) {
            out.writeUTF(this.ivPKClass.getName());
        }
        out.writeObject(this.ivHomeHandle);
    }
}

