/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;

class ExternalizedBeanId
extends BeanId
implements Externalizable {
    private static final long serialVersionUID = -7733353009012455282L;
    private static final TraceComponent tc = Tr.register(ExternalizedBeanId.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final byte IF_HOME = 0;
    private static final byte IF_REMOTE = 1;
    private static final short EXTERNAL_MAGIC = -21332;
    private static final short MAJOR_VERSION = 1;
    private static final short MINOR_VERSION = 1;

    public ExternalizedBeanId() {
        this.pkey = null;
        this._isHome = false;
    }

    public ExternalizedBeanId(Serializable pkey, J2EEName j2eeName, boolean isHome) {
        this.pkey = pkey;
        this._isHome = isHome;
        this.j2eeName = j2eeName;
        this.hashValue = ExternalizedBeanId.computeHashValue(j2eeName, pkey, this._isHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readExternal", (Object[])new Object[0]);
        }
        try {
            short magic = in.readShort();
            short majorVersion = in.readShort();
            short minorVersion = in.readShort();
            if (magic != -21332) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Magic Number absent, trying default Java deserialization", (Object[])new Object[0]);
                }
                throw new IOException("Bean ID externalized stream format error");
            }
            if (majorVersion != 1 || minorVersion != 1) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"BeanID Version mismatch", (Object[])new Object[]{new Short(majorVersion), new Short(minorVersion)});
                }
                throw new IOException("BeanID version mismatch");
            }
            byte ifType = in.readByte();
            this._isHome = ifType == 0;
            byte[] j2eeNameBytes = this.readExternalJ2EEName(in);
            this.pkey = this.readExternalPKey(in, j2eeNameBytes);
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readExternal");
            }
        }
    }

    private byte[] readExternalJ2EEName(ObjectInput in) throws IOException {
        int nameLength = in.readInt();
        byte[] name = new byte[nameLength];
        int bytesRead = 0;
        for (int offset = 0; offset < nameLength; offset += bytesRead) {
            bytesRead = in.read(name, offset, nameLength - offset);
            if (bytesRead != -1) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readExternalJ2EEName encountered end of stream", (Object[])new Object[0]);
            }
            throw new IOException("end of input stream while reading J2EEName");
        }
        return name;
    }

    private Serializable readExternalPKey(ObjectInput in, byte[] j2eeNameBytes) throws IOException, ClassNotFoundException {
        int pkeyLength = in.readInt();
        byte[] pkeyBytes = new byte[pkeyLength];
        int bytesRead = 0;
        for (int offset = 0; offset < pkeyLength; offset += bytesRead) {
            bytesRead = in.read(pkeyBytes, offset, pkeyLength - offset);
            if (bytesRead != -1) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"readExternalKey encountered end of stream", (Object[])new Object[0]);
            }
            throw new IOException("end of input stream while reading primary key");
        }
        EJSContainer container2 = EJSContainer.getDefaultContainer();
        J2EEName j2eename = container2.getJ2EENameFactory().create(j2eeNameBytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(pkeyBytes);
        ClassLoader loader = EJSContainer.getClassLoader(j2eename);
        ObjectInputStream pkeyStream = container2.getEJBRuntime().createObjectInputStream(bais, loader);
        Serializable key = (Serializable)pkeyStream.readObject();
        return key;
    }

    @Override
    public String toString() {
        return "BeanId(" + this.j2eeName + ", " + this.pkey + ")";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"writeExternal", (Object[])new Object[0]);
        }
        try {
            out.writeShort(-21332);
            out.writeShort(1);
            out.writeShort(1);
            if (this._isHome) {
                out.writeByte(0);
            } else {
                out.writeByte(1);
            }
            this.writeExternalJ2EEName(out);
            this.writeExternalPKey(out);
            out.flush();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"writeExternal");
            }
        }
    }

    private void writeExternalJ2EEName(ObjectOutput out) throws IOException {
        byte[] j2eeNameBytes = this.j2eeName.getBytes();
        out.writeInt(j2eeNameBytes.length);
        out.write(j2eeNameBytes);
    }

    private void writeExternalPKey(ObjectOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream pkeyStream = new ObjectOutputStream(baos);
        pkeyStream.writeObject(this.pkey);
        pkeyStream.flush();
        pkeyStream.close();
        byte[] pkeyBytes = baos.toByteArray();
        out.writeInt(pkeyBytes.length);
        out.write(pkeyBytes);
    }
}

