/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.monitor.pmi.application;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.sip.container.pmi.ApplicationModuleInterface;
import com.ibm.ws.sip.container.pmi.ApplicationTaskDurationModuleInterface;
import com.ibm.ws.sip.container.pmi.RequestModuleInterface;
import com.ibm.ws.sip.container.pmi.ResponseModuleInterface;
import com.ibm.ws.sip.container.pmi.SessionInterface;
import com.ibm.ws.sip.container.pmi.SessionModule;
import com.ibm.ws.sip.container.pmi.basic.SessionsCounter;
import com.ibm.ws.sip.container.pmi.taskduration.ApplicationTaskDurationModule;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="s_logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class ApplicationModule
implements ApplicationModuleInterface,
RequestModuleInterface,
ResponseModuleInterface {
    private static final Logger s_logger = Logger.getLogger(ApplicationModule.class.getName());
    private SessionsCounter _appCounter;
    private SessionModule _sessionModule;
    private ApplicationTaskDurationModule _applicationTaskDurationModule;
    static final long serialVersionUID = 8766819067221248627L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ApplicationModule(String appFullName) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "<init>", new Object[]{appFullName});
        }
        this._appCounter = new SessionsCounter();
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, ApplicationModule.class.getName(), "ApplicationModule", " new");
        }
        this._sessionModule = new SessionModule(appFullName, this._appCounter);
        this._applicationTaskDurationModule = new ApplicationTaskDurationModule(appFullName);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void incrementInRequest(String method) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "incrementInRequest", new Object[]{method});
        }
        this._appCounter.inboundRequest(method);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "incrementInRequest");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void incrementOutRequest(String method) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "incrementOutRequest", new Object[]{method});
        }
        this._appCounter.outboundRequest(method);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "incrementOutRequest");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void incrementInResponse(int code) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "incrementInResponse", new Object[]{code});
        }
        this._appCounter.inboundResponse(code);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "incrementInResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void incrementOutResponse(int code) {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "incrementOutResponse", new Object[]{code});
        }
        this._appCounter.outboundResponse(code);
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "incrementOutResponse");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void updateCounters() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "updateCounters", new Object[0]);
        }
        if (s_logger != null && s_logger.isLoggable(Level.FINEST)) {
            s_logger.logp(Level.FINEST, ApplicationModule.class.getName(), "updateCounters", "");
        }
        this._sessionModule.updateCounters();
        this._appCounter.updateCounters();
        this._applicationTaskDurationModule.updatePMICounters();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "updateCounters");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void destroy() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "destroy", new Object[0]);
        }
        this._sessionModule.destroy();
        this._applicationTaskDurationModule.destroy();
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "destroy");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SessionInterface getSessionModule() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getSessionModule", new Object[0]);
        }
        SessionModule sessionModule = this._sessionModule;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            sessionModule = sessionModule;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getSessionModule", sessionModule);
        }
        return sessionModule;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ResponseModuleInterface getResponseModule() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getResponseModule", new Object[0]);
        }
        ApplicationModule applicationModule = this;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            applicationModule = applicationModule;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getResponseModule", applicationModule);
        }
        return applicationModule;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public RequestModuleInterface getRequestModule() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getRequestModule", new Object[0]);
        }
        ApplicationModule applicationModule = this;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            applicationModule = applicationModule;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getRequestModule", applicationModule);
        }
        return applicationModule;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ApplicationTaskDurationModuleInterface getApplicationTaskDurationModule() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getApplicationTaskDurationModule", new Object[0]);
        }
        ApplicationTaskDurationModule applicationTaskDurationModule = this._applicationTaskDurationModule;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            applicationTaskDurationModule = applicationTaskDurationModule;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getApplicationTaskDurationModule", applicationTaskDurationModule);
        }
        return applicationTaskDurationModule;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public SessionsCounter getAppSessionsCounter() {
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            s_logger.entering("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getAppSessionsCounter", new Object[0]);
        }
        SessionsCounter sessionsCounter = this._appCounter;
        if (s_logger != null && s_logger.isLoggable(Level.FINER)) {
            sessionsCounter = sessionsCounter;
            s_logger.exiting("com.ibm.ws.sip.monitor.pmi.application.ApplicationModule", "getAppSessionsCounter", sessionsCounter);
        }
        return sessionsCounter;
    }
}

