/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install;

import com.ibm.ws.install.internal.InstallLogUtils;

public class RepositoryConfigValidationResult {
    private final int lineNum;
    private final ValidationFailedReason failedReason;
    private String validationMessage;

    public RepositoryConfigValidationResult(int lineNum, ValidationFailedReason failedReason, String validationMessage) {
        this.lineNum = lineNum;
        this.failedReason = failedReason;
        this.validationMessage = validationMessage;
    }

    public String getValidationMessage() {
        return this.validationMessage;
    }

    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    public int getLineNum() {
        return this.lineNum;
    }

    public String getFailedReason() {
        switch (this.failedReason) {
            case INVALID_VALUE: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_INVALID_VALUE", new Object[0]);
            }
            case INVALID_KEY: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_INVALID_KEY", new Object[0]);
            }
            case EMPTY_KEY: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_EMPTY_KEY", new Object[0]);
            }
            case EMPTY_VALUE: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_EMPTY_VALUE", new Object[0]);
            }
            case MISSING_REPONAME: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_MISSING_REPONAME", new Object[0]);
            }
            case MISSING_PORT: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_MISSING_PORT", new Object[0]);
            }
            case INVALID_PORT: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_INVALID_PORT", new Object[0]);
            }
            case MISSING_HOST: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_MISSING_HOST", new Object[0]);
            }
            case INVALID_HOST: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_INVALID_HOST", new Object[0]);
            }
            case INVALID_URL: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_INVALID_URL", new Object[0]);
            }
            case DUPLICATE_KEY: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_DUPLICATE_KEY", new Object[0]);
            }
            case UNSUPPORTED_PROTOCOL: {
                return InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("VALIDATION_UNSUPPORTED_PROTOCOL", new Object[0]);
            }
        }
        return null;
    }

    public static enum ValidationFailedReason {
        INVALID_VALUE,
        INVALID_KEY,
        EMPTY_KEY,
        EMPTY_VALUE,
        MISSING_REPONAME,
        MISSING_PORT,
        INVALID_PORT,
        MISSING_HOST,
        INVALID_HOST,
        INVALID_URL,
        DUPLICATE_KEY,
        UNSUPPORTED_PROTOCOL;

    }
}

