/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.servlet.ESIProcessor;
import java.io.IOException;

abstract class ESIProcessorRequest {
    protected static final int MSG_GET_PID = 1;
    protected static final int MSG_GATHER = 2;
    protected static final int MSG_RESET_COUNTERS = 3;
    protected static final int MSG_CLEAR_CACHE = 4;
    protected static final int MSG_INVALIDATE_ID = 5;
    protected static final int MSG_END = 6;
    protected static final int CACHE_HITS = 7;
    protected static final int CACHE_MISSES_BY_URL = 8;
    protected static final int CACHE_MISSES_BY_ID = 9;
    protected static final int CACHE_EXPIRES = 10;
    protected static final int CACHE_PURGES = 11;
    protected static final int CACHE_ENTRY = 12;
    protected static final int CACHE_COUNTS = 3968;
    protected static final int GATHER_ALL = 8064;
    private static final TraceComponent _tc = Tr.register(ESIProcessorRequest.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.servlet.ESIProcessorRequest");
    protected ESIProcessor _processor;
    protected Throwable _throwable;
    protected boolean _completed = false;

    public ESIProcessorRequest(ESIProcessor processor) {
        this._processor = processor;
        this._throwable = null;
    }

    public abstract void handle() throws IOException;

    public synchronized void markCompleted(Throwable throwable) {
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("markCompleted " + this), (Object[])new Object[0]);
        }
        this._completed = true;
        this._throwable = throwable;
        this.notify();
    }

    public synchronized void awaitCompletion() throws Throwable {
        if (_tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)_tc, (String)("awaitCompletion " + this), (Object[])new Object[0]);
        }
        while (!this._completed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this._throwable != null) {
            throw this._throwable;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)_tc, (String)("awaitCompletion " + this));
        }
    }

    protected int readInt() throws IOException {
        return this._processor.readInt();
    }

    protected String readString() throws IOException {
        return this._processor.readString();
    }

    protected void writeInt(int val) throws IOException {
        this._processor.writeInt(val);
    }

    protected void writeString(String str) throws IOException {
        this._processor.writeString(str);
    }

    protected void flush() throws IOException {
        this._processor.flush();
    }

    protected int available() throws IOException {
        return this._processor.available();
    }

    protected void flushWithResponse() throws IOException {
        this._processor.flushWithResponse();
    }
}

