/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.command;

import com.ibm.websphere.cache.CacheEntry;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetPolicy;
import com.ibm.websphere.command.TargetableCommandImpl;
import com.ibm.ws.cache.BatchUpdateDaemon;
import com.ibm.ws.cache.EntryInfo;
import com.ibm.ws.cache.RemoteServices;
import com.ibm.ws.cache.command.CommandStoragePolicy;
import com.ibm.ws.cache.intf.DCache;
import java.io.Serializable;
import java.rmi.RemoteException;

public class CommandCache
implements com.ibm.ws.cache.intf.CommandCache {
    private DCache cache = null;
    private RemoteServices remoteServices = null;
    private BatchUpdateDaemon batchUpdateDaemon = null;
    private CommandStoragePolicy commandStoragePolicy = null;

    public void setCache(DCache cache) {
        this.cache = cache;
    }

    public void setBatchUpdateDaemon(BatchUpdateDaemon batchUpdateDaemon) {
        this.batchUpdateDaemon = batchUpdateDaemon;
    }

    public void setRemoteServices(RemoteServices remoteServices) {
        this.remoteServices = remoteServices;
    }

    public CommandStoragePolicy getCommandStoragePolicy() {
        return this.commandStoragePolicy;
    }

    public void setCommandStoragePolicy(Object commandStoragePolicy) {
        this.commandStoragePolicy = (CommandStoragePolicy)commandStoragePolicy;
    }

    public void start() {
        if (this.cache == null || this.commandStoragePolicy == null || this.batchUpdateDaemon == null || this.remoteServices == null) {
            throw new IllegalStateException("cache, batchUpdateDaemon, and remoteServices must all be set before start()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableCommand getCommandLocally(CacheableCommand inputCommand, boolean execute) throws CommandException {
        CacheableCommand outputCommand;
        if (inputCommand == null) {
            throw new IllegalArgumentException("inputCommand was null");
        }
        CacheEntry cacheEntry = null;
        Object value = null;
        try {
            EntryInfo ei = (EntryInfo)inputCommand.getEntryInfo();
            cacheEntry = this.cache.getEntry((com.ibm.websphere.cache.EntryInfo)ei, false);
            if (cacheEntry != null) {
                value = cacheEntry.getValue();
            }
            outputCommand = this.commandStoragePolicy.prepareForCacheAccess((Serializable)value, this.cache, ei);
        }
        finally {
            if (cacheEntry != null) {
                cacheEntry.finish();
            }
        }
        if (outputCommand == null && execute) {
            outputCommand = this.executeAndCacheCommand(inputCommand);
        }
        return outputCommand;
    }

    private CacheableCommand executeAndCacheCommand(CacheableCommand inputCommand) throws CommandException {
        TargetPolicy targetPolicy = TargetableCommandImpl.getTargetPolicy();
        CommandTarget commandTarget = targetPolicy.getCommandTarget(inputCommand);
        CacheableCommand outputCommand = this.executeCommand(inputCommand, commandTarget);
        if (outputCommand == null) {
            throw new IllegalStateException("outputCommand was returned from proxy as null");
        }
        this.setCommand(outputCommand);
        return outputCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheableCommand getCommand(CacheableCommand inputCommand, boolean execute) throws CommandException {
        if (inputCommand == null) {
            throw new IllegalArgumentException("inputCommand was null");
        }
        String id = inputCommand.getId();
        CacheEntry cacheEntry = null;
        Object value = null;
        try {
            CacheableCommand outputCommand;
            EntryInfo ei = (EntryInfo)inputCommand.getEntryInfo();
            int cmdSharing = inputCommand.getSharingPolicy();
            boolean askPermission = this.remoteServices.shouldPull(cmdSharing, (Object)id);
            cacheEntry = this.cache.getEntry((com.ibm.websphere.cache.EntryInfo)ei, askPermission);
            if (cacheEntry != null) {
                value = cacheEntry.getValue();
            }
            if ((outputCommand = this.commandStoragePolicy.prepareForCacheAccess((Serializable)value, this.cache, ei)) == null && execute) {
                outputCommand = this.executeAndCacheCommand(inputCommand);
            }
            CacheableCommand cacheableCommand = outputCommand;
            return cacheableCommand;
        }
        finally {
            if (cacheEntry != null) {
                cacheEntry.finish();
            }
        }
    }

    public void setCommand(CacheableCommand command) {
        if (command == null) {
            throw new IllegalArgumentException("command was null");
        }
        String id = command.getId();
        EntryInfo entryInfo = (EntryInfo)command.getEntryInfo();
        if (entryInfo.isSharedPull()) {
            this.batchUpdateDaemon.invalidateById((Object)id, true, this.cache);
        }
        Serializable value = this.commandStoragePolicy.prepareForCache(command);
        this.cache.setValue(entryInfo, (Object)value, entryInfo.isSharedPush(), false);
    }

    public CacheableCommand executeCommand(CacheableCommand command, CommandTarget commandTarget) throws CommandException {
        CacheableCommand returnCommand = command;
        try {
            boolean done = command.preExecute();
            if (done) {
                CacheableCommand cacheableCommand = command;
                return cacheableCommand;
            }
            returnCommand = (CacheableCommand)commandTarget.executeCommand(command);
            returnCommand.postExecute();
            CacheableCommand cacheableCommand = returnCommand;
            return cacheableCommand;
        }
        catch (RemoteException rex) {
            throw new CommandException(rex);
        }
        finally {
            EntryInfo entryInfo = (EntryInfo)returnCommand.getEntryInfo();
            entryInfo.addTemplate(returnCommand.getClass().getName());
        }
    }

    public boolean isValid(String id) {
        return this.cache.isValid(id);
    }

    public void invalidateById(String id, boolean waitOnInvalidation) {
        this.cache.invalidateById(id, waitOnInvalidation);
    }

    public void invalidateById(String id, int causeOfInvalidation, boolean waitOnInvalidation) {
        this.cache.invalidateById((Object)id, causeOfInvalidation, waitOnInvalidation);
    }

    public void invalidateByTemplate(String template, boolean waitOnInvalidation) {
        this.cache.invalidateByTemplate(template, waitOnInvalidation);
    }

    public DCache getCache() {
        return this.cache;
    }
}

