/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.security.token.ValidationResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ValidationResultImpl
implements ValidationResult {
    public static final String REALM_DELIMITER = "/";
    public static final String TYPE_DELIMITER = ":";
    public static final String USER_TYPE_DELIMITER = "user:";
    public static final String EMPTY_STRING;
    private final String uniqueId;
    private String realm = null;
    static final long serialVersionUID = -5273767818967574821L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ValidationResultImpl(String uniqueId, String realm) {
        this.realm = realm;
        this.uniqueId = uniqueId;
    }

    @Override
    public String getRealmFromUniqueId() {
        if (this.realm == null) {
            return ValidationResultImpl.getRealmFromUniqueID(this.uniqueId);
        }
        return this.realm;
    }

    @Override
    public String getUniqueId() {
        String result = this.uniqueId;
        return result;
    }

    @Override
    public String getUserFromUniqueId() {
        Pattern pattern;
        Matcher m;
        String result = null;
        if (this.realm == null) {
            result = ValidationResultImpl.getUserFromUniqueID(this.uniqueId);
        } else if (this.realm != null && (m = (pattern = Pattern.compile("([^:]+):(" + Pattern.quote(this.realm) + ")/(.*)")).matcher(this.uniqueId)).matches() && m.group(3).length() > 0) {
            return m.group(3);
        }
        return result;
    }

    @Override
    public boolean requiresLogin() {
        return true;
    }

    private static String getUserFromUniqueID(String uniqueID) {
        if (uniqueID == null) {
            return EMPTY_STRING;
        }
        if (uniqueID.startsWith(USER_TYPE_DELIMITER)) {
            int realmDelimiterIndex = (uniqueID = uniqueID.trim()).indexOf(REALM_DELIMITER);
            if (realmDelimiterIndex < 0) {
                return EMPTY_STRING;
            }
            return uniqueID.substring(realmDelimiterIndex + 1);
        }
        return EMPTY_STRING;
    }

    private static String getRealmFromUniqueID(String uniqueID) {
        int index = uniqueID.indexOf(TYPE_DELIMITER);
        if (uniqueID.startsWith(USER_TYPE_DELIMITER)) {
            uniqueID = uniqueID.substring(index + 1);
        }
        return ValidationResultImpl.getRealm(uniqueID);
    }

    private static String getRealm(String realmSecurityName) {
        if (realmSecurityName == null) {
            return EMPTY_STRING;
        }
        int realmDelimiterIndex = (realmSecurityName = realmSecurityName.trim()).indexOf(REALM_DELIMITER);
        if (realmDelimiterIndex < 0) {
            return null;
        }
        return realmSecurityName.substring(0, realmDelimiterIndex);
    }

    public String toString() {
        return super.toString() + " uniqueId = " + this.uniqueId;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.token.internal.ValidationResultImpl", ValidationResultImpl.class, (String)"Token", (String)"com.ibm.ws.security.token.internal.resources.TokenMessages");
        EMPTY_STRING = new String("");
    }
}

