/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.ConnectionInterface;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationMetaData;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.jfapchannel.DispatchQueue;
import com.ibm.ws.sib.jfapchannel.Dispatchable;
import com.ibm.ws.sib.jfapchannel.HandshakeProperties;
import com.ibm.ws.sib.jfapchannel.JFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.ReceiveListener;
import com.ibm.ws.sib.jfapchannel.ReceivedData;
import com.ibm.ws.sib.jfapchannel.SendListener;
import com.ibm.ws.sib.jfapchannel.buffer.WsByteBuffer;
import com.ibm.ws.sib.jfapchannel.impl.Connection;
import com.ibm.ws.sib.jfapchannel.impl.ExchangeReceiveListener;
import com.ibm.ws.sib.jfapchannel.impl.ExchangeReceiveListenerPool;
import com.ibm.ws.sib.jfapchannel.impl.InternalJFapByteBuffer;
import com.ibm.ws.sib.jfapchannel.impl.JFapUtils;
import com.ibm.ws.sib.jfapchannel.impl.RequestIdTable;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.ConnectionEventRecorderFactory;
import com.ibm.ws.sib.jfapchannel.impl.eventrecorder.ConversationEventRecorder;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.AbstractInvocation;
import com.ibm.ws.sib.jfapchannel.impl.rldispatcher.ReceiveListenerDispatcher;
import com.ibm.ws.sib.mfp.ConnectionSchemaSet;
import com.ibm.ws.sib.utils.Semaphore;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import java.net.InetAddress;
import java.util.Iterator;

public class ConversationImpl
implements Conversation,
Dispatchable {
    private static final TraceComponent tc = SibTr.register(ConversationImpl.class, (String)"SIBJFapChannel", (String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.jfapchannel.CWSIJMessages");
    public static final String $sccsid = "@(#) 1.105 SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/ConversationImpl.java, SIB.comms, WASX.SIB, uu1215.01 10/05/28 04:39:10 [4/12/12 22:14:14]";
    private short id = 0;
    private boolean first = false;
    private Connection connection = null;
    private RequestIdTable reqIdTable = null;
    private Object attachment = null;
    private volatile ConversationReceiveListener defaultReceiveListener = null;
    private Object defaultReceiveListenerLock = new Object();
    private Semaphore waitForDefaultReceiveListenerSemaphore = new Semaphore();
    private static int instanceCounter;
    private int thisInstanceCounter = 0;
    private Object dispatchLockObject = new Object();
    private DispatchQueue dispatchQueue = null;
    private int dispatchQueueReferenceCount = 0;
    private boolean onClientSide = false;
    private int totalOutstandingRequests = 0;
    private Object totalOutstandingRequestsLock = new Object();
    private AbstractInvocation errorOccurredInvocation = null;
    protected String description = "";
    private Object sendMonitor = new Object();
    private boolean inSend = false;
    private boolean invalidateOutstanding = false;
    private Throwable invalidateOutstandingThrowable = null;
    private final Semaphore waitForCloseToCompleteSemaphore = new Semaphore();
    private static final StateEnum OPEN;
    private static final StateEnum NOTIFY_PEER;
    private static final StateEnum AWAITING_PEER1;
    private static final StateEnum PARALLEL_CLOSE1;
    private static final StateEnum AWAITING_PEER2;
    private static final StateEnum PARALLEL_CLOSE2;
    private static final StateEnum AWAITING_PEER3;
    private static final StateEnum CLOSED;
    private final Object stateChangeMonitor = new Object();
    private StateEnum state = OPEN;
    private final ConversationEventRecorder eventRecorder;
    private ExchangeReceiveListenerPool exchangeReceiveListenerPool = new ExchangeReceiveListenerPool(8);

    public String toString() {
        return this.getClass() + "@" + System.identityHashCode(this) + " id: " + this.id + " first: " + this.first + " " + this.state + " connection: " + System.identityHashCode(this.connection) + " onClientSide: " + this.onClientSide;
    }

    @Override
    public String getFullSummary() {
        return this.toString() + " " + this.eventRecorder;
    }

    protected ConversationImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.eventRecorder = ConnectionEventRecorderFactory.getConnectionEventRecorder().getConversationEventRecorder();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public ConversationImpl(short id, boolean first, Connection connection, ConversationReceiveListener drl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"" + id, "" + first, connection, drl});
        }
        this.id = id;
        this.first = first;
        this.connection = connection;
        if (connection != null) {
            this.eventRecorder = connection.getConnectionEventRecorder().getConversationEventRecorder();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"entered unit test code branch!");
            }
            this.eventRecorder = ConnectionEventRecorderFactory.getConnectionEventRecorder().getConversationEventRecorder();
        }
        this.reqIdTable = new RequestIdTable();
        this.defaultReceiveListener = drl;
        this.thisInstanceCounter = instanceCounter++;
        if (instanceCounter < 0) {
            instanceCounter = 0;
        }
        this.description = "ConvId:" + id;
        if (TraceComponent.isAnyTracingEnabled()) {
            JFapUtils.debugSummaryMessage(tc, connection, this, "New conversation started");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    @Override
    public void setDefaultReceiveListener(ConversationReceiveListener drl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDefaultReceiveListener", (Object)drl);
        }
        this.defaultReceiveListener = drl;
        this.waitForDefaultReceiveListenerSemaphore.post();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDefaultReceiveListener");
        }
    }

    protected RequestIdTable getRequestIdTable() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getRequestIdTable");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getRequestIdTable", (Object)this.reqIdTable);
        }
        return this.reqIdTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationReceiveListener getDefaultReceiveListener() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDefaultReceiveListener");
        }
        Object object = this.defaultReceiveListenerLock;
        synchronized (object) {
            if (this.defaultReceiveListener == null) {
                this.waitForDefaultReceiveListenerSemaphore.waitOnIgnoringInterruptions();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDefaultReceiveListener", (Object)this.defaultReceiveListener);
        }
        return this.defaultReceiveListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fastClose() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"fastClose");
        }
        if (!this.isClosed()) {
            Object object = this.stateChangeMonitor;
            synchronized (object) {
                this.state = CLOSED;
            }
            this.connection.removeConversationById(this.id);
            this.connection.closeNotification(this);
            this.wakeupAllWithException(new SIConnectionLostException("Conversation was fast closed"), false);
            this.eventRecorder.logDebug("state transition: open -> closed (fast)");
        } else {
            Object object = this.stateChangeMonitor;
            synchronized (object) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("fastclose invoked in state " + this.state + " - ignoring"));
                }
                this.eventRecorder.logDebug("fastclose invoked in state " + this.state + " - ignoring");
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"fastClose");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SIConnectionLostException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
        }
        this.eventRecorder.logEntry("close");
        boolean sendClose = false;
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state == OPEN) {
                sendClose = true;
                this.state = NOTIFY_PEER;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: open -> notify peer");
                }
                this.eventRecorder.logDebug("state transition: open -> notify peer");
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("close invoked in state " + this.state + " - ignoring"));
                }
                this.eventRecorder.logDebug("close invoked in state " + this.state + " - ignoring");
            }
        }
        if (sendClose) {
            this.sendLogicalClose(true);
            if (this.onClientSide) {
                this.waitForCloseToCompleteSemaphore.waitOnIgnoringInterruptions();
            }
        }
        this.eventRecorder.logExit("close");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(Throwable throwable) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"invalidate", (Object)throwable);
        }
        this.eventRecorder.logEntry("invalidate");
        Object object = this.sendMonitor;
        synchronized (object) {
            if (this.inSend) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"send currently in progress - delaying");
                }
                this.eventRecorder.logDebug("send in progress - delaying invalidation");
                this.invalidateOutstanding = true;
                this.invalidateOutstandingThrowable = throwable;
            } else {
                boolean wakeup = false;
                Object object2 = this.stateChangeMonitor;
                synchronized (object2) {
                    if (this.state != CLOSED) {
                        if (TraceComponent.isAnyTracingEnabled()) {
                            JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation invalidated!");
                        }
                        this.eventRecorder.logDebug("conversation invalidated!");
                        this.connection.removeConversationById(this.id);
                    }
                    wakeup = true;
                    this.state = CLOSED;
                    this.waitForCloseToCompleteSemaphore.post();
                }
                if (wakeup) {
                    SIConnectionLostException clException = null;
                    if (throwable instanceof SIConnectionLostException) {
                        clException = (SIConnectionLostException)throwable;
                    } else {
                        ConversationMetaData m = this.getMetaData();
                        String remoteHostAddress = "<Unknown>";
                        String remoteHostPort = "<Unknown>";
                        String chainName = m.getChainName();
                        InetAddress addr = m.getRemoteAddress();
                        if (addr != null) {
                            remoteHostAddress = addr.getHostAddress();
                        }
                        remoteHostPort = "" + m.getRemotePort();
                        clException = m.isInbound() ? new SIConnectionLostException(nls.getFormattedMessage("CONVERSATIONIMPL_INVALIDATE_SICJ0045", new Object[]{remoteHostAddress, chainName}, null), throwable) : new SIConnectionLostException(nls.getFormattedMessage("CONVERSATIONIMPL_INVALIDATE_OUTBOUND_SICJ0072", new Object[]{remoteHostAddress, remoteHostPort, chainName}, null), throwable);
                    }
                    this.wakeupAllWithException(clException, true);
                }
            }
        }
        this.eventRecorder.logExit("invalidate");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"invalidate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLogicalCloseRequest() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processLogicalCloseRequest");
        }
        this.eventRecorder.logEntry("processLogicalCloseRequest");
        boolean invalidate = false;
        boolean sendCloseResponse = false;
        boolean close = false;
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state == OPEN) {
                this.state = CLOSED;
                sendCloseResponse = true;
                close = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: open -> closed");
                }
                this.eventRecorder.logDebug("state transition: open -> closed");
            } else if (this.state == NOTIFY_PEER) {
                this.state = AWAITING_PEER2;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: notify peer -> awaiting peer 2");
                }
                this.eventRecorder.logDebug("state transition: notify peer -> awaiting peer 2");
            } else if (this.state == AWAITING_PEER1) {
                this.state = PARALLEL_CLOSE1;
                sendCloseResponse = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: awaiting peer 1 -> parallel close 1");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 1 -> parallel close 1");
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid state transition. Received processLogicalClose whilst in state " + this.state));
                }
                this.eventRecorder.logError("invalid state transition.  state=" + this.state + " transition=logical close request");
                FFDCFilter.processException((Throwable)new Exception(), (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070012", (Object[])new Object[]{this.state, this.eventRecorder.toString()});
                invalidate = true;
            }
        }
        if (sendCloseResponse) {
            this.sendLogicalClose(false);
        }
        if (close) {
            this.wakeupAllWithException(new SIConnectionLostException("Connection lost after peer responded to a logical close request before all conversations were closed"), false);
            if (TraceComponent.isAnyTracingEnabled()) {
                JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
            }
            this.connection.removeConversationById(this.id);
            this.connection.closeNotification(this);
            this.waitForCloseToCompleteSemaphore.post();
        }
        if (invalidate) {
            this.connection.invalidate(false, new SIConnectionLostException("Connection closed as part of processing a logical close request"), "error during logical close");
        }
        this.eventRecorder.logExit("processLogicalCloseRequest");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processLogicalCloseRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLogicalCloseResponse() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processLogicalCloseResponse");
        }
        this.eventRecorder.logEntry("processLogicalCloseResponse");
        boolean wakeup = false;
        boolean invalidate = false;
        boolean sendCloseResponse = false;
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state == AWAITING_PEER2) {
                this.state = PARALLEL_CLOSE2;
                sendCloseResponse = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: awaiting peer 2 -> parallel close 2");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 2 -> parallel close 2");
            } else if (this.state == PARALLEL_CLOSE1) {
                wakeup = true;
                if (TraceComponent.isAnyTracingEnabled()) {
                    JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: parallel close 1 -> closed");
                }
                this.eventRecorder.logDebug("state transition: parallel close 1 -> closed");
                this.connection.removeConversationById(this.id);
                this.state = CLOSED;
                this.connection.closeNotification(this);
                this.waitForCloseToCompleteSemaphore.post();
            } else if (this.state == NOTIFY_PEER) {
                this.state = AWAITING_PEER3;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: notify peer -> awaiting peer 3");
                }
                this.eventRecorder.logDebug("state transition: notify peer -> awaiting peer 3");
            } else if (this.state == AWAITING_PEER1) {
                wakeup = true;
                if (TraceComponent.isAnyTracingEnabled()) {
                    JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: awaiting peer 1 -> closed");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 1 -> closed");
                this.connection.removeConversationById(this.id);
                this.state = CLOSED;
                this.connection.closeNotification(this);
                this.waitForCloseToCompleteSemaphore.post();
            } else {
                invalidate = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("processLogicalCloseResponse invoked when in state: " + this.state));
                }
                this.eventRecorder.logError("invalid state transition.  state=" + this.state + " transition=logical close response");
                FFDCFilter.processException((Throwable)new Exception(), (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070013", (Object[])new Object[]{this.state, this.eventRecorder.toString()});
            }
        }
        if (sendCloseResponse) {
            this.sendLogicalClose(false);
        }
        if (wakeup) {
            this.wakeupAllWithException(new SIConnectionLostException("Connection lost after peer responded to a logical close request before all conversations were closed"), false);
        }
        if (invalidate) {
            this.connection.invalidate(false, new SIConnectionLostException("Connection invalidated after peer responded to a logical close request " + this.state), "received unexpected logical close response");
        }
        this.eventRecorder.logExit("processLogicalCloseResponse");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processLogicalCloseResponse");
        }
    }

    private void sendLogicalClose(boolean request) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendLogicalClose", (Object)("" + request));
        }
        this.eventRecorder.logEntry("sendLogicalClose");
        InternalJFapByteBuffer buffer = new InternalJFapByteBuffer();
        if (request) {
            buffer.put((byte)0);
        } else {
            buffer.put((byte)1);
        }
        LogicalCloseSendListener listener = null;
        if (request) {
            listener = new LogicalCloseSendListener();
            this.eventRecorder.logDebug("LogicalCloseSendListener hashcode: " + Integer.toHexString(System.identityHashCode(listener)));
        }
        try {
            this.connection.send(buffer, 10, this.id, 0, -1, true, false, Conversation.ThrottlingPolicy.DO_NOT_THROTTLE, listener, this, false);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070001", (Object)this.eventRecorder.toString());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)e));
            }
            this.connection.invalidate(false, e, "SIException thrown from system send");
            this.waitForCloseToCompleteSemaphore.post();
        }
        this.eventRecorder.logExit("sendLogicalClose");
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendLogicalClose");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCompletes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendCompletes");
        }
        boolean sendCloseResponse = false;
        boolean wakeup = false;
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            if (this.state == NOTIFY_PEER) {
                this.state = AWAITING_PEER1;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: notify peer -> awaiting peer 1");
                }
                this.eventRecorder.logDebug("state transition: notify peer -> awaiting peer 1");
            } else if (this.state == AWAITING_PEER2) {
                this.state = PARALLEL_CLOSE1;
                sendCloseResponse = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: awaiting peer 2 -> parallel close 1");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 2 -> parallel close 1");
            } else if (this.state == PARALLEL_CLOSE2) {
                wakeup = true;
                if (TraceComponent.isAnyTracingEnabled()) {
                    JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: parallel close 2 -> closed");
                }
                this.eventRecorder.logDebug("state transition: parallel close 2 -> closed");
                this.connection.removeConversationById(this.id);
                this.state = CLOSED;
                this.connection.closeNotification(this);
                this.waitForCloseToCompleteSemaphore.post();
            } else if (this.state == AWAITING_PEER3) {
                wakeup = true;
                if (TraceComponent.isAnyTracingEnabled()) {
                    JFapUtils.debugSummaryMessage(tc, this.connection, this, "Conversation closed (processLogicalCloseResponse)");
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"state transition: awaiting peer 3 -> closed");
                }
                this.eventRecorder.logDebug("state transition: awaiting peer 3 -> closed");
                this.connection.removeConversationById(this.id);
                this.state = CLOSED;
                this.connection.closeNotification(this);
                this.waitForCloseToCompleteSemaphore.post();
            } else {
                this.eventRecorder.logError("invalid state transition.  state=" + this.state + " transition=sendCompletes");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid state transition.  State=" + this.state + ".  Transition=sendCompletes"));
                }
                FFDCFilter.processException((Throwable)new Exception(), (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"NEW_FFDC_PROBE_NEEDED_03", (Object[])new Object[]{this.state, this.eventRecorder.toString()});
                this.waitForCloseToCompleteSemaphore.post();
            }
        }
        if (sendCloseResponse) {
            this.sendLogicalClose(false);
        }
        if (wakeup) {
            this.wakeupAllWithException(new SIConnectionLostException("Peer initiated connection close while conversations still active"), false);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendCompletes");
        }
    }

    protected void wakeupAllWithException(SIConnectionLostException exception, boolean alwaysDeliverToConversationReceiveListener) {
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"wakeupAllWithException", (Object)alwaysDeliverToConversationReceiveListener);
            }
            boolean requestorsWoken = false;
            Iterator requestIdIterator = this.reqIdTable.idIterator();
            while (requestIdIterator.hasNext()) {
                SendListener sendListener;
                Integer requestId;
                block17: {
                    requestId = (Integer)requestIdIterator.next();
                    ReceiveListener receiveListener = this.reqIdTable.getListener(requestId);
                    if (receiveListener != null) {
                        requestorsWoken = true;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("waking " + receiveListener));
                        }
                        try {
                            ReceiveListenerDispatcher.getInstance(this.connection.getConversationType(), this.onClientSide).queueErrorOccurredInvocation(this.connection, receiveListener, exception, -1, (int)requestId, -1, (Conversation)this);
                        }
                        catch (Throwable t) {
                            FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070003", (Object[])new Object[]{this.state, this.eventRecorder.toString()});
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown in receive listener error occurred method");
                            }
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block17;
                            SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)t);
                        }
                    }
                }
                if ((sendListener = this.reqIdTable.getSendListener(requestId)) == null) continue;
                requestorsWoken = true;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("waking " + sendListener));
                }
                try {
                    sendListener.errorOccurred(exception, this);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070003", (Object)this.eventRecorder.toString());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown in send listener error occurred method");
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) continue;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)t);
                }
            }
            this.reqIdTable.clear();
            if (requestorsWoken || alwaysDeliverToConversationReceiveListener) {
                ConversationReceiveListener crl = this.getDefaultReceiveListener();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("notifying conversation receive listener " + crl));
                }
                try {
                    ReceiveListenerDispatcher.getInstance(this.connection.getConversationType(), this.onClientSide).queueErrorOccurredInvocation(this.connection, crl, exception, -1, -1, -1, (Conversation)this);
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070003", (Object)this.eventRecorder.toString());
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"exception thrown in connection receive listener error occurred method");
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block18;
                    SibTr.exception((Object)this, (TraceComponent)tc, (Throwable)t);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"wakeupAllWithException");
        }
    }

    @Override
    public ReceivedData exchange(JFapByteBuffer buffer, int segmentType, int requestNumber, int priority, boolean canPoolOnReceive) throws SIConnectionLostException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"exchange", (Object)new Object[]{buffer, "" + segmentType, "" + requestNumber, "" + priority, "" + canPoolOnReceive});
        }
        if (requestNumber == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exchnage with requestNumber == 0");
            }
            SIErrorException sie = new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"exchange", (Object)sie);
            }
            throw sie;
        }
        buffer.setReadOnly();
        ExchangeReceiveListener receiveListener = this.exchangeReceiveListenerPool.allocate(requestNumber);
        this.sendInternal(buffer, segmentType, requestNumber, priority, canPoolOnReceive, true, Conversation.ThrottlingPolicy.BLOCK_THREAD, receiveListener, null);
        receiveListener.waitToComplete();
        if (!receiveListener.successful()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"exchange", (Object)"operation unsuccessful");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)receiveListener.getException()));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"exchange", (Object)((Object)receiveListener.getException()));
            }
            throw receiveListener.getException();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"exchange", (Object)receiveListener);
        }
        return receiveListener;
    }

    @Override
    public long send(JFapByteBuffer buffer, int segmentType, int requestNumber, int priority, boolean canPoolOnReceive, Conversation.ThrottlingPolicy throttlingPolicy, SendListener sendListener) throws SIConnectionLostException, SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"send", (Object)new Object[]{buffer, segmentType, requestNumber, priority, canPoolOnReceive, throttlingPolicy, sendListener});
        }
        buffer.setReadOnly();
        long bytes = 0L;
        bytes = this.sendInternal(buffer, segmentType, requestNumber, priority, canPoolOnReceive, false, throttlingPolicy, null, sendListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"send", (Object)("" + bytes));
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long sendInternal(JFapByteBuffer buffer, int segmentType, int requestNumber, int priority, boolean canPoolOnReceive, boolean isPartOfExchange, Conversation.ThrottlingPolicy throttlingPolicy, ReceiveListener receiveListener, SendListener sendListener) throws SIConnectionDroppedException, SIConnectionLostException {
        long bytesSent;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendInternal", (Object)new Object[]{buffer, segmentType, requestNumber, priority, canPoolOnReceive, isPartOfExchange, throttlingPolicy, receiveListener, sendListener});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            buffer.dump(this, tc, 16);
        }
        this.eventRecorder.logDebug(" >> Data sent: Segment " + segmentType + " (0x" + Integer.toHexString(segmentType) + "), Request No: " + requestNumber);
        if (this.getDefaultReceiveListener() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Conversation has no default receive listener");
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
            FFDCFilter.processException((Throwable)e, (String)(ConversationImpl.class.getName() + ".sendInternal"), (String)"00070014");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendInternal");
            }
            throw e;
        }
        if (this.reqIdTable.containsId(requestNumber)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Duplicate request ID");
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
            FFDCFilter.processException((Throwable)e, (String)(ConversationImpl.class.getName() + ".sendInternal"), (String)"00070014");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendInternal");
            }
            throw e;
        }
        if (priority != -1 && (priority < 0 || priority > 15)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("priority (" + priority + ") outside range of user priorities"));
            }
            priority = priority < 0 ? 0 : 15;
        }
        if (throttlingPolicy != Conversation.ThrottlingPolicy.BLOCK_THREAD && throttlingPolicy != Conversation.ThrottlingPolicy.DISCARD_TRANSMISSION) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Invalid throttling policy: " + (Object)((Object)throttlingPolicy)));
            }
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
            FFDCFilter.processException((Throwable)e, (String)(ConversationImpl.class.getName() + ".sendInternal"), (String)"00070014");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendInternal");
            }
            throw e;
        }
        Object e = this.sendMonitor;
        synchronized (e) {
            Object object = this.stateChangeMonitor;
            synchronized (object) {
                if (this.state != OPEN) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"sendInternal", (Object)"connection closed");
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendInternal");
                    }
                    throw new SIConnectionDroppedException(nls.getFormattedMessage("CONVERSATIONIMPL_CLOSED_SICJ0047", null, "CONVERSATIONIMPL_CLOSED_SICJ0047"));
                }
                this.inSend = true;
            }
        }
        try {
            if (requestNumber != 0 && receiveListener != null) {
                this.reqIdTable.add(requestNumber, receiveListener, sendListener);
            }
            bytesSent = this.connection.send(buffer, segmentType, this.id, requestNumber, priority, canPoolOnReceive, isPartOfExchange, throttlingPolicy, sendListener, this, true);
        }
        finally {
            Object object = this.sendMonitor;
            synchronized (object) {
                this.inSend = false;
                if (this.invalidateOutstanding) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"invalidate delayed - performing now");
                    }
                    this.eventRecorder.logDebug("performing delayed invalidation");
                    this.invalidateOutstanding = false;
                    this.invalidate(this.invalidateOutstandingThrowable);
                    this.invalidateOutstandingThrowable = null;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendInternal", (Object)("" + bytesSent));
        }
        return bytesSent;
    }

    @Override
    public boolean isFirst() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isFirst");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isFirst", (Object)("" + this.first));
        }
        return this.first;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handshakeComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handshakeComplete");
        }
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            this.connection.handshakeComplete();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"handshakeComplete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handshakeFailed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"handshakeFailed");
        }
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            this.connection.handshakeFailed();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"handshakeFailed");
        }
    }

    @Override
    public int getId() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getId");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getId", (Object)("" + this.id));
        }
        return this.id;
    }

    @Override
    public void setAttachment(Object attachment) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setAttachment", (Object)attachment);
        }
        this.attachment = attachment;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setAttachment");
        }
    }

    @Override
    public Object getAttachment() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getAttachment");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getAttachment", (Object)this.attachment);
        }
        return this.attachment;
    }

    @Override
    public void setLinkLevelAttachment(Object attachment) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setLinkLevelAttachment", (Object)attachment);
        }
        this.connection.setAttachment(attachment);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setLinkLevelAttachment");
        }
    }

    @Override
    public Object getLinkLevelAttachment() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getLinkLevelAttachment");
        }
        Object returnAttachment = this.connection.getAttachment();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getLinkLevelAttachment", (Object)returnAttachment);
        }
        return returnAttachment;
    }

    @Override
    public boolean sharesSameLinkAs(Conversation conversation) {
        boolean returnValue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sharesSameLinkAs", (Object)conversation);
        }
        boolean bl = returnValue = ((ConversationImpl)conversation).connection == this.connection;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sharesSameLinkAs", (Object)("" + returnValue));
        }
        return returnValue;
    }

    @Override
    public Conversation cloneConversation(ConversationReceiveListener receiveListener) throws SIResourceException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"cloneConversation", (Object)receiveListener);
        }
        Conversation returnConversation = this.connection.cloneConversation(receiveListener);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"cloneConversation", (Object)returnConversation);
        }
        return returnConversation;
    }

    @Override
    public Conversation[] getConversationsSharingSameLink() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversationsSharingSameLink");
        }
        Conversation[] retValue = this.connection.getConversations();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversationsSharingSameLink", (Object)retValue);
        }
        return retValue;
    }

    protected byte getNextRequestNumber() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getNextRequestNumber");
        }
        byte nextRequestNumber = this.connection.getNextRequestNumber();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getNextRequestNumber", (Object)("" + nextRequestNumber));
        }
        return nextRequestNumber;
    }

    protected boolean hasOutstandingRequests() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"hasOutstandingRequests");
        }
        boolean hasOutstandingRequests = this.reqIdTable.hasReceiveListeners();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"hasOutstandingRequests", (Object)("" + hasOutstandingRequests));
        }
        return hasOutstandingRequests;
    }

    @Override
    public void setHeartbeatInterval(int seconds) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setHeartbeatInterval", (Object)("" + seconds));
        }
        if (seconds < 1) {
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        this.connection.setHeartbeatInterval(seconds);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setHeartbeatInterval");
        }
    }

    @Override
    public int getHeartbeatInterval() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getHeartbeatInterval");
        }
        int returnValue = this.connection.getHeartbeatInterval();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getHeartbeatInterval", (Object)("" + returnValue));
        }
        return returnValue;
    }

    @Override
    public void setHeartbeatTimeout(int seconds) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setHeartbeatTimeout", (Object)("" + seconds));
        }
        if (seconds < 1) {
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        this.connection.setHeartbeatTimeout(seconds);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setHeartbeatTimeout");
        }
    }

    @Override
    public int getHeartbeatTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getHeartbeatTimeout");
        }
        int returnValue = this.connection.getHeartbeatTimeout();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getHeartbeatTimeout", (Object)("" + returnValue));
        }
        return returnValue;
    }

    @Override
    public Object getDispatchLockObject() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDispatchLockObject");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDispatchLockObject", (Object)this.dispatchLockObject);
        }
        return this.dispatchLockObject;
    }

    @Override
    public void decrementDispatchQueueRefCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"decrementDispatchQueueRefCount");
        }
        --this.dispatchQueueReferenceCount;
        if (this.dispatchQueueReferenceCount < 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("dispatchQueueReferneceCount=" + this.dispatchQueueReferenceCount));
            }
            throw new SIErrorException(nls.getFormattedMessage("CONVERSATIONIMPL_INTERNAL_SICJ0046", null, "CONVERSATIONIMPL_INTERNAL_SICJ0046"));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("dispatchQueueReferenceCount = " + Integer.valueOf(this.dispatchQueueReferenceCount)));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"decrementDispatchQueueRefCount");
        }
    }

    @Override
    public int getDispatchQueueRefCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDispatchQueueRefCount");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDispatchQueueRefCount", (Object)("" + this.dispatchQueueReferenceCount));
        }
        return this.dispatchQueueReferenceCount;
    }

    @Override
    public void setDispatchQueue(DispatchQueue o) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setDispatchQueue", (Object)o);
        }
        this.dispatchQueue = o;
        this.dispatchQueueReferenceCount = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setDispatchQueue");
        }
    }

    @Override
    public DispatchQueue getDispatchQueue() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getDispatchQueue");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getDispatchQueue", (Object)this.dispatchQueue);
        }
        return this.dispatchQueue;
    }

    @Override
    public void incrementDispatchQueueRefCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"incrementDispatchQueueRefCount");
        }
        ++this.dispatchQueueReferenceCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("dispatchQueueReferenceCount = " + Integer.valueOf(this.dispatchQueueReferenceCount)));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"incrementDispatchQueueRefCount");
        }
    }

    public int getInstanceCounterValue() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getInstanceCounterValue");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getInstanceCounterValue", (Object)("" + this.thisInstanceCounter));
        }
        return this.thisInstanceCounter;
    }

    protected void processLogicalClose(WsByteBuffer data) {
        boolean closeImmediately;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processLogicalClose", (Object)data);
        }
        data.flip();
        byte flagByte = data.get();
        boolean bl = closeImmediately = (flagByte & 1) != 0;
        if ((flagByte & 0xFE) != 0 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Bad flags", (Object)("" + flagByte));
        }
        if (closeImmediately) {
            this.processLogicalCloseResponse();
        } else {
            this.processLogicalCloseRequest();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processLogicalClose");
        }
    }

    protected void processPing(int requestNumber, int priority, WsByteBuffer data) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processPing", (Object)new Object[]{requestNumber, priority, data});
        }
        long pingTime = data.getLong();
        int dataLength = data.getInt();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("ping time=" + pingTime + " ping length=" + dataLength));
        }
        int currentLimit = data.limit();
        data.limit(data.position() + dataLength);
        data.position(data.limit());
        InternalJFapByteBuffer buffer = new InternalJFapByteBuffer(data);
        try {
            this.connection.send(buffer, 15, this.id, requestNumber, priority, true, false, Conversation.ThrottlingPolicy.DO_NOT_THROTTLE, null, this, false);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.jfapchannel.impl.ConversationImpl", (String)"00070010", (Object)this.eventRecorder.toString());
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)tc, (Exception)((Object)e));
            }
            this.connection.invalidate(true, e, "SIException thrown from system send");
        }
        data.limit(currentLimit);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processPing");
        }
    }

    protected void processPingResponse(WsByteBuffer data) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"processPingResponse", (Object)data);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            long currentTime = System.currentTimeMillis();
            long pingTime = data.getLong();
            int dataLength = data.getInt();
            StringBuffer sb = new StringBuffer("receieved ping response - which should not have originated from me:\n");
            sb.append("ping time: ");
            sb.append(pingTime);
            sb.append("\nping data length: ");
            sb.append(dataLength);
            if (currentTime > pingTime) {
                sb.append("\nround trip time: ");
                sb.append(currentTime - pingTime);
            } else {
                sb.append("\nping time incorrect, current system time is: ");
                sb.append(currentTime);
            }
            sb.append("\ndump of ping data follows:");
            SibTr.debug((Object)this, (TraceComponent)tc, (String)sb.toString());
            JFapUtils.debugTraceWsByteBuffer(this, tc, data, dataLength, "Ping data");
        }
        data.release();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"processPingResponse");
        }
    }

    @Override
    public void setMaxTransmissionSize(int maxTransmissionSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setMaxTransmissionSize", (Object)("" + maxTransmissionSize));
        }
        this.connection.setMaxTransmissionSize(maxTransmissionSize);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setMaxTransmissionSize");
        }
    }

    @Override
    public int getMaxTransmissionSize() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMaxTransmissionSize");
        }
        int value = this.connection.getMaxTransmissionSize();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMaxTransmissionSize", (Object)("" + value));
        }
        return value;
    }

    public void setOnClientSide() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setOnClientSide");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setOnClientSide");
        }
        this.onClientSide = true;
    }

    public boolean isOnClientSide() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isOnClientSide");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isOnClientSide", (Object)("" + this.onClientSide));
        }
        return this.onClientSide;
    }

    public Object getTotalOutstandingRequestCountLock() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTotalOutstandingRequestCountLock");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTotalOutstandingRequestCountLock", (Object)("" + this.totalOutstandingRequestsLock));
        }
        return this.totalOutstandingRequestsLock;
    }

    public int getTotalOutstandingRequestCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getTotalOutstandingRequestCount");
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getTotalOutstandingRequestCount", (Object)("" + this.totalOutstandingRequests));
        }
        return this.totalOutstandingRequests;
    }

    public void incrementTotalOutstandingCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"incrementTotalOutstandingCount");
        }
        ++this.totalOutstandingRequests;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("totalOutstandingRequests = " + Integer.valueOf(this.totalOutstandingRequests)));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"incrementTotalOutstandingCount");
        }
    }

    public void decrementTotalOutstandingCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"decrementTotalOutstandingCount");
        }
        --this.totalOutstandingRequests;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)("totalOutstandingRequests = " + Integer.valueOf(this.totalOutstandingRequests)));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"decrementTotalOutstandingCount");
        }
    }

    public void setErrorOccurredInvocation(AbstractInvocation error) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setErrorOccurredInvocation", (Object)error);
        }
        if (this.errorOccurredInvocation == null) {
            this.errorOccurredInvocation = error;
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Already received an errorOccurred", (Object)error);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setErrorOccurredInvocation");
        }
    }

    public AbstractInvocation getErrorOccurredInvocation() {
        return this.errorOccurredInvocation;
    }

    @Override
    public ConversationMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData");
        }
        ConversationMetaData retValue = this.connection.getMetaData();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)retValue);
        }
        return retValue;
    }

    @Override
    public void setConversationType(Conversation.ConversationType type) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setConversationType", (Object)type);
        }
        this.connection.setConversationType(type);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setConversationType");
        }
    }

    public Conversation.ConversationType getConversationType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConversationType");
        }
        Conversation.ConversationType retType = this.connection.getConversationType();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConversationType", (Object)retType);
        }
        return retType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"isClosed");
        }
        boolean ret = false;
        Object object = this.stateChangeMonitor;
        synchronized (object) {
            ret = this.state != OPEN;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"isClosed", (Object)("" + ret));
        }
        return ret;
    }

    @Override
    public void addConnectionClosedListener(ConnectionClosedListener listener, ConversationUsageType usageType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addConnectionClosedListener", (Object)new Object[]{listener, usageType});
        }
        this.connection.addConnectionClosedListener(listener, usageType);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"addConnectionClosedListener");
        }
    }

    @Override
    public ConnectionClosedListener getConnectionClosedListener(ConversationUsageType usageType) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionClosedListener", (Object)((Object)usageType));
        }
        ConnectionClosedListener listener = this.connection.getConnectionClosedListener(usageType);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnectionClosedListener", (Object)listener);
        }
        return listener;
    }

    @Override
    public ConnectionInterface getConnectionReference() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getConnectionReference");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getConnectionReference", (Object)this.connection);
        }
        return this.connection;
    }

    protected void logDataReceivedEvent(int segmentType, int requestNumber) {
        this.eventRecorder.logDebug(" << Data rcvd: Segment " + segmentType + " (0x" + Integer.toHexString(segmentType) + "), Request No: " + requestNumber);
    }

    @Override
    public HandshakeProperties getHandshakeProperties() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getHandshakeProperties");
        }
        HandshakeProperties result = this.connection.getHandshakeProperties();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getHandshakeProperties", (Object)result);
        }
        return result;
    }

    @Override
    public void setHandshakeProperties(HandshakeProperties handshakeProperties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setHandshakeProperties", (Object)handshakeProperties);
        }
        this.connection.setHandshakeProperties(handshakeProperties);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setHandshakeProperties");
        }
    }

    @Override
    public void setSchemaSet(ConnectionSchemaSet schemaSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSchemaSet", (Object)schemaSet);
        }
        this.connection.setSchemaSet(schemaSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSchemaSet");
        }
    }

    @Override
    public ConnectionSchemaSet getSchemaSet() throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSchemaSet");
        }
        ConnectionSchemaSet result = this.connection.getSchemaSet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSchemaSet", (Object)result);
        }
        return result;
    }

    @Override
    public boolean checkRequestNumberIsFree(int requestNumber) {
        boolean retVal;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"checkRequestNumberIsFree", (Object)new Integer(requestNumber));
        }
        boolean bl = retVal = !this.reqIdTable.containsId(requestNumber);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"checkRequestNumberIsFree", (Object)new Boolean(retVal));
        }
        return retVal;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source Info: @(#) 1.105 SIB/ws/code/sib.jfapchannel.client.common.impl/src/com/ibm/ws/sib/jfapchannel/impl/ConversationImpl.java, SIB.comms, WASX.SIB, uu1215.01 10/05/28 04:39:10 [4/12/12 22:14:14]");
        }
        instanceCounter = 0;
        OPEN = new StateEnum("open");
        NOTIFY_PEER = new StateEnum("notify peer");
        AWAITING_PEER1 = new StateEnum("awaiting peer 1");
        PARALLEL_CLOSE1 = new StateEnum("parallel close 1");
        AWAITING_PEER2 = new StateEnum("awaiting peer 2");
        PARALLEL_CLOSE2 = new StateEnum("parallel close 2");
        AWAITING_PEER3 = new StateEnum("awaiting peer 3");
        CLOSED = new StateEnum("closed");
    }

    private class LogicalCloseSendListener
    implements SendListener {
        private LogicalCloseSendListener() {
        }

        @Override
        public void dataSent(Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dataSent", (Object)conversation);
            }
            ConversationImpl.this.eventRecorder.logEntry("LogicalCloseSendListener.dataSent");
            ConversationImpl.this.eventRecorder.logDebug("LogicalCloseSendListener hashcode: " + Integer.toHexString(System.identityHashCode(this)));
            ConversationImpl.this.sendCompletes();
            ConversationImpl.this.eventRecorder.logExit("LogicalCloseSendListener.dataSent");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"dataSent");
            }
        }

        @Override
        public void errorOccurred(SIConnectionLostException exception, Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"errorOccurred", (Object)new Object[]{exception, conversation});
            }
            ConversationImpl.this.eventRecorder.logEntry("LogicalCloseSendListener.errorOccurred");
            ConversationImpl.this.eventRecorder.logDebug("LogicalCloseSendListener hashcode: " + Integer.toHexString(System.identityHashCode(this)));
            ConversationImpl.this.sendCompletes();
            ConversationImpl.this.eventRecorder.logExit("LogicalCloseSendListener.errorOccurred");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"errorOccurred");
            }
        }
    }

    private static class StateEnum {
        private String toStringName;

        private StateEnum(String toStringName) {
            this.toStringName = "STATE: " + toStringName;
        }

        public String toString() {
            return this.toStringName;
        }
    }
}

