/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.ClientComponentHandshake;
import com.ibm.ws.sib.comms.ClientConnection;
import com.ibm.ws.sib.comms.CommsConnection;
import com.ibm.ws.sib.comms.CompHandshake;
import com.ibm.ws.sib.comms.ConnectionMetaData;
import com.ibm.ws.sib.comms.ConnectionProperties;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ClientJFapCommunicator;
import com.ibm.ws.sib.comms.client.ConnectionMetaDataImpl;
import com.ibm.ws.sib.comms.client.ProxyReceiveListener;
import com.ibm.ws.sib.comms.common.CommsByteBuffer;
import com.ibm.ws.sib.comms.common.CommsDiagnosticModule;
import com.ibm.ws.sib.jfapchannel.ClientConnectionManager;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.mfp.ConnectionSchemaSet;
import com.ibm.ws.sib.mfp.impl.CompHandshakeFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

public class ClientSideConnection
extends ClientJFapCommunicator
implements ClientConnection,
ConnectionClosedListener {
    private static String CLASS_NAME = ClientSideConnection.class.getName();
    private static final TraceComponent tc = SibTr.register(ClientSideConnection.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.comms.CWSICMessages");
    private String connectionInfo = "Unknown";

    public void connect(ConnectionProperties cp, ClientComponentHandshake cch) throws SIResourceException, SIAuthenticationException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connect", (Object)new Object[]{cp, cch});
        }
        ClientConnectionManager conMan = null;
        if (cp == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("NULL_CONNECTION_PROPERTIES_SICO1039", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".connect"), (String)"1-001-0004", (Object)this);
            throw e;
        }
        if (cch == null) {
            SIErrorException e = new SIErrorException(nls.getFormattedMessage("NULL_CCH_SICO1040", null, null));
            FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".connect"), (String)"1-001-0005", (Object)this);
            throw e;
        }
        Conversation con = null;
        boolean handshakeCompletedOk = false;
        try {
            ClientConnectionManager.initialise();
            conMan = ClientConnectionManager.getRef();
            if (cp.getMode() == ConnectionProperties.PropertiesType.HOST_PORT) {
                final String host = cp.getEndPoint().getHost();
                final int port = cp.getEndPoint().getPort();
                String chainName = cp.getChainName();
                this.connectionInfo = host + ":" + port + " - " + chainName;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Connecting to: " + this.connectionInfo));
                }
                InetSocketAddress addr = AccessController.doPrivileged(new PrivilegedAction<InetSocketAddress>(){

                    @Override
                    public InetSocketAddress run() {
                        return new InetSocketAddress(host, port);
                    }
                });
                con = conMan.connect(addr, new ProxyReceiveListener(), chainName);
            } else if (cp.getMode() == ConnectionProperties.PropertiesType.WLM_EP) {
                Object wlmEndpointData = cp.getWLMEndPointData();
                this.connectionInfo = wlmEndpointData.toString();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Connecting to: " + this.connectionInfo));
                }
                con = conMan.connect(wlmEndpointData, new ProxyReceiveListener());
            } else {
                this.connectionInfo = "tcp bridge service";
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)("Connecting via: " + this.connectionInfo));
                }
                con = conMan.connect(new ProxyReceiveListener(), ConversationUsageType.JFAP);
            }
            this.setConversation(con);
            this.createConversationState();
            this.setCommsConnection((CommsConnection)this);
            Map trmProperties = cp.getClientConnectionPropertyMap();
            if (trmProperties != null) {
                String subProtocol;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Client properties: ", (Object)trmProperties);
                }
                if ((subProtocol = (String)trmProperties.get("subscriptionProtocol")) != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Subscription protocol:", (Object)subProtocol);
                    }
                    if (subProtocol.equals("Multicast")) {
                        throw new SIErrorException("This shouldn't happen!");
                    }
                }
            }
            if (con.isFirst()) {
                con.addConnectionClosedListener(this, ConversationUsageType.JFAP);
                this.initiateCommsHandshaking();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Comms handshake completed successfully");
                }
                short productVersion = this.getConversation().getHandshakeProperties().getMajorVersion();
                try {
                    CompHandshake ch = (CompHandshake)CompHandshakeFactory.getInstance();
                    ch.compStartHandshake((CommsConnection)this, (int)productVersion);
                }
                catch (Exception e1) {
                    FFDCFilter.processException((Throwable)e1, (String)(CLASS_NAME + ".connect"), (String)"1-001-0003", (Object)this);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"MFP unable to create CompHandshake Singleton", (Object)e1);
                    }
                    String message = nls.getFormattedMessage("MFP_HANDSHAKE_FAILED_SICO1005", new Object[]{e1}, null);
                    SIResourceException ce = new SIResourceException(message, (Throwable)e1);
                    throw ce;
                }
            }
            if (!cch.connect((ClientConnection)this)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"TRM connection returned false - connection will be aborted");
                }
                SIResourceException e = new SIResourceException(nls.getFormattedMessage("TRM_HANDSHAKE_FAILED_SICO1037", null, null));
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".connect"), (String)"1-001-0006", (Object)this);
                throw e;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"TRM handshake completed successfully");
            }
            handshakeCompletedOk = true;
        }
        catch (SIException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to make initial connection", (Object)((Object)e));
            }
            SIResourceException ce = new SIResourceException(nls.getFormattedMessage("CONNECT_FAILED_SICO1001", new Object[]{e}, null));
            ce.initCause((Throwable)e);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect", (Object)ce);
            }
            throw ce;
        }
        finally {
            if (con != null) {
                if (handshakeCompletedOk) {
                    con.handshakeComplete();
                } else {
                    block41: {
                        if (con != null) {
                            con.handshakeFailed();
                        }
                        try {
                            if (con != null) {
                                con.close();
                            }
                        }
                        catch (SIException e2) {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block41;
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)("Failed to close connection: " + (Object)((Object)e2)));
                        }
                    }
                    con = null;
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connect");
        }
    }

    public String getConnectionInfo() {
        return this.connectionInfo;
    }

    @Override
    public void setSICoreConnection(SICoreConnection conn) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSICoreConnection", (Object)conn);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSICoreConnection");
        }
        SIErrorException e = new SIErrorException(nls.getFormattedMessage("METHOD_CALL_NOT_ALLOWED_SICO8003", new Object[]{"setSICoreConnection"}, null));
        FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".setSICoreConnection"), (String)"1-001-0009", (Object)this);
        throw e;
    }

    public SICoreConnection getSICoreConnection() throws SIConnectionLostException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSICoreConnection");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Building connection proxy object using ID: ", (Object)("" + this.getConnectionObjectID()));
        }
        ClientConversationState convState = (ClientConversationState)this.getConversation().getAttachment();
        SICoreConnection siConn = convState.getSICoreConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSICoreConnection", (Object)siConn);
        }
        return siConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] trmHandshakeExchange(byte[] trmData) throws SIConnectionLostException, SIConnectionDroppedException, SIConnectionUnavailableException {
        byte[] trmReplyData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"trmHandshakeExchange");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])trmData);
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.wrap(trmData);
        CommsByteBuffer reply = this.jfapExchange(request, 8, 7, true);
        try {
            short err = reply.getCommandCompletionCode(8);
            if (err != 0) {
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
            trmReplyData = reply.getRemaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])trmReplyData);
            }
        }
        finally {
            if (reply != null) {
                reply.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"trmHandshakeExchange");
        }
        return trmReplyData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] mfpHandshakeExchange(byte[] mfpData) throws SIConnectionLostException, SIConnectionDroppedException, SIConnectionUnavailableException {
        byte[] mfpReplyData;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"mfpHandshakeExchange");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])mfpData);
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.wrap(mfpData);
        CommsByteBuffer reply = this.jfapExchange(request, 9, 7, true);
        try {
            short err = reply.getCommandCompletionCode(9);
            if (err != 0) {
                this.checkFor_SIConnectionLostException(reply, err);
                this.checkFor_SIConnectionDroppedException(reply, err);
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
            mfpReplyData = reply.getRemaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])mfpReplyData);
            }
        }
        finally {
            if (reply != null) {
                reply.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"mfpHandshakeExchange");
        }
        return mfpReplyData;
    }

    public void sendMFPSchema(byte[] schemaData) throws SIConnectionLostException, SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"sendMFPSchema");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])schemaData);
        }
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.wrap(schemaData);
        this.jfapSend(request, 230, 12, true, Conversation.ThrottlingPolicy.BLOCK_THREAD);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"sendMFPSchema");
        }
    }

    public void close() {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"close");
            }
            try {
                Conversation conv = this.getConversation();
                if (conv != null) {
                    conv.close();
                }
            }
            catch (SIConnectionLostException e) {
                FFDCFilter.processException((Throwable)e, (String)(CLASS_NAME + ".close"), (String)"1-001-0002", (Object)this);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to close connection", (Object)((Object)e));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"close");
        }
    }

    public ConnectionMetaData getMetaData() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getMetaData");
        }
        ConnectionMetaDataImpl meta = new ConnectionMetaDataImpl(this.getConversation().getMetaData(), this.getConversation().getHandshakeProperties());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getMetaData", (Object)meta);
        }
        return meta;
    }

    public String toString() {
        return "ClientSideConnection@" + Integer.toHexString(System.identityHashCode(this)) + ": " + this.connectionInfo;
    }

    @Override
    public void connectionClosed(Object linkLevelAttachement) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"connectionClosed", (Object)linkLevelAttachement);
            }
            try {
                CompHandshake ch = (CompHandshake)CompHandshakeFactory.getInstance();
                ch.compClose((CommsConnection)this);
            }
            catch (Exception e1) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"MFP unable to create CompHandshake Singleton", (Object)e1);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connectionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] requestMFPSchemata(byte[] schemaData) throws SIConnectionLostException, SIConnectionDroppedException, SIConnectionUnavailableException, SIErrorException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"requestMFPSchemata");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])schemaData);
        }
        byte[] returnSchemaData = null;
        CommsByteBuffer request = this.getCommsByteBuffer();
        request.wrap(schemaData);
        CommsByteBuffer reply = this.jfapExchange(request, 110, 12, true);
        try {
            short err = reply.getCommandCompletionCode(240);
            if (err != 0) {
                this.checkFor_SIConnectionUnavailableException(reply, err);
                this.checkFor_SIErrorException(reply, err);
                this.defaultChecker(reply, err);
            }
            returnSchemaData = reply.getRemaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.bytes((Object)this, (TraceComponent)tc, (byte[])returnSchemaData);
            }
        }
        finally {
            if (reply != null) {
                reply.release();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"requestMFPSchemata", (Object)returnSchemaData);
        }
        return returnSchemaData;
    }

    public void setSchemaSet(ConnectionSchemaSet schemaSet) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setSchemaSet", (Object)schemaSet);
        }
        this.getConversation().setSchemaSet(schemaSet);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"setSchemaSet");
        }
    }

    public ConnectionSchemaSet getSchemaSet() throws SIConnectionDroppedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getSchemaSet");
        }
        ConnectionSchemaSet result = this.getConversation().getSchemaSet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getSchemaSet", (Object)result);
        }
        return result;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/ClientSideConnection.java, SIB.comms, WASX.SIB, uu1215.01 1.104");
        }
        CommsDiagnosticModule.initialise();
    }
}

