/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.client.ClientConversationState;
import com.ibm.ws.sib.comms.client.ConnectionProxy;
import com.ibm.ws.sib.comms.client.ConsumerSessionProxy;
import com.ibm.ws.sib.comms.client.proxyqueue.AsynchConsumerProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueue;
import com.ibm.ws.sib.comms.client.proxyqueue.ProxyQueueConversationGroup;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.framework.Framework;
import com.ibm.ws.sib.jfapchannel.threadpool.ThreadPool;
import com.ibm.ws.sib.utils.RuntimeInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.ConsumerSetChangeCallback;
import com.ibm.wsspi.sib.core.DestinationAvailability;
import com.ibm.wsspi.sib.core.DestinationListener;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;

public class ClientAsynchEventThreadPool {
    private static String CLASS_NAME;
    private static final TraceComponent tc;
    private static ClientAsynchEventThreadPool instance;
    private ThreadPool threadPool = null;
    private static final int DEFAULT_CLIENT_ASYNCH_EVENT_THREADPOOL_MAX_SIZE = 10;
    private static int CLIENT_ASYNCH_EVENT_THREADPOOL_MAX_SIZE;
    public static final String CLIENT_ASYNCH_EVENT_THREADPOOL_MAX_SIZE_PROPERTY = "com.ibm.ws.sib.comms.client.ClientAsynchEventThreadPoolMaxSize";

    public static ClientAsynchEventThreadPool getInstance() {
        if (instance == null) {
            instance = new ClientAsynchEventThreadPool();
        }
        return instance;
    }

    private ClientAsynchEventThreadPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        this.threadPool = Framework.getInstance().getThreadPool("ClientAsynchEventThread", 1, CLIENT_ASYNCH_EVENT_THREADPOOL_MAX_SIZE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    public void dispatchAsynchException(ProxyQueue proxyQueue, Exception exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dispatchAsynchException", (Object)new Object[]{proxyQueue, exception});
        }
        AsynchExceptionThread thread = new AsynchExceptionThread(proxyQueue, exception);
        this.dispatchThread(thread);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dispatchAsynchException");
        }
    }

    public void dispatchAsynchEvent(short eventId, Conversation conversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchAsynchEvent", (Object)new Object[]{"" + eventId, conversation});
        }
        AsynchEventThread thread = new AsynchEventThread(eventId, conversation);
        this.dispatchThread(thread);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchAsynchEvent");
        }
    }

    public void dispatchCommsException(SICoreConnection conn, ProxyQueueConversationGroup proxyQueueConversationGroup, SIConnectionLostException exception) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchCommsException");
        }
        CommsExceptionThread thread = new CommsExceptionThread(conn, proxyQueueConversationGroup, exception);
        this.dispatchThread(thread);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchCommsException");
        }
    }

    public void dispatchDestinationListenerEvent(SICoreConnection conn, SIDestinationAddress destinationAddress, DestinationAvailability destinationAvailability, DestinationListener destinationListener) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchDestinationListenerEvent", (Object)new Object[]{conn, destinationAddress, destinationAvailability, destinationListener});
        }
        DestinationListenerThread thread = new DestinationListenerThread(conn, destinationAddress, destinationAvailability, destinationListener);
        this.dispatchThread(thread);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchDestinationListenerEvent");
        }
    }

    public void dispatchConsumerSetChangeCallbackEvent(ConsumerSetChangeCallback consumerSetChangeCallback, boolean isEmpty) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchConsumerSetChangeCallbackEvent", (Object)new Object[]{consumerSetChangeCallback, isEmpty});
        }
        ConsumerSetChangeCallbackThread thread = new ConsumerSetChangeCallbackThread(consumerSetChangeCallback, isEmpty);
        this.dispatchThread(thread);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchConsumerSetChangeCallbackEvent");
        }
    }

    public void dispatchStoppableConsumerSessionStopped(ConsumerSessionProxy consumerSessionProxy) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchStoppableConsumerSessionStopped", (Object)consumerSessionProxy);
        }
        StoppableAsynchConsumerCallbackThread thread = new StoppableAsynchConsumerCallbackThread(consumerSessionProxy);
        this.dispatchThread(thread);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchStoppableConsumerSessionStopped");
        }
    }

    private void dispatchThread(Runnable runnable) {
        block4: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"dispatchThread");
            }
            try {
                this.threadPool.execute(runnable);
            }
            catch (InterruptedException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                SibTr.debug((TraceComponent)tc, (String)"Thread was interrupted", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"dispatchThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void invokeCallback(SICoreConnection conn, ConsumerSession session, Exception exception, int eventId) {
        block18: {
            if (TraceComponent.isAnyTracingEnabled() && ClientAsynchEventThreadPool.tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)ClientAsynchEventThreadPool.tc, (String)"invokeCallback", (Object)new Object[]{conn, session, exception, eventId});
            }
            if (conn != null) {
                try {
                    asyncCallbackSynchronizer = ((ConnectionProxy)conn).getAsyncCallbackSynchronizer();
                    myListeners = conn.getConnectionListeners();
                    block13: for (x = 0; x < myListeners.length; ++x) {
                        if (TraceComponent.isAnyTracingEnabled() && ClientAsynchEventThreadPool.tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)ClientAsynchEventThreadPool.tc, (String)("Invoking callback on: " + myListeners[x]));
                        }
                        asyncCallbackSynchronizer.enterAsyncExceptionCallback();
                        try {
                            switch (eventId) {
                                case 0: {
                                    myListeners[x].commsFailure(conn, (SIConnectionLostException)exception);
                                    ** break;
lbl16:
                                    // 1 sources

                                    continue block13;
                                }
                                case 2: {
                                    myListeners[x].meQuiescing(conn);
                                    ** break;
lbl20:
                                    // 1 sources

                                    continue block13;
                                }
                                case 3: {
                                    myListeners[x].meTerminated(conn);
                                    ** break;
lbl24:
                                    // 1 sources

                                    continue block13;
                                }
                                case 4: {
                                    myListeners[x].asynchronousException(session, (Throwable)exception);
                                    ** break;
lbl28:
                                    // 1 sources

                                    continue block13;
                                }
                                default: {
                                    if (!TraceComponent.isAnyTracingEnabled() || !ClientAsynchEventThreadPool.tc.isDebugEnabled()) continue block13;
                                    SibTr.debug((TraceComponent)ClientAsynchEventThreadPool.tc, (String)("Invalid event ID: " + eventId));
                                    continue block13;
                                }
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)(ClientAsynchEventThreadPool.CLASS_NAME + ".invokeCallback"), (String)"1-015-00001", (Object[])new Object[]{myListeners[x], conn, session, exception, "" + eventId});
                            if (!TraceComponent.isAnyTracingEnabled() || !ClientAsynchEventThreadPool.tc.isDebugEnabled()) continue;
                            SibTr.debug((TraceComponent)ClientAsynchEventThreadPool.tc, (String)"Caught an exception from the callback", (Object)e);
                            continue;
                        }
                        finally {
                            asyncCallbackSynchronizer.exitAsyncExceptionCallback();
                        }
                    }
                }
                catch (SIException e) {
                    if (!TraceComponent.isAnyTracingEnabled() || !ClientAsynchEventThreadPool.tc.isDebugEnabled()) break block18;
                    SibTr.debug((TraceComponent)ClientAsynchEventThreadPool.tc, (String)"Unable to get connection listeners", (Object)e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && ClientAsynchEventThreadPool.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)ClientAsynchEventThreadPool.tc, (String)"invokeCallback");
        }
    }

    static {
        block3: {
            CLASS_NAME = ClientAsynchEventThreadPool.class.getName();
            tc = SibTr.register(ClientAsynchEventThreadPool.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
            instance = null;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"@(#) SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/ClientAsynchEventThreadPool.java, SIB.comms, WASX.SIB, uu1215.01 1.23");
            }
            try {
                CLIENT_ASYNCH_EVENT_THREADPOOL_MAX_SIZE = Integer.parseInt(RuntimeInfo.getProperty((String)CLIENT_ASYNCH_EVENT_THREADPOOL_MAX_SIZE_PROPERTY, (String)"10"));
            }
            catch (NumberFormatException nfe) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                SibTr.debug((TraceComponent)tc, (String)"NumberFormatException was thrown for custom property com.ibm.ws.sib.comms.client.ClientAsynchEventThreadPoolMaxSize");
            }
        }
    }

    private static class StoppableAsynchConsumerCallbackThread
    implements Runnable {
        private final ConsumerSessionProxy consumerSessionProxy;

        public StoppableAsynchConsumerCallbackThread(ConsumerSessionProxy consumerSessionProxy) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"StoppableAsynchConsumerCallbackThread.<init>", (Object)consumerSessionProxy);
            }
            this.consumerSessionProxy = consumerSessionProxy;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"StoppableAsynchConsumerCallbackThread.<init>");
            }
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
            }
            this.consumerSessionProxy.stoppableConsumerSessionStopped();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
            }
        }
    }

    private static class ConsumerSetChangeCallbackThread
    implements Runnable {
        private final ConsumerSetChangeCallback consumerSetChangeCallback;
        private final boolean isEmpty;

        public ConsumerSetChangeCallbackThread(ConsumerSetChangeCallback consumerSetChangeCallback, boolean isEmpty) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"ConsumerSetChangeCallbackThread.<init>", (Object)new Object[]{consumerSetChangeCallback, isEmpty});
            }
            this.consumerSetChangeCallback = consumerSetChangeCallback;
            this.isEmpty = isEmpty;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"ConsumerSetChangeCallbackThread.<init>");
            }
        }

        @Override
        public void run() {
            block4: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
                }
                try {
                    this.consumerSetChangeCallback.consumerSetChange(this.isEmpty);
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"ConsumerSetChangeCallbackThread.run", (String)"1-018-00001", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught exception when calling consumerSetChange.", (Object)e);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
            }
        }
    }

    private static class DestinationListenerThread
    implements Runnable {
        private final SICoreConnection conn;
        private final SIDestinationAddress destinationAddress;
        private final DestinationAvailability destinationAvailability;
        private final DestinationListener destinationListener;

        public DestinationListenerThread(SICoreConnection conn, SIDestinationAddress destinationAddress, DestinationAvailability destinationAvailability, DestinationListener destinationListener) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"DestinationListenerThread.<init>", (Object)new Object[]{conn, destinationAddress, destinationAvailability, destinationListener});
            }
            this.conn = conn;
            this.destinationAddress = destinationAddress;
            this.destinationAvailability = destinationAvailability;
            this.destinationListener = destinationListener;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"DestinationListenerThread.<init>");
            }
        }

        @Override
        public void run() {
            block4: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
                }
                try {
                    this.destinationListener.destinationAvailable(this.conn, this.destinationAddress, this.destinationAvailability);
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"DestinationListenerThread.run", (String)"1-015-00002", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught exception when calling destinationAvailable.", (Object)e);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
            }
        }
    }

    private static class CommsExceptionThread
    implements Runnable {
        private SICoreConnection conn = null;
        private SIConnectionLostException exception = null;
        private final ProxyQueueConversationGroup proxyQueueConversationGroup;

        public CommsExceptionThread(SICoreConnection conn, ProxyQueueConversationGroup proxyQueueConversationGroup, SIConnectionLostException exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{conn, proxyQueueConversationGroup, exception});
            }
            this.conn = conn;
            this.proxyQueueConversationGroup = proxyQueueConversationGroup;
            this.exception = exception;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
            }
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
            }
            ClientAsynchEventThreadPool.invokeCallback(this.conn, null, (Exception)this.exception, 0);
            if (this.proxyQueueConversationGroup != null) {
                this.proxyQueueConversationGroup.conversationDroppedNotification();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
            }
        }
    }

    private static class AsynchExceptionThread
    implements Runnable {
        private ProxyQueue proxyQueue = null;
        private Exception exception = null;

        public AsynchExceptionThread(ProxyQueue proxyQueue, Exception exception) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{proxyQueue, exception});
            }
            this.proxyQueue = proxyQueue;
            this.exception = exception;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
            }
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
            }
            if (this.proxyQueue instanceof AsynchConsumerProxyQueue) {
                ((AsynchConsumerProxyQueue)this.proxyQueue).deliverException(this.exception);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Unable to deliver exception to proxy queue of type: ", (Object)this.proxyQueue);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
            }
        }
    }

    private static class AsynchEventThread
    extends Thread {
        private short eventId = 0;
        private Conversation conversation = null;

        public AsynchEventThread(short eventId, Conversation conversation) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object)new Object[]{"" + eventId, conversation});
            }
            this.eventId = eventId;
            this.conversation = conversation;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
            }
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)tc, (String)"run");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"First, invoking on our conversation ", (Object)this.conversation);
            }
            ClientConversationState convState = (ClientConversationState)this.conversation.getAttachment();
            SICoreConnection conn = convState.getSICoreConnection();
            String thisMeUuid = conn.getMeUuid();
            ClientAsynchEventThreadPool.invokeCallback(conn, null, null, this.eventId);
            Conversation[] convsOnThisLink = this.conversation.getConversationsSharingSameLink();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Processing " + convsOnThisLink.length + " conversation(s) on the same socket link"));
            }
            for (int x = 0; x < convsOnThisLink.length; ++x) {
                if (convsOnThisLink[x] != this.conversation) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("Processing conversation " + convsOnThisLink[x]));
                    }
                    if ((convState = (ClientConversationState)convsOnThisLink[x].getAttachment()) != null) {
                        conn = convState.getSICoreConnection();
                        if (conn != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                SibTr.debug((Object)this, (TraceComponent)tc, (String)("Processing core connection " + conn));
                            }
                            if (conn.getMeUuid().equals(thisMeUuid)) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Invoking callback on this core connection");
                                }
                                ClientAsynchEventThreadPool.invokeCallback(conn, null, null, this.eventId);
                                continue;
                            }
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"ME uuid does not match our ME uuid - skipping");
                            continue;
                        }
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"SICoreConnection was null - skipping");
                        continue;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Conversation state was null - skipping");
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                SibTr.debug((Object)this, (TraceComponent)tc, (String)"Found our own conversation - skipping");
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)tc, (String)"run");
            }
        }
    }
}

