/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.monitor;

import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.jaxrs.monitor.JaxRsMonitorFilter;
import com.ibm.ws.jaxrs20.providers.api.JaxRsProviderRegister;
import java.util.List;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@Component(immediate=true, property={"service.vendor=IBM"}, configurationPolicy=ConfigurationPolicy.IGNORE, service={JaxRsProviderRegister.class, ApplicationStateListener.class})
public class JaxRsMonitorProviderRegister
implements JaxRsProviderRegister,
ApplicationStateListener {
    private JaxRsMonitorFilter monitorFilter = new JaxRsMonitorFilter();

    public void installProvider(boolean clientSide, List<Object> providers, Set<String> features) {
        if (!clientSide) {
            providers.add(this.monitorFilter);
        }
    }

    public void applicationStarting(ApplicationInfo appInfo) {
        String appName = appInfo.getDeploymentName();
        JaxRsMonitorFilter.RestMetricInfo metricInfo = this.monitorFilter.getMetricInfo(appName);
        if (appInfo.getClass().getName().endsWith("EARApplicationInfoImpl")) {
            metricInfo.setIsEar();
        }
    }

    public void applicationStarted(ApplicationInfo appInfo) {
    }

    public void applicationStopping(ApplicationInfo appInfo) {
    }

    public void applicationStopped(ApplicationInfo appInfo) {
        this.monitorFilter.cleanApplication(appInfo.getDeploymentName());
    }
}

