/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cdi.mp.context;

import com.ibm.websphere.ras.annotation.Trivial;
import java.util.Collection;
import java.util.Collections;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import org.jboss.weld.context.WeldAlterableContext;
import org.jboss.weld.context.api.ContextualInstance;
import org.jboss.weld.manager.api.WeldManager;

@Trivial
public class ContextualInstanceSnapshot {
    public static final ContextualInstanceSnapshot EMPTY_SNAPSHOT = new ContextualInstanceSnapshot();
    public final WeldAlterableContext reqCtx;
    public final WeldAlterableContext sesCtx;
    public final WeldAlterableContext conCtx;
    public final Collection<ContextualInstance<?>> reqInstances;
    public final Collection<ContextualInstance<?>> sesInstances;
    public final Collection<ContextualInstance<?>> conInstances;

    private ContextualInstanceSnapshot() {
        this.conInstances = Collections.emptySet();
        this.sesInstances = this.conInstances;
        this.reqInstances = this.conInstances;
        this.conCtx = null;
        this.sesCtx = null;
        this.reqCtx = null;
    }

    public ContextualInstanceSnapshot(WeldManager manager) {
        WeldAlterableContext reqContext = null;
        WeldAlterableContext sesContext = null;
        WeldAlterableContext conContext = null;
        Collection reqInstances = null;
        Collection sesInstances = null;
        Collection conInstances = null;
        for (WeldAlterableContext ctx : manager.getActiveWeldAlterableContexts()) {
            Class scope = ctx.getScope();
            if (scope == RequestScoped.class) {
                reqInstances = ctx.getAllContextualInstances();
                reqContext = ctx;
                continue;
            }
            if (scope == SessionScoped.class) {
                sesInstances = ctx.getAllContextualInstances();
                sesContext = ctx;
                continue;
            }
            if (scope != ConversationScoped.class) continue;
            conInstances = ctx.getAllContextualInstances();
            conContext = ctx;
        }
        this.reqCtx = reqContext;
        this.sesCtx = sesContext;
        this.conCtx = conContext;
        this.reqInstances = reqInstances == null ? Collections.emptySet() : reqInstances;
        this.sesInstances = sesInstances == null ? Collections.emptySet() : sesInstances;
        this.conInstances = conInstances == null ? Collections.emptySet() : conInstances;
    }

    public int getBeanCount() {
        return this.reqInstances.size() + this.sesInstances.size() + this.conInstances.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString()).append(" beanCount=" + this.getBeanCount()).append('\n').append("RequestScoped instances = ").append(this.reqInstances).append('\n').append("SessionScoped instances = ").append(this.reqInstances).append('\n').append("ConversationScoped instances = ").append(this.reqInstances);
        return sb.toString();
    }
}

