/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.Serializable;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ObjectWriter;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.apache.yoko.rmi.util.stub.Stub;

class RMIStubDescriptor
extends ValueDescriptor {
    RMIStubDescriptor(Class type, TypeRepository repository) {
        super(type, repository);
    }

    @Override
    protected String genRepId() {
        Class<?>[] ifaces = this.type.getInterfaces();
        if (ifaces.length != 2 || ifaces[1] != Stub.class) {
            throw new RuntimeException("Unexpected RMIStub structure");
        }
        String ifname = ifaces[0].getName();
        int idx = ifname.lastIndexOf(46);
        return idx < 0 ? String.format("RMI:_%s_Stub:0", ifname) : String.format("RMI:%s_%s_Stub:0", ifname.substring(0, idx + 1), ifname.substring(idx + 1));
    }

    @Override
    protected void writeValue(ObjectWriter writer, Serializable val) throws IOException {
        this._super_descriptor.writeValue(writer, val);
    }

    @Override
    protected void readValue(ObjectReader reader, Serializable value) throws IOException {
        this._super_descriptor.readValue(reader, value);
    }
}

