/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Map;
import org.apache.yoko.rmi.impl.ObjectReader;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.apache.yoko.rmi.util.PriorityQueue;

abstract class ObjectReaderBase
extends ObjectReader {
    int recursionDepth = 0;
    final Serializable object;
    PriorityQueue callbacks;
    private ValueDescriptor desc;
    private byte streamFormatVersion;

    ObjectReaderBase(Serializable obj) throws IOException {
        this.object = obj;
    }

    @Override
    final void setCurrentValueDescriptor(ValueDescriptor desc) {
        this.desc = desc;
    }

    @Override
    public final void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.desc == null) {
            throw new NotActiveException();
        }
        this.desc.defaultReadValue(this, this.object);
    }

    @Override
    protected final Object readObjectOverride() throws ClassNotFoundException, IOException {
        try {
            this.enterRecursion();
            Object object = this.readAbstractObject();
            return object;
        }
        finally {
            this.exitRecursion();
        }
    }

    private void enterRecursion() {
        ++this.recursionDepth;
    }

    private void exitRecursion() throws InvalidObjectException {
        --this.recursionDepth;
        if (this.recursionDepth == 0 && this.callbacks != null) {
            while (this.callbacks.size() != 0) {
                Validation val = (Validation)this.callbacks.dequeue();
                val.validate();
            }
        }
    }

    @Override
    public synchronized void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
        if (this.recursionDepth == 0) {
            throw new NotActiveException("readObject not Active");
        }
        if (obj == null) {
            throw new InvalidObjectException("Null is not a valid callback object");
        }
        Validation val = new Validation(obj, prio);
        if (this.callbacks == null) {
            this.callbacks = new PriorityQueue();
        }
        this.callbacks.enqueue(val);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ObjectInputStream.GetField readFields() throws IOException {
        if (this.desc == null) {
            throw new NotActiveException();
        }
        Map fieldMap = this.desc.readFields(this);
        return new GetFieldImpl(fieldMap);
    }

    @Override
    public void readFully(byte[] arr) throws IOException {
        this.readFully(arr, 0, arr.length);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        short val = this.readShort();
        return val & 0xFFFF;
    }

    @Override
    void readExternal(Externalizable ext) throws IOException, ClassNotFoundException {
        byte old = this.streamFormatVersion;
        try {
            this.streamFormatVersion = this.readByte();
            ext.readExternal(this);
        }
        finally {
            this.streamFormatVersion = old;
        }
    }

    static class GetFieldImpl
    extends ObjectInputStream.GetField {
        Map fieldMap;

        GetFieldImpl(Map map) {
            this.fieldMap = map;
        }

        @Override
        public boolean defaulted(String name) throws IOException {
            return !this.fieldMap.containsKey(name);
        }

        @Override
        public boolean get(String name, boolean val) throws IOException {
            Boolean value = (Boolean)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        @Override
        public byte get(String name, byte val) throws IOException {
            Byte value = (Byte)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        @Override
        public char get(String name, char val) throws IOException {
            Character value = (Character)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value.charValue();
        }

        @Override
        public double get(String name, double val) throws IOException {
            Double value = (Double)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        @Override
        public float get(String name, float val) throws IOException {
            Float value = (Float)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value.floatValue();
        }

        @Override
        public int get(String name, int val) throws IOException {
            Integer value = (Integer)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        @Override
        public long get(String name, long val) throws IOException {
            Long value = (Long)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        @Override
        public Object get(String name, Object val) throws IOException {
            Object value = this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        @Override
        public short get(String name, short val) throws IOException {
            Short value = (Short)this.fieldMap.get(name);
            if (this.defaulted(name)) {
                return val;
            }
            return value;
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return null;
        }
    }

    private class Validation
    implements Comparable<Validation> {
        ObjectInputValidation validator;
        int pri;

        Validation(ObjectInputValidation val, int pri) {
            this.validator = val;
            this.pri = pri;
        }

        @Override
        public int compareTo(Validation other) {
            return this.pri - other.pri;
        }

        void validate() throws InvalidObjectException {
            this.validator.validateObject();
        }
    }
}

