/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

class IOR {
    String type_id;
    TaggedProfile[] profiles;

    IOR() {
    }

    void read(InputStream in) {
        this.type_id = in.read_string();
        int len = in.read_ulong();
        this.profiles = new TaggedProfile[len];
        for (int i = 0; i < len; ++i) {
            this.profiles[i] = new TaggedProfile();
            this.profiles[i].read(in);
        }
    }

    void write(OutputStream out) {
        out.write_string(this.type_id);
        out.write_ulong(this.profiles.length);
        for (int i = 0; i < this.profiles.length; ++i) {
            this.profiles[i].write(out);
        }
    }

    void read(DataInput in) {
        try {
            int strlen = in.readInt();
            byte[] data = new byte[strlen];
            in.readFully(data, 0, strlen);
            this.type_id = new String(data, 0, strlen - 1, "ISO-8859-1");
            int len = in.readInt();
            this.profiles = new TaggedProfile[len];
            for (int i = 0; i < len; ++i) {
                this.profiles[i] = new TaggedProfile();
                this.profiles[i].read(in);
            }
        }
        catch (IOException ex) {
            throw new Error("failed to marshal IOR", ex);
        }
    }

    void write(DataOutput out) {
        try {
            byte[] string = this.type_id.getBytes("ISO-8859-1");
            out.writeInt(string.length + 1);
            out.write(string, 0, string.length);
            out.write(0);
            out.writeInt(this.profiles.length);
            for (int i = 0; i < this.profiles.length; ++i) {
                this.profiles[i].write(out);
            }
        }
        catch (IOException ex) {
            throw new Error("failed to marshal IOR", ex);
        }
    }

    static class TaggedProfile {
        int tag;
        byte[] profile_data;

        TaggedProfile() {
        }

        void read(InputStream in) {
            this.tag = in.read_ulong();
            int len = in.read_ulong();
            this.profile_data = new byte[len];
            in.read_octet_array(this.profile_data, 0, len);
        }

        void write(OutputStream out) {
            out.write_ulong(this.tag);
            out.write_ulong(this.profile_data.length);
            out.write_octet_array(this.profile_data, 0, this.profile_data.length);
        }

        void read(DataInput in) throws IOException {
            this.tag = in.readInt();
            int len = in.readInt();
            this.profile_data = new byte[len];
            in.readFully(this.profile_data, 0, len);
        }

        void write(DataOutput out) throws IOException {
            out.writeInt(this.tag);
            out.writeInt(this.profile_data.length);
            out.write(this.profile_data, 0, this.profile_data.length);
        }
    }
}

